/*
 * Decompiled with CFR 0.152.
 */
package net.spell_engine.client.particle;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.RisingParticle;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.core.particles.SimpleParticleType;
import net.spell_engine.client.util.Color;
import net.spell_power.api.SpellSchools;
import org.jetbrains.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
public class SpellFlameParticle
extends RisingParticle {
    boolean glow = true;
    boolean translucent = false;
    private SpriteSet spriteProviderForAnimation = null;

    public SpellFlameParticle(ClientLevel clientWorld, double d, double e, double f, double g, double h, double i) {
        super(clientWorld, d, e, f, g, h, i);
    }

    public ParticleRenderType m_7556_() {
        return this.translucent ? ParticleRenderType.f_107431_ : ParticleRenderType.f_107432_;
    }

    public void m_6257_(double dx, double dy, double dz) {
        this.m_107259_(this.m_107277_().m_82386_(dx, dy, dz));
        this.m_107275_();
    }

    public float m_5902_(float tickDelta) {
        float f = ((float)this.f_107224_ + tickDelta) / (float)this.f_107225_;
        return this.f_107663_ * (1.0f - f * f * 0.5f);
    }

    public int m_6355_(float tint) {
        if (this.glow) {
            return 255;
        }
        return super.m_6355_(tint);
    }

    public void m_5989_() {
        super.m_5989_();
        if (this.spriteProviderForAnimation != null) {
            this.m_108339_(this.spriteProviderForAnimation);
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static class RageSignFactory
    extends PopupSignFactory {
        public RageSignFactory(SpriteSet spriteProvider) {
            super(spriteProvider, Color.RAGE);
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static class PopupSignFactory
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet spriteProvider;
        public Color color = Color.from(0xFFFFFF);

        public PopupSignFactory(SpriteSet spriteProvider, Color color) {
            this.spriteProvider = spriteProvider;
            this.color = color;
        }

        @Nullable
        public Particle createParticle(SimpleParticleType defaultParticleType, ClientLevel clientWorld, double d, double e, double f, double g, double h, double i) {
            SpellFlameParticle particle = new SpellFlameParticle(clientWorld, d, e, f, g, h, i);
            particle.m_108335_(this.spriteProvider);
            particle.m_107253_(this.color.red(), this.color.green(), this.color.blue());
            particle.f_172258_ = 0.6f;
            particle.f_107663_ = 0.4f;
            particle.f_107225_ = 40;
            particle.f_107230_ = 0.9f;
            particle.translucent = true;
            return particle;
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static class BuffRageFactory
    extends BuffFactory {
        public BuffRageFactory(SpriteSet spriteProvider) {
            super(spriteProvider, Color.RAGE);
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static class BuffFactory
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet spriteProvider;
        public Color color = Color.from(0xFFFFFF);

        public BuffFactory(SpriteSet spriteProvider, Color color) {
            this.spriteProvider = spriteProvider;
            this.color = color;
        }

        @Nullable
        public Particle createParticle(SimpleParticleType defaultParticleType, ClientLevel clientWorld, double d, double e, double f, double g, double h, double i) {
            SpellFlameParticle particle = new SpellFlameParticle(clientWorld, d, e, f, g, h, i);
            particle.m_108335_(this.spriteProvider);
            float j = clientWorld.f_46441_.m_188501_() * 0.5f + 0.35f;
            particle.m_107253_(this.color.red() * j, this.color.green() * j, this.color.blue() * j);
            particle.f_107225_ = 16;
            particle.translucent = true;
            return particle;
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static class NatureSlowingFactory
    extends NatureFactory {
        public NatureSlowingFactory(SpriteSet spriteProvider) {
            super(spriteProvider);
        }

        @Override
        @Nullable
        public Particle createParticle(SimpleParticleType defaultParticleType, ClientLevel clientWorld, double d, double e, double f, double g, double h, double i) {
            SpellFlameParticle particle = (SpellFlameParticle)super.createParticle(defaultParticleType, clientWorld, d, e, f, g, h, i);
            particle.f_172258_ = 0.8f;
            return particle;
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static class WhiteFactory
    extends ColorableFactory {
        public WhiteFactory(SpriteSet spriteProvider) {
            super(spriteProvider, Color.WHITE);
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static class NatureFactory
    extends ColorableFactory {
        public NatureFactory(SpriteSet spriteProvider) {
            super(spriteProvider, Color.NATURE);
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static class HolyFactory
    extends ColorableFactory {
        public HolyFactory(SpriteSet spriteProvider) {
            super(spriteProvider, Color.HOLY);
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static class HealingFactory
    extends ColorableFactory {
        public HealingFactory(SpriteSet spriteProvider) {
            super(spriteProvider, Color.from(SpellSchools.HEALING.color));
        }
    }

    public static class ColorableFactory
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet spriteProvider;
        public Color color = Color.from(0xFFFFFF);

        public ColorableFactory(SpriteSet spriteProvider, Color color) {
            this.spriteProvider = spriteProvider;
            this.color = color;
        }

        @Nullable
        public Particle createParticle(SimpleParticleType defaultParticleType, ClientLevel clientWorld, double d, double e, double f, double g, double h, double i) {
            SpellFlameParticle particle = new SpellFlameParticle(clientWorld, d, e, f, g, h, i);
            particle.m_108335_(this.spriteProvider);
            float j = clientWorld.f_46441_.m_188501_() * 0.5f + 0.35f;
            particle.m_107253_(this.color.red() * j, this.color.green() * j, this.color.blue() * j);
            return particle;
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static class FrostShard
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet spriteProvider;
        public static Color color = Color.FROST;

        public FrostShard(SpriteSet spriteProvider) {
            this.spriteProvider = spriteProvider;
        }

        public Particle createParticle(SimpleParticleType defaultParticleType, ClientLevel clientWorld, double d, double e, double f, double g, double h, double i) {
            SpellFlameParticle particle = new SpellFlameParticle(clientWorld, d, e, f, g, h, i);
            particle.m_108335_(this.spriteProvider);
            float j = clientWorld.f_46441_.m_188501_() * 0.5f + 0.35f;
            particle.m_107253_(color.red() * j, color.green() * j, color.blue() * j);
            particle.f_107216_ *= clientWorld.f_46441_.m_188501_() * 0.2f + 0.9f;
            particle.f_107225_ = Math.round(clientWorld.f_46441_.m_188501_() * 3.0f) + 5;
            return particle;
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static class MediumFlameFactory
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet spriteProvider;

        public MediumFlameFactory(SpriteSet spriteProvider) {
            this.spriteProvider = spriteProvider;
        }

        public Particle createParticle(SimpleParticleType defaultParticleType, ClientLevel clientWorld, double d, double e, double f, double g, double h, double i) {
            SpellFlameParticle particle = new SpellFlameParticle(clientWorld, d, e, f, g, h, i);
            particle.m_108335_(this.spriteProvider);
            particle.spriteProviderForAnimation = this.spriteProvider;
            particle.f_107663_ = 0.5f;
            particle.f_107225_ = (int)((double)particle.f_107225_ * 0.5);
            return particle;
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static class WeaknessSmokeFactory
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet spriteProvider;
        public Color color = Color.from(0x993333);

        public WeaknessSmokeFactory(SpriteSet spriteProvider) {
            this.spriteProvider = spriteProvider;
        }

        public Particle createParticle(SimpleParticleType defaultParticleType, ClientLevel clientWorld, double d, double e, double f, double g, double h, double i) {
            SpellFlameParticle particle = new SpellFlameParticle(clientWorld, d, e, f, g, h, i);
            particle.m_108335_(this.spriteProvider);
            float j = clientWorld.f_46441_.m_188501_() * 0.5f + 0.35f;
            particle.m_107253_(this.color.red() * j, this.color.green() * j, this.color.blue() * j);
            particle.spriteProviderForAnimation = this.spriteProvider;
            particle.f_172258_ = 0.8f;
            particle.m_107271_(0.7f);
            particle.glow = false;
            particle.f_107226_ = 0.01f;
            return particle;
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static class SmokeFactory
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet spriteProvider;

        public SmokeFactory(SpriteSet spriteProvider) {
            this.spriteProvider = spriteProvider;
        }

        public Particle createParticle(SimpleParticleType defaultParticleType, ClientLevel clientWorld, double d, double e, double f, double g, double h, double i) {
            SpellFlameParticle particle = new SpellFlameParticle(clientWorld, d, e, f, g, h, i);
            particle.m_108335_(this.spriteProvider);
            particle.m_107253_(1.0f, 1.0f, 1.0f);
            particle.spriteProviderForAnimation = this.spriteProvider;
            particle.f_172258_ = 0.8f;
            particle.m_107271_(0.8f);
            particle.glow = false;
            particle.f_107226_ = -0.01f;
            return particle;
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static class ElectricSparkFactory
    extends ColoredAnimatedFactory {
        public ElectricSparkFactory(SpriteSet spriteProvider) {
            super(Color.ELECTRIC, 0.75f, spriteProvider);
            this.randomColorRange = 0.0f;
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static class ColoredAnimatedFactory
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet spriteProvider;
        private final Color color;
        private final float scale;
        protected float randomColorFloor = 0.5f;
        protected float randomColorRange = 0.35f;

        public ColoredAnimatedFactory(Color color, float scale, SpriteSet spriteProvider) {
            this.spriteProvider = spriteProvider;
            this.color = color;
            this.scale = scale;
        }

        public Particle createParticle(SimpleParticleType defaultParticleType, ClientLevel clientWorld, double d, double e, double f, double g, double h, double i) {
            SpellFlameParticle particle = new SpellFlameParticle(clientWorld, d, e, f, g, h, i);
            particle.m_108335_(this.spriteProvider);
            particle.spriteProviderForAnimation = this.spriteProvider;
            float red = this.color.red();
            float green = this.color.green();
            float blue = this.color.blue();
            if (this.randomColorRange > 0.0f) {
                red = (clientWorld.f_46441_.m_188501_() * this.randomColorFloor + this.randomColorRange) * red;
                green = (clientWorld.f_46441_.m_188501_() * this.randomColorFloor + this.randomColorRange) * green;
                blue = (clientWorld.f_46441_.m_188501_() * this.randomColorFloor + this.randomColorRange) * blue;
            }
            float j = clientWorld.f_46441_.m_188501_() * 0.5f + 0.35f;
            particle.m_107253_(red, green, blue);
            particle.f_107663_ = this.scale;
            particle.m_107271_(1.0f);
            return particle;
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static class AnimatedFlameFactory
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet spriteProvider;

        public AnimatedFlameFactory(SpriteSet spriteProvider) {
            this.spriteProvider = spriteProvider;
        }

        public Particle createParticle(SimpleParticleType defaultParticleType, ClientLevel clientWorld, double d, double e, double f, double g, double h, double i) {
            SpellFlameParticle particle = new SpellFlameParticle(clientWorld, d, e, f, g, h, i);
            particle.m_108335_(this.spriteProvider);
            particle.spriteProviderForAnimation = this.spriteProvider;
            return particle;
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static class FlameFactory
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet spriteProvider;

        public FlameFactory(SpriteSet spriteProvider) {
            this.spriteProvider = spriteProvider;
        }

        public Particle createParticle(SimpleParticleType defaultParticleType, ClientLevel clientWorld, double d, double e, double f, double g, double h, double i) {
            SpellFlameParticle particle = new SpellFlameParticle(clientWorld, d, e, f, g, h, i);
            particle.m_108335_(this.spriteProvider);
            return particle;
        }
    }
}

