/*
 * Decompiled with CFR 0.152.
 */
package net.spell_engine.client.particle;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.util.RandomSource;
import net.spell_engine.client.util.Color;
import net.spell_power.api.SpellSchools;

public class GenericSpellParticle
extends TextureSheetParticle {
    private static final RandomSource RANDOM = RandomSource.m_216327_();
    private final SpriteSet spriteProvider;

    GenericSpellParticle(ClientLevel world, double x, double y, double z, double velocityX, double velocityY, double velocityZ, SpriteSet spriteProvider) {
        super(world, x, y, z, 0.5 - RANDOM.m_188500_(), velocityY, 0.5 - RANDOM.m_188500_());
        this.f_172258_ = 0.96f;
        this.f_107226_ = -0.1f;
        this.f_172259_ = true;
        this.spriteProvider = spriteProvider;
        this.f_107216_ *= 0.2;
        if (velocityX == 0.0 && velocityZ == 0.0) {
            this.f_107215_ *= (double)0.1f;
            this.f_107217_ *= (double)0.1f;
        }
        this.f_107663_ *= 0.75f;
        this.f_107225_ = (int)(8.0 / (Math.random() * 0.8 + 0.2));
        this.f_107219_ = false;
        this.m_108339_(spriteProvider);
    }

    public ParticleRenderType m_7556_() {
        return ParticleRenderType.f_107431_;
    }

    public int m_6355_(float tint) {
        return 255;
    }

    @Environment(value=EnvType.CLIENT)
    public static class ArcaneSparkFactory
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet spriteProvider;
        public static Color color = Color.from(SpellSchools.ARCANE.color);

        public ArcaneSparkFactory(SpriteSet spriteProvider) {
            this.spriteProvider = spriteProvider;
        }

        public Particle createParticle(SimpleParticleType defaultParticleType, ClientLevel clientWorld, double d, double e, double f, double g, double h, double i) {
            GenericSpellParticle spellParticle = new GenericSpellParticle(clientWorld, d, e, f, g, h, i, this.spriteProvider);
            float j = clientWorld.f_46441_.m_188501_() * 0.5f + 0.35f;
            spellParticle.m_107253_(color.red() * j, color.green() * j, color.blue() * j);
            spellParticle.f_107230_ = 0.5f;
            return spellParticle;
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static class HolySpellFactory
    extends SpellFactory
    implements ParticleProvider<SimpleParticleType> {
        public HolySpellFactory(SpriteSet spriteProvider) {
            super(spriteProvider, Color.from(0xFFFFCC));
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static class ArcaneSpellFactory
    extends SpellFactory
    implements ParticleProvider<SimpleParticleType> {
        public ArcaneSpellFactory(SpriteSet spriteProvider) {
            super(spriteProvider, Color.from(SpellSchools.ARCANE.color));
        }
    }

    @Environment(value=EnvType.CLIENT)
    static class SpellFactory
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet spriteProvider;
        public final Color color;

        public SpellFactory(SpriteSet spriteProvider, Color color) {
            this.spriteProvider = spriteProvider;
            this.color = color;
        }

        public Particle createParticle(SimpleParticleType defaultParticleType, ClientLevel clientWorld, double d, double e, double f, double g, double h, double i) {
            GenericSpellParticle spellParticle = new GenericSpellParticle(clientWorld, d, e, f, g, h, i, this.spriteProvider);
            float j = clientWorld.f_46441_.m_188501_() * 0.5f + 0.35f;
            spellParticle.m_107253_(this.color.red() * j, this.color.green() * j, this.color.blue() * j);
            return spellParticle;
        }
    }
}

