/*
 * Decompiled with CFR 0.152.
 */
package net.spell_engine.client.input;

import net.fabric_extras.ranged_weapon.api.EntityAttributes_RangedWeapon;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ServerboundPlayerActionPacket;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.spell_engine.api.spell.SpellContainer;
import net.spell_engine.compat.TrinketsCompat;
import net.spell_engine.internals.SpellContainerHelper;
import org.jetbrains.annotations.Nullable;

public class AutoSwapHelper {
    public static boolean autoSwapForAttack() {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null || player.m_5833_()) {
            return false;
        }
        ItemStack mainHand = player.m_21205_();
        ItemStack offHand = (ItemStack)player.m_150109_().f_35976_.get(0);
        if (mainHand.m_41619_() || offHand.m_41619_() || AutoSwapHelper.isPlaceable(mainHand) || !AutoSwapHelper.isAnyWeapon(mainHand) || !AutoSwapHelper.hasSpells(mainHand) && !AutoSwapHelper.isUsable(mainHand)) {
            return false;
        }
        if (!AutoSwapHelper.isMeleeWeapon(mainHand) && AutoSwapHelper.isMeleeWeapon(offHand)) {
            AutoSwapHelper.swapHeldItems();
            return true;
        }
        return false;
    }

    public static boolean autoSwapForSpells() {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null || player.m_5833_()) {
            return false;
        }
        ItemStack mainHand = player.m_21205_();
        ItemStack offHand = (ItemStack)player.m_150109_().f_35976_.get(0);
        if (mainHand.m_41619_() || offHand.m_41619_() || AutoSwapHelper.isUsable(mainHand) || !AutoSwapHelper.isAnyWeapon(mainHand) || !AutoSwapHelper.isAnyWeapon(offHand)) {
            return false;
        }
        SpellContainer.ContentType mainHandType = AutoSwapHelper.spellContentType(mainHand);
        SpellContainer.ContentType offHandType = AutoSwapHelper.spellContentType(offHand);
        SpellContainer.ContentType spellbookType = AutoSwapHelper.spellContentType(TrinketsCompat.getSpellBookStack((Player)player));
        if (spellbookType != null && !AutoSwapHelper.hasSpells(mainHand) && mainHandType != spellbookType && offHandType == spellbookType) {
            AutoSwapHelper.swapHeldItems();
            return true;
        }
        return false;
    }

    public static void swapHeldItems() {
        Minecraft.m_91087_().m_91403_().m_104955_((Packet)new ServerboundPlayerActionPacket(ServerboundPlayerActionPacket.Action.SWAP_ITEM_WITH_OFFHAND, BlockPos.f_121853_, Direction.DOWN));
    }

    public static boolean isPlaceable(ItemStack itemStack) {
        return itemStack.m_41720_() instanceof BlockItem;
    }

    public static boolean isUsable(ItemStack itemStack) {
        return itemStack.m_41780_() != UseAnim.NONE;
    }

    public static boolean isMeleeWeapon(ItemStack itemStack) {
        return itemStack.m_41638_(EquipmentSlot.MAINHAND).containsKey((Object)Attributes.f_22281_) && itemStack.m_41638_(EquipmentSlot.MAINHAND).containsKey((Object)Attributes.f_22283_);
    }

    public static boolean isAnyWeapon(ItemStack itemStack) {
        if (AutoSwapHelper.isMeleeWeapon(itemStack)) {
            return true;
        }
        return FabricLoader.getInstance().isModLoaded("ranged_weapon_api") && itemStack.m_41638_(EquipmentSlot.MAINHAND).containsKey((Object)EntityAttributes_RangedWeapon.DAMAGE.attribute);
    }

    @Nullable
    private static SpellContainer.ContentType spellContentType(ItemStack itemStack) {
        SpellContainer container = SpellContainerHelper.containerFromItemStack(itemStack);
        if (container != null) {
            return container.content;
        }
        return null;
    }

    private static boolean hasSpells(ItemStack itemStack) {
        SpellContainer container = SpellContainerHelper.containerFromItemStack(itemStack);
        if (container != null) {
            return !container.spell_ids.isEmpty();
        }
        return false;
    }
}

