/*
 * Decompiled with CFR 0.152.
 */
package net.spell_engine.client.gui;

import java.util.Locale;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.spell_engine.api.effect.EntityActionsAllowed;
import net.spell_engine.client.SpellEngineClient;
import net.spell_engine.internals.casting.SpellCast;

public class HudMessages {
    public static final HudMessages INSTANCE = new HudMessages();
    public static final int DEFAULT_ERROR_MESSAGE_DURATION = 20;
    public static final int DEFAULT_ERROR_MESSAGE_FADEOUT = 10;
    private ErrorMessageState currentError;
    private static final String castAttemptPrefix = "hud.cast_attempt_error.";
    private boolean attemptDisplayed = false;

    public void castAttemptError(SpellCast.Attempt attempt) {
        if (this.attemptDisplayed) {
            return;
        }
        if (attempt.isSuccess() || attempt.isFail()) {
            this.attemptDisplayed = true;
        }
        if (!attempt.isFail() || !SpellEngineClient.config.showSpellCastErrors) {
            return;
        }
        String translationKey = castAttemptPrefix + attempt.result().toString().toLowerCase(Locale.ENGLISH);
        MutableComponent message = null;
        switch (attempt.result()) {
            case MISSING_ITEM: {
                String itemName = attempt.missingItem().item().m_41466_().getString();
                message = Component.m_237110_((String)translationKey, (Object[])new Object[]{itemName});
                break;
            }
            case ON_COOLDOWN: {
                message = Component.m_237115_((String)translationKey);
            }
        }
        if (message != null) {
            this.error((Component)message.m_130940_(ChatFormatting.RED));
        }
    }

    public void actionImpaired(EntityActionsAllowed.SemanticType reason) {
        this.error(I18n.m_118938_((String)("hud.action_impaired." + reason.toString().toLowerCase(Locale.ENGLISH)), (Object[])new Object[0]));
    }

    public void error(String message) {
        this.error(message, 20, 10);
    }

    public void error(String message, int duration, int fadeOut) {
        this.currentError = new ErrorMessageState(message, duration, fadeOut);
    }

    public void error(Component text) {
        this.error(text, 20, 10);
    }

    public void error(Component text, int duration, int fadeOut) {
        this.currentError = new ErrorMessageState(text, duration, fadeOut);
    }

    public void tick() {
        if (this.currentError != null) {
            if (this.currentError.durationLeft <= 0) {
                this.currentError = null;
            } else {
                --this.currentError.durationLeft;
            }
        }
        Minecraft client = Minecraft.m_91087_();
        if (!client.f_91066_.f_92095_.m_90857_()) {
            this.attemptDisplayed = false;
        }
    }

    public ErrorMessageState currentError() {
        return this.currentError;
    }

    public static class ErrorMessageState {
        public Component message;
        public int durationLeft;
        public int fadeOut;

        public ErrorMessageState(String message, int durationLeft, int fadeOut) {
            this.message = Component.m_237113_((String)message).m_130940_(ChatFormatting.RED);
            this.durationLeft = durationLeft;
            this.fadeOut = fadeOut;
        }

        public ErrorMessageState(Component message, int durationLeft, int fadeOut) {
            this.message = message;
            this.durationLeft = durationLeft;
            this.fadeOut = fadeOut;
        }
    }
}

