/*
 * Decompiled with CFR 0.152.
 */
package net.spell_engine.api.spell;

import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.spell_engine.api.spell.Spell;
import net.spell_power.api.SpellSchool;
import net.spell_power.api.SpellSchools;
import org.jetbrains.annotations.Nullable;

public record SpellPool(List<ResourceLocation> spellIds, List<SpellSchool> schools, boolean craftable) {
    public static final SpellPool empty = new SpellPool(List.of(), List.of(), true);

    public boolean isEmpty() {
        return this.spellIds.isEmpty();
    }

    @Nullable
    public SpellSchool firstSchool() {
        return this.schools().stream().findFirst().orElse(null);
    }

    public static SpellPool fromData(DataFormat json, Map<ResourceLocation, Spell> spells) {
        LinkedHashSet<ResourceLocation> spellsIds = new LinkedHashSet<ResourceLocation>();
        LinkedHashSet<SpellSchool> schools = new LinkedHashSet<SpellSchool>();
        if (json.spell_ids != null) {
            for (String idString : json.spell_ids) {
                ResourceLocation id = new ResourceLocation(idString);
                Spell spell = spells.get(id);
                if (spell == null) continue;
                spellsIds.add(id);
                schools.add(spell.school);
            }
        }
        if (json.all_of_schools != null) {
            List<SpellSchool> allOfSchools = json.all_of_schools.stream().map(SpellSchools::getSchool).toList();
            for (Map.Entry<ResourceLocation, Spell> entry : spells.entrySet()) {
                ResourceLocation id = entry.getKey();
                Spell spell = entry.getValue();
                if (!allOfSchools.contains(spell.school)) continue;
                spellsIds.add(id);
                schools.add(spell.school);
            }
        }
        return new SpellPool(spellsIds.stream().toList(), schools.stream().toList(), json.creatable_as_spellbook);
    }

    public SyncFormat toSync() {
        SyncFormat formatted = new SyncFormat();
        formatted.spell_ids = this.spellIds.stream().map(ResourceLocation::toString).toList();
        formatted.schools = this.schools.stream().map(school -> school.id.toString()).toList();
        formatted.craftable = this.craftable();
        return formatted;
    }

    public static SpellPool fromSync(SyncFormat json) {
        return new SpellPool(json.spell_ids.stream().map(ResourceLocation::new).toList(), json.schools.stream().map(SpellSchools::getSchool).toList(), json.craftable);
    }

    public static class DataFormat {
        public List<String> spell_ids = List.of();
        public List<String> all_of_schools = List.of();
        public boolean creatable_as_spellbook = true;
    }

    public static class SyncFormat {
        public List<String> spell_ids = List.of();
        public List<String> schools = List.of();
        boolean craftable;
    }
}

