/*
 * Decompiled with CFR 0.152.
 */
package net.spell_engine.api.spell;

import net.fabric_extras.ranged_weapon.api.EntityAttributes_RangedWeapon;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.spell_power.api.SpellSchool;
import net.spell_power.api.SpellSchools;

public class ExternalSpellSchools {
    public static final SpellSchool PHYSICAL_MELEE = new SpellSchool(SpellSchool.Archetype.MELEE, new ResourceLocation("spell_power", "physical_melee"), 0xB3B3B3, DamageTypes.f_268464_, Attributes.f_22281_);
    public static final SpellSchool PHYSICAL_RANGED = new SpellSchool(SpellSchool.Archetype.ARCHERY, new ResourceLocation("spell_power", "physical_ranged"), 8412749, DamageTypes.f_268739_, ExternalSpellSchools.rangedDamageAttribute());
    private static boolean initialized = false;

    private static Attribute rangedDamageAttribute() {
        if (FabricLoader.getInstance().isModLoaded("ranged_weapon_api")) {
            return EntityAttributes_RangedWeapon.DAMAGE.attribute;
        }
        return Attributes.f_22281_;
    }

    public static void initialize() {
        if (initialized) {
            return;
        }
        Attributes.f_22281_.m_22084_(true);
        ExternalSpellSchools.PHYSICAL_MELEE.attributeManagement = SpellSchool.Manage.EXTERNAL;
        PHYSICAL_MELEE.addSource(SpellSchool.Trait.POWER, SpellSchool.Apply.ADD, query -> {
            double power = query.entity().m_21133_(Attributes.f_22281_);
            int level = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44977_, (ItemStack)query.entity().m_21205_());
            return power *= 1.0 + 0.05 * (double)level;
        });
        SpellSchools.configureSpellHaste((SpellSchool)PHYSICAL_MELEE);
        SpellSchools.register((SpellSchool)PHYSICAL_MELEE);
        ExternalSpellSchools.PHYSICAL_RANGED.attributeManagement = SpellSchool.Manage.EXTERNAL;
        if (FabricLoader.getInstance().isModLoaded("ranged_weapon_api")) {
            PHYSICAL_RANGED.addSource(SpellSchool.Trait.POWER, SpellSchool.Apply.ADD, query -> {
                double power = query.entity().m_21133_(EntityAttributes_RangedWeapon.DAMAGE.attribute);
                int level = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44988_, (ItemStack)query.entity().m_21205_());
                return power *= 1.0 + 0.05 * (double)level;
            });
            PHYSICAL_RANGED.addSource(SpellSchool.Trait.HASTE, SpellSchool.Apply.ADD, query -> {
                double haste = query.entity().m_21133_(EntityAttributes_RangedWeapon.HASTE.attribute);
                double rate = EntityAttributes_RangedWeapon.HASTE.asMultiplier(haste);
                return rate - 1.0;
            });
        }
        SpellSchools.register((SpellSchool)PHYSICAL_RANGED);
        initialized = true;
    }
}

