/*
 * Decompiled with CFR 0.152.
 */
package net.spell_engine.api.render;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.VertexFormat;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.resources.ResourceLocation;
import net.spell_engine.api.render.LightEmission;

public class CustomLayers
extends RenderType {
    protected static final RenderStateShard.TransparencyStateShard BEAM_TRANSPARENCY = new RenderStateShard.TransparencyStateShard("beam_transparency", () -> {
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
    }, () -> {
        RenderSystem.disableBlend();
        RenderSystem.defaultBlendFunc();
    });

    public CustomLayers(String name, VertexFormat vertexFormat, VertexFormat.Mode drawMode, int expectedBufferSize, boolean hasCrumbling, boolean translucent, Runnable startAction, Runnable endAction) {
        super(name, vertexFormat, drawMode, expectedBufferSize, hasCrumbling, translucent, startAction, endAction);
    }

    public static RenderType beam(ResourceLocation texture, boolean cull, boolean transparent) {
        RenderType.CompositeState multiPhaseParameters = RenderType.CompositeState.m_110628_().m_173292_(f_173068_).m_110661_(cull ? f_110158_ : f_110110_).m_173290_((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(texture, false, false)).m_110685_(transparent ? BEAM_TRANSPARENCY : f_110134_).m_110687_(transparent ? f_110114_ : f_110114_).m_110691_(false);
        return RenderType.m_173215_((String)"spell_beam", (VertexFormat)DefaultVertexFormat.f_85811_, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)256, (boolean)false, (boolean)true, (RenderType.CompositeState)multiPhaseParameters);
    }

    @Deprecated
    public static RenderType projectile(ResourceLocation texture, boolean translucent) {
        return CustomLayers.projectile(texture, translucent, true);
    }

    @Deprecated
    public static RenderType projectile(ResourceLocation texture, boolean translucent, boolean emissive) {
        RenderType.CompositeState multiPhaseParameters = RenderType.CompositeState.m_110628_().m_173292_(emissive ? f_234323_ : f_173066_).m_173290_((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(texture, false, false)).m_110685_(translucent ? f_110139_ : f_110134_).m_110661_(f_110110_).m_110687_(translucent ? f_110115_ : f_110114_).m_110677_(f_110154_).m_110691_(false);
        return RenderType.m_173215_((String)"entity_translucent_emissive", (VertexFormat)DefaultVertexFormat.f_85812_, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)256, (boolean)true, (boolean)true, (RenderType.CompositeState)multiPhaseParameters);
    }

    public static RenderType spellEffect(LightEmission lightEmission, boolean translucent) {
        return CustomLayers.spellObject(TextureAtlas.f_118259_, lightEmission, translucent);
    }

    public static RenderType projectile(LightEmission lightEmission) {
        return CustomLayers.spellObject(TextureAtlas.f_118259_, lightEmission, false);
    }

    public static RenderType create(ResourceLocation texture, RenderStateShard.ShaderStateShard shaderProgram, RenderStateShard.TransparencyStateShard transparency, RenderStateShard.CullStateShard culling, RenderStateShard.WriteMaskStateShard writeMask, RenderStateShard.OverlayStateShard overlay, RenderStateShard.OutputStateShard target, boolean affectsOutline) {
        RenderType.CompositeState multiPhaseParameters = RenderType.CompositeState.m_110628_().m_173292_(shaderProgram).m_173290_((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(texture, false, false)).m_110685_(transparency).m_110661_(culling).m_110687_(writeMask).m_110677_(overlay).m_110675_(target).m_110691_(affectsOutline);
        return RenderType.m_173215_((String)"entity_translucent_emissive", (VertexFormat)DefaultVertexFormat.f_85812_, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)256, (boolean)true, (boolean)true, (RenderType.CompositeState)multiPhaseParameters);
    }

    public static RenderType spellObject(LightEmission lightEmission) {
        switch (lightEmission) {
            case RADIATE: 
            case GLOW: {
                return CustomLayers.spellObject(TextureAtlas.f_118259_, lightEmission, false);
            }
        }
        return RenderType.m_110473_((ResourceLocation)TextureAtlas.f_118259_);
    }

    public static RenderType spellObject(ResourceLocation texture, LightEmission lightEmission, boolean translucent) {
        RenderStateShard.ShaderStateShard shaderProgram = switch (lightEmission) {
            default -> throw new IncompatibleClassChangeError();
            case LightEmission.RADIATE -> f_234323_;
            case LightEmission.GLOW -> f_173068_;
            case LightEmission.NONE -> f_173066_;
        };
        RenderType.CompositeState multiPhaseParameters = RenderType.CompositeState.m_110628_().m_173292_(shaderProgram).m_173290_((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(texture, false, false)).m_110685_(translucent ? f_110139_ : f_110134_).m_110661_(f_110110_).m_110687_(translucent ? f_110115_ : f_110114_).m_110677_(f_110154_).m_110675_(f_110125_).m_110691_(false);
        return RenderType.m_173215_((String)"entity_translucent_emissive", (VertexFormat)DefaultVertexFormat.f_85812_, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)256, (boolean)true, (boolean)true, (RenderType.CompositeState)multiPhaseParameters);
    }

    public static RenderType create(String name, VertexFormat vertexFormat, VertexFormat.Mode drawMode, int expectedBufferSize, boolean hasCrumbling, boolean translucent, RenderType.CompositeState phases) {
        return RenderType.m_173215_((String)name, (VertexFormat)vertexFormat, (VertexFormat.Mode)drawMode, (int)expectedBufferSize, (boolean)hasCrumbling, (boolean)translucent, (RenderType.CompositeState)phases);
    }
}

