/*
 * Decompiled with CFR 0.152.
 */
package net.spell_engine.api.loot;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.LootPoolSingletonContainer;
import net.minecraft.world.level.storage.loot.entries.TagEntry;
import net.minecraft.world.level.storage.loot.functions.EnchantWithLevelsFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.providers.number.BinomialDistributionGenerator;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;
import net.spell_engine.api.loot.LootConfigV2;
import net.tinyconfig.ConfigManager;

public class LootHelper {
    public static ConfigManager<TagCache> TAG_CACHE = new ConfigManager("tag_cache", (Object)new TagCache()).builder().setDirectory("rpg_series").sanitize(true).build();

    public static void updateTagCache(LootConfigV2 lootConfig) {
        HashSet<String> updatedTags = new HashSet<String>();
        for (Map.Entry<String, LootConfigV2.Pool> entry : lootConfig.injectors.entrySet()) {
            String tableId = entry.getKey();
            LootConfigV2.Pool pool = entry.getValue();
            for (LootConfigV2.Pool.Entry itemInjectorEntry : pool.entries) {
                String tagString;
                String id = itemInjectorEntry.id;
                if (id == null || !id.startsWith("#") || updatedTags.contains(tagString = id.substring(1))) continue;
                ResourceLocation tagId = new ResourceLocation(tagString);
                TagKey tag = TagKey.m_203882_((ResourceKey)Registries.f_256913_, (ResourceLocation)tagId);
                ArrayList itemList = new ArrayList();
                BuiltInRegistries.f_257033_.m_206058_(tag).forEach(itemEntry -> {
                    ResourceLocation itemId = ((ResourceKey)itemEntry.m_203543_().get()).m_135782_();
                    itemList.add(itemId.toString());
                });
                ((TagCache)LootHelper.TAG_CACHE.value).cache.put(tagString, itemList);
                updatedTags.add(tagString);
            }
        }
        TAG_CACHE.save();
    }

    public static void configureV2(ResourceLocation id, LootTable.Builder tableBuilder, LootConfigV2 config, HashMap<String, Item> entries) {
        String tableId = id.toString();
        LootConfigV2.Pool pool = config.injectors.get(tableId);
        if (pool == null) {
            for (String regex : config.regex_injectors.keySet()) {
                if (!tableId.matches(regex)) continue;
                pool = config.regex_injectors.get(regex);
                break;
            }
        }
        if (pool == null) {
            return;
        }
        float rolls = pool.rolls > 0.0f ? pool.rolls : 1.0f;
        LootPool.Builder lootPoolBuilder = LootPool.m_79043_();
        double attempts = Math.ceil(rolls);
        double chance = (double)pool.rolls / attempts;
        lootPoolBuilder.m_165133_((NumberProvider)BinomialDistributionGenerator.m_165659_((int)((int)attempts), (float)((float)chance)));
        lootPoolBuilder.m_165135_((NumberProvider)ConstantValue.m_165692_((float)pool.bonus_rolls));
        for (LootConfigV2.Pool.Entry injectEntry : pool.entries) {
            String entryId = injectEntry.id;
            int weight = injectEntry.weight;
            LootConfigV2.Pool.Entry.Enchant enchant = injectEntry.enchant;
            if (entryId == null || entryId.isEmpty()) continue;
            if (entryId.startsWith("#")) {
                String tagString = entryId.substring(1);
                List<String> itemList = ((TagCache)LootHelper.TAG_CACHE.value).cache.get(tagString);
                if (itemList != null && !itemList.isEmpty()) {
                    for (String itemId : itemList) {
                        Item item = (Item)BuiltInRegistries.f_257033_.m_7745_(new ResourceLocation(itemId));
                        if (item == null) continue;
                        LootPoolSingletonContainer.Builder entry = LootItem.m_79579_((ItemLike)item).m_79707_(weight);
                        if (enchant != null && enchant.isValid()) {
                            EnchantWithLevelsFunction.Builder enchantFunction = EnchantWithLevelsFunction.m_165196_((NumberProvider)UniformGenerator.m_165780_((float)enchant.min_power, (float)enchant.max_power));
                            if (enchant.allow_treasure) {
                                enchantFunction.m_80499_();
                            }
                            entry.m_79078_((LootItemFunction.Builder)enchantFunction);
                        }
                        lootPoolBuilder.m_79076_((LootPoolEntryContainer.Builder)entry);
                    }
                    continue;
                }
                ResourceLocation tagId = new ResourceLocation(tagString);
                TagKey tag = TagKey.m_203882_((ResourceKey)Registries.f_256913_, (ResourceLocation)tagId);
                if (tag == null) continue;
                LootPoolSingletonContainer.Builder entry = TagEntry.m_205095_((TagKey)tag).m_79707_(weight);
                if (enchant != null && enchant.isValid()) {
                    EnchantWithLevelsFunction.Builder enchantFunction = EnchantWithLevelsFunction.m_165196_((NumberProvider)UniformGenerator.m_165780_((float)enchant.min_power, (float)enchant.max_power));
                    if (enchant.allow_treasure) {
                        enchantFunction.m_80499_();
                    }
                    entry.m_79078_((LootItemFunction.Builder)enchantFunction);
                }
                lootPoolBuilder.m_79076_((LootPoolEntryContainer.Builder)entry);
                continue;
            }
            Item item = entries.get(entryId);
            if (item == null) continue;
            LootPoolSingletonContainer.Builder entry = LootItem.m_79579_((ItemLike)item).m_79707_(weight);
            if (enchant != null && enchant.isValid()) {
                EnchantWithLevelsFunction.Builder enchantFunction = EnchantWithLevelsFunction.m_165196_((NumberProvider)UniformGenerator.m_165780_((float)enchant.min_power, (float)enchant.max_power));
                if (enchant.allow_treasure) {
                    enchantFunction.m_80499_();
                }
                entry.m_79078_((LootItemFunction.Builder)enchantFunction);
            }
            lootPoolBuilder.m_79076_((LootPoolEntryContainer.Builder)entry);
        }
        tableBuilder.pool(lootPoolBuilder.m_79082_());
    }

    public static class TagCache {
        public HashMap<String, List<String>> cache = new HashMap();
    }
}

