/*
 * Decompiled with CFR 0.152.
 */
package net.spell_engine.api.item.trinket;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import net.fabricmc.fabric.api.item.v1.FabricItemSettings;
import net.fabricmc.fabric.api.itemgroup.v1.ItemGroupEvents;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.spell_engine.api.item.trinket.SpellBookItem;
import net.spell_engine.api.item.trinket.SpellBookTrinketItem;
import net.spell_engine.api.item.trinket.SpellBookVanillaItem;
import net.spell_engine.api.spell.SpellContainer;
import net.spell_engine.api.spell.SpellPool;
import net.spell_engine.compat.TrinketsCompat;
import net.spell_engine.internals.SpellRegistry;

public class SpellBooks {
    public static final ArrayList<SpellBookItem> all = new ArrayList();

    public static List<SpellBookItem> sorted() {
        return all.stream().sorted(Comparator.comparing(spellBookItem -> spellBookItem.getPoolId().toString())).filter(spellBookItem -> {
            SpellPool pool = SpellRegistry.spellPool(spellBookItem.getPoolId());
            return pool != null && pool.craftable();
        }).collect(Collectors.toList());
    }

    public static SpellBookItem create(ResourceLocation poolId) {
        return SpellBooks.create(poolId, SpellContainer.ContentType.MAGIC);
    }

    public static SpellBookItem create(ResourceLocation poolId, SpellContainer.ContentType contentType) {
        SpellContainer container = new SpellContainer(contentType, false, poolId.toString(), 0, List.of());
        SpellRegistry.book_containers.put(SpellBooks.itemIdFor(poolId), container);
        SpellBookItem book = null;
        TrinketsCompat.init();
        book = TrinketsCompat.isEnabled() ? new SpellBookTrinketItem(poolId, (Item.Properties)new FabricItemSettings().maxCount(1)) : new SpellBookVanillaItem(poolId, (Item.Properties)new FabricItemSettings().maxCount(1));
        all.add(book);
        return book;
    }

    public static ResourceLocation itemIdFor(ResourceLocation poolId) {
        return new ResourceLocation(poolId.m_135827_(), poolId.m_135815_() + "_spell_book");
    }

    public static void register(SpellBookItem spellBook) {
        if (!(spellBook instanceof Item)) {
            throw new IllegalArgumentException("SpellBookItem must be an Item");
        }
        Registry.m_122965_((Registry)BuiltInRegistries.f_257033_, (ResourceLocation)SpellBooks.itemIdFor(spellBook.getPoolId()), (Object)((Item)spellBook));
    }

    public static void createAndRegister(ResourceLocation poolId, ResourceKey<CreativeModeTab> itemGroupKey) {
        SpellBooks.createAndRegister(poolId, SpellContainer.ContentType.MAGIC, itemGroupKey);
    }

    public static void createAndRegister(ResourceLocation poolId, SpellContainer.ContentType contentType, ResourceKey<CreativeModeTab> itemGroupKey) {
        SpellBookItem item = SpellBooks.create(poolId, contentType);
        ItemGroupEvents.modifyEntriesEvent(itemGroupKey).register(content -> content.m_246326_((ItemLike)item));
        SpellBooks.register(item);
    }
}

