/*
 * Decompiled with CFR 0.152.
 */
package net.spell_engine.api.item.armor;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.fabricmc.fabric.api.itemgroup.v1.ItemGroupEvents;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.LazyLoadedValue;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.spell_engine.api.item.AttributeResolver;
import net.spell_engine.api.item.ConfigurableAttributes;
import net.spell_engine.api.item.ItemConfig;

public class Armor {
    private static final UUID[] MODIFIERS = new UUID[]{UUID.fromString("845DB27C-C624-495F-8C9F-6020A9A58B6B"), UUID.fromString("D8499B04-0E66-4726-AB29-64469D734E0D"), UUID.fromString("9F3D476D-C118-4544-8365-64846904B48E"), UUID.fromString("2AD3F246-FEE1-4E67-B886-69FD380BB150")};

    public static void register(Map<String, ItemConfig.ArmorSet> configs, List<Entry> entries, ResourceKey<CreativeModeTab> itemGroupKey) {
        for (Entry entry : entries) {
            ItemConfig.ArmorSet config = configs.get(entry.name());
            if (config == null) {
                config = entry.defaults();
                configs.put(entry.name(), config);
            }
            entry.material().configure(config);
            for (Object piece : entry.armorSet().pieces()) {
                EquipmentSlot slot = ((ArmorItem)piece).m_40402_();
                ((ConfigurableAttributes)piece).setAttributes(Armor.attributesFrom(config, slot));
            }
            entry.armorSet().register(itemGroupKey);
        }
    }

    private static Multimap<Attribute, AttributeModifier> attributesFrom(ItemConfig.ArmorSet config, EquipmentSlot slot) {
        ItemConfig.ArmorSet.Piece piece = null;
        UUID uuid = MODIFIERS[slot.m_20749_()];
        switch (slot) {
            case FEET: {
                piece = config.feet;
                break;
            }
            case LEGS: {
                piece = config.legs;
                break;
            }
            case CHEST: {
                piece = config.chest;
                break;
            }
            case HEAD: {
                piece = config.head;
            }
        }
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        if (config.armor_toughness != 0.0f) {
            builder.put((Object)Attributes.f_22285_, (Object)new AttributeModifier(uuid, "Armor modifier", (double)config.armor_toughness, AttributeModifier.Operation.ADDITION));
        }
        if (config.knockback_resistance != 0.0f) {
            builder.put((Object)Attributes.f_22278_, (Object)new AttributeModifier(uuid, "Armor modifier", (double)config.knockback_resistance, AttributeModifier.Operation.ADDITION));
        }
        if (piece.armor != 0) {
            builder.put((Object)Attributes.f_22284_, (Object)new AttributeModifier(uuid, "Armor modifier", (double)piece.armor, AttributeModifier.Operation.ADDITION));
        }
        for (ItemConfig.Attribute attribute : piece.attributes) {
            try {
                Attribute entityAttribute = AttributeResolver.get(new ResourceLocation(attribute.id));
                builder.put((Object)entityAttribute, (Object)new AttributeModifier(uuid, "Armor modifier", (double)attribute.value, attribute.operation));
            }
            catch (Exception e) {
                System.err.println("Failed to add item attribute modifier: " + e.getMessage());
            }
        }
        return builder.build();
    }

    public record Entry(CustomMaterial material, Set armorSet, ItemConfig.ArmorSet defaults) {
        public String name() {
            return this.material.m_6082_();
        }

        @Deprecated
        public <T extends ArmorItem> Set<T> armorSet(Function<CustomMaterial, Set<T>> factory, ArrayList<Entry> entries) {
            Set<T> armorSet = factory.apply(this.material);
            entries.add(new Entry(this.material, armorSet, this.defaults));
            return armorSet;
        }

        public <T extends ArmorItem> Entry bundle(Function<CustomMaterial, Set<T>> factory) {
            Set<T> armorSet = factory.apply(this.material);
            return new Entry(this.material, armorSet, this.defaults);
        }

        public <T extends ArmorItem> Entry put(ArrayList<Entry> list) {
            list.add(this);
            return this;
        }
    }

    public static class CustomMaterial
    implements ArmorMaterial {
        private static final EnumMap<ArmorItem.Type, Integer> BASE_DURABILITY = new EnumMap<ArmorItem.Type, Integer>(Map.of(ArmorItem.Type.BOOTS, 13, ArmorItem.Type.LEGGINGS, 15, ArmorItem.Type.CHESTPLATE, 16, ArmorItem.Type.HELMET, 11));
        private final String name;
        private final int durabilityMultiplier;
        private final int enchantability;
        private final SoundEvent equipSound;
        private final LazyLoadedValue<Ingredient> repairIngredientSupplier;
        private EnumMap<ArmorItem.Type, Integer> protectionAmounts;
        private float toughness;
        private float knockbackResistance;

        public CustomMaterial(String name, int durabilityMultiplier, int enchantability, SoundEvent equipSound, Supplier<Ingredient> repairIngredientSupplier) {
            this.name = name;
            this.durabilityMultiplier = durabilityMultiplier;
            this.enchantability = enchantability;
            this.equipSound = equipSound;
            this.repairIngredientSupplier = new LazyLoadedValue(repairIngredientSupplier);
            this.protectionAmounts = new EnumMap<ArmorItem.Type, Integer>(Map.of(ArmorItem.Type.BOOTS, 0, ArmorItem.Type.LEGGINGS, 0, ArmorItem.Type.CHESTPLATE, 0, ArmorItem.Type.HELMET, 0));
            this.toughness = 0.0f;
            this.knockbackResistance = 0.0f;
        }

        public int m_266425_(ArmorItem.Type type) {
            return BASE_DURABILITY.get(type) * this.durabilityMultiplier;
        }

        public int m_7366_(ArmorItem.Type type) {
            return this.protectionAmounts.get(type);
        }

        public int m_6646_() {
            return this.enchantability;
        }

        public SoundEvent m_7344_() {
            return this.equipSound;
        }

        public Ingredient m_6230_() {
            return (Ingredient)this.repairIngredientSupplier.m_13971_();
        }

        public String name() {
            return this.name;
        }

        @Deprecated
        public String m_6082_() {
            return this.name;
        }

        public float m_6651_() {
            return this.toughness;
        }

        public float m_6649_() {
            return this.knockbackResistance;
        }

        public void configure(ItemConfig.ArmorSet config) {
            this.toughness = config.armor_toughness;
            this.knockbackResistance = config.knockback_resistance;
            this.protectionAmounts = new EnumMap<ArmorItem.Type, Integer>(Map.of(ArmorItem.Type.BOOTS, config.feet.armor, ArmorItem.Type.LEGGINGS, config.legs.armor, ArmorItem.Type.CHESTPLATE, config.chest.armor, ArmorItem.Type.HELMET, config.head.armor));
        }
    }

    public static class Set<A extends ArmorItem> {
        public final String namespace;
        public final A head;
        public final A chest;
        public final A legs;
        public final A feet;
        public boolean allowSpellPowerEnchanting = true;

        public Set(String namespace, A head, A chest, A legs, A feet) {
            this.namespace = namespace;
            this.head = head;
            this.chest = chest;
            this.legs = legs;
            this.feet = feet;
        }

        public List<A> pieces() {
            return Stream.of(this.head, this.chest, this.legs, this.feet).filter(Objects::nonNull).collect(Collectors.toList());
        }

        public ResourceLocation idOf(ArmorItem piece) {
            String name = piece.m_40401_().m_6082_() + "_" + piece.m_40402_().m_20751_();
            return new ResourceLocation(this.namespace, name);
        }

        public List<String> idStrings() {
            return this.pieces().stream().map(piece -> this.idOf((ArmorItem)piece).toString()).toList();
        }

        @Deprecated
        public Set<A> allowSpellPowerEnchanting(boolean allow) {
            this.allowSpellPowerEnchanting = allow;
            return this;
        }

        public void register(ResourceKey<CreativeModeTab> itemGroupKey) {
            for (ArmorItem piece : this.pieces()) {
                Registry.m_122965_((Registry)BuiltInRegistries.f_257033_, (ResourceLocation)this.idOf(piece), (Object)piece);
            }
            ItemGroupEvents.modifyEntriesEvent(itemGroupKey).register(content -> {
                for (ArmorItem piece : this.pieces()) {
                    content.m_246326_((ItemLike)piece);
                }
            });
        }
    }
}

