/*
 * Decompiled with CFR 0.152.
 */
package net.spell_engine;

import java.util.Map;
import me.shedaniel.autoconfig.AutoConfig;
import me.shedaniel.autoconfig.serializer.ConfigSerializer;
import me.shedaniel.autoconfig.serializer.JanksonConfigSerializer;
import me.shedaniel.autoconfig.serializer.PartitioningSerializer;
import net.fabricmc.fabric.api.itemgroup.v1.ItemGroupEvents;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.advancements.CriterionTrigger;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.spell_engine.api.enchantment.Enchantments_SpellEngine;
import net.spell_engine.api.item.weapon.StaffItem;
import net.spell_engine.api.spell.ExternalSpellSchools;
import net.spell_engine.compat.QuiverCompat;
import net.spell_engine.config.EnchantmentsConfig;
import net.spell_engine.config.ServerConfig;
import net.spell_engine.config.ServerConfigWrapper;
import net.spell_engine.internals.SpellRegistry;
import net.spell_engine.internals.criteria.EnchantmentSpecificCriteria;
import net.spell_engine.network.ServerNetwork;
import net.spell_engine.particle.Particles;
import net.spell_engine.rpg_series.RPGSeriesCore;
import net.spell_engine.spellbinding.SpellBinding;
import net.spell_engine.spellbinding.SpellBindingBlock;
import net.spell_engine.spellbinding.SpellBindingBlockEntity;
import net.spell_engine.spellbinding.SpellBindingCriteria;
import net.spell_engine.spellbinding.SpellBindingScreenHandler;
import net.spell_engine.spellbinding.SpellBookCreationCriteria;
import net.spell_power.api.enchantment.EnchantmentRestriction;
import net.tinyconfig.ConfigManager;

public class SpellEngineMod {
    public static final String ID = "spell_engine";
    public static ServerConfig config;
    public static ConfigManager<EnchantmentsConfig> enchantmentConfig;

    public static String modName() {
        return I18n.m_118938_((String)"spell_engine.mod_name", (Object[])new Object[0]);
    }

    public static void init() {
        AutoConfig.register(ServerConfigWrapper.class, (ConfigSerializer.Factory)PartitioningSerializer.wrap(JanksonConfigSerializer::new));
        config = ((ServerConfigWrapper)AutoConfig.getConfigHolder(ServerConfigWrapper.class).getConfig()).server;
        enchantmentConfig.refresh();
        SpellRegistry.initialize();
        ServerNetwork.initializeHandlers();
        Particles.register();
        CriteriaTriggers.m_10595_((CriterionTrigger)EnchantmentSpecificCriteria.INSTANCE);
        EnchantmentRestriction.permit((Enchantment)Enchantments.f_44980_, itemStack -> itemStack.m_41720_() instanceof StaffItem);
        EnchantmentRestriction.permit((Enchantment)Enchantments.f_44982_, itemStack -> itemStack.m_41720_() instanceof StaffItem);
        EnchantmentRestriction.permit((Enchantment)Enchantments.f_44981_, itemStack -> itemStack.m_41720_() instanceof StaffItem);
        QuiverCompat.init();
        ExternalSpellSchools.initialize();
        RPGSeriesCore.initialize();
    }

    public static void registerSpellBinding() {
        Registry.m_122965_((Registry)BuiltInRegistries.f_256975_, (ResourceLocation)SpellBinding.ID, (Object)((Object)SpellBindingBlock.INSTANCE));
        Registry.m_122965_((Registry)BuiltInRegistries.f_257049_, (ResourceLocation)SpellBinding.ID, SpellBindingBlockEntity.ENTITY_TYPE);
        Registry.m_122965_((Registry)BuiltInRegistries.f_257033_, (ResourceLocation)SpellBinding.ID, (Object)SpellBindingBlock.ITEM);
        ItemGroupEvents.modifyEntriesEvent((ResourceKey)CreativeModeTabs.f_256791_).register(content -> content.m_246326_((ItemLike)SpellBindingBlock.ITEM));
        Registry.m_122965_((Registry)BuiltInRegistries.f_256818_, (ResourceLocation)SpellBinding.ID, SpellBindingScreenHandler.HANDLER_TYPE);
        CriteriaTriggers.m_10595_((CriterionTrigger)SpellBindingCriteria.INSTANCE);
        CriteriaTriggers.m_10595_((CriterionTrigger)SpellBookCreationCriteria.INSTANCE);
    }

    public static void registerEnchantments() {
        ((EnchantmentsConfig)SpellEngineMod.enchantmentConfig.value).apply();
        for (Map.Entry<ResourceLocation, Enchantment> entry : Enchantments_SpellEngine.all.entrySet()) {
            Registry.m_122965_((Registry)BuiltInRegistries.f_256876_, (ResourceLocation)entry.getKey(), (Object)entry.getValue());
        }
    }

    static {
        enchantmentConfig = new ConfigManager("enchantments", (Object)new EnchantmentsConfig()).builder().setDirectory(ID).sanitize(true).build();
    }
}

