/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.library.plugins.vanilla.ingredients;

import com.google.common.collect.Streams;
import java.util.Collection;
import java.util.Optional;
import java.util.stream.Stream;
import mezz.jei.api.constants.Tags;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.helpers.IColorHelper;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.ingredients.subtypes.ISubtypeManager;
import mezz.jei.api.ingredients.subtypes.UidContext;
import mezz.jei.common.Internal;
import mezz.jei.common.config.IClientConfig;
import mezz.jei.common.config.IJeiClientConfigs;
import mezz.jei.common.platform.IPlatformItemStackHelper;
import mezz.jei.common.platform.IPlatformRegistry;
import mezz.jei.common.platform.Services;
import mezz.jei.common.util.ErrorUtil;
import mezz.jei.common.util.StackHelper;
import mezz.jei.common.util.TagUtil;
import net.minecraft.core.DefaultedRegistry;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.Nullable;

public class ItemStackHelper
implements IIngredientHelper<ItemStack> {
    private final ISubtypeManager subtypeManager;
    private final StackHelper stackHelper;
    private final IColorHelper colorHelper;
    private final TagKey<Item> itemHiddenFromRecipeViewers;
    private final TagKey<Block> blockHiddenFromRecipeViewers;

    public ItemStackHelper(ISubtypeManager subtypeManager, StackHelper stackHelper, IColorHelper colorHelper) {
        this.subtypeManager = subtypeManager;
        this.stackHelper = stackHelper;
        this.colorHelper = colorHelper;
        this.itemHiddenFromRecipeViewers = new TagKey(Registries.f_256913_, Tags.HIDDEN_FROM_RECIPE_VIEWERS);
        this.blockHiddenFromRecipeViewers = new TagKey(Registries.f_256747_, Tags.HIDDEN_FROM_RECIPE_VIEWERS);
    }

    @Override
    public IIngredientType<ItemStack> getIngredientType() {
        return VanillaTypes.ITEM_STACK;
    }

    @Override
    public String getDisplayName(ItemStack ingredient) {
        Component displayNameTextComponent = ingredient.m_41786_();
        String displayName = displayNameTextComponent.getString();
        ErrorUtil.checkNotNull(displayName, "itemStack.getDisplayName()");
        return displayName;
    }

    @Override
    public String getUniqueId(ItemStack ingredient, UidContext context) {
        ErrorUtil.checkNotEmpty(ingredient);
        return this.stackHelper.getUniqueIdentifierForStack(ingredient, context);
    }

    @Override
    public boolean hasSubtypes(ItemStack ingredient) {
        ErrorUtil.checkNotNull(ingredient, "ingredient");
        return this.subtypeManager.hasSubtypes(VanillaTypes.ITEM_STACK, ingredient);
    }

    @Override
    public String getWildcardId(ItemStack ingredient) {
        ErrorUtil.checkNotEmpty(ingredient);
        return StackHelper.getRegistryNameForStack(ingredient);
    }

    @Override
    public String getDisplayModId(ItemStack ingredient) {
        ErrorUtil.checkNotEmpty(ingredient);
        IPlatformItemStackHelper itemStackHelper = Services.PLATFORM.getItemStackHelper();
        return itemStackHelper.getCreatorModId(ingredient).or(() -> ItemStackHelper.getNamespace(ingredient)).orElseThrow(() -> {
            String stackInfo = this.getErrorInfo(ingredient);
            return new IllegalStateException("null registryName for: " + stackInfo);
        });
    }

    private static Optional<String> getNamespace(ItemStack ingredient) {
        return Services.PLATFORM.getRegistry(Registries.f_256913_).getRegistryName(ingredient.m_41720_()).map(ResourceLocation::m_135827_);
    }

    @Override
    public long getAmount(ItemStack ingredient) {
        return ingredient.m_41613_();
    }

    @Override
    public ItemStack copyWithAmount(ItemStack ingredient, long amount) {
        ItemStack copy = ingredient.m_41777_();
        int intAmount = Math.toIntExact(amount);
        copy.m_41764_(intAmount);
        return copy;
    }

    @Override
    public Iterable<Integer> getColors(ItemStack ingredient) {
        return this.colorHelper.getColors(ingredient, 2);
    }

    @Override
    public ResourceLocation getResourceLocation(ItemStack ingredient) {
        ErrorUtil.checkNotEmpty(ingredient);
        Item item = ingredient.m_41720_();
        return Services.PLATFORM.getRegistry(Registries.f_256913_).getRegistryName(item).orElseThrow(() -> {
            String stackInfo = this.getErrorInfo(ingredient);
            return new IllegalStateException("item has no key in the Item registry: " + stackInfo);
        });
    }

    @Override
    public ItemStack getCheatItemStack(ItemStack ingredient) {
        return ingredient;
    }

    @Override
    public ItemStack copyIngredient(ItemStack ingredient) {
        return ingredient.m_41777_();
    }

    @Override
    public ItemStack normalizeIngredient(ItemStack ingredient) {
        if (ingredient.m_41613_() == 1) {
            return ingredient;
        }
        ItemStack copy = ingredient.m_41777_();
        copy.m_41764_(1);
        return copy;
    }

    @Override
    public boolean isValidIngredient(ItemStack ingredient) {
        return !ingredient.m_41619_();
    }

    @Override
    public boolean isIngredientOnServer(ItemStack ingredient) {
        Item item = ingredient.m_41720_();
        IPlatformRegistry<Item> registry = Services.PLATFORM.getRegistry(Registries.f_256913_);
        return registry.contains(item);
    }

    @Override
    public Stream<ResourceLocation> getTagStream(ItemStack ingredient) {
        Stream<ResourceLocation> itemTagStream = ingredient.m_204131_().map(TagKey::f_203868_);
        Item item = ingredient.m_41720_();
        if (item instanceof BlockItem) {
            BlockItem blockItem = (BlockItem)item;
            IJeiClientConfigs jeiClientConfigs = Internal.getJeiClientConfigs();
            IClientConfig clientConfig = jeiClientConfigs.getClientConfig();
            if (clientConfig.isLookupBlockTagsEnabled()) {
                Stream<ResourceLocation> blockTagStream = blockItem.m_40614_().m_49966_().m_204343_().map(TagKey::f_203868_);
                return Streams.concat((Stream[])new Stream[]{itemTagStream, blockTagStream});
            }
        }
        return itemTagStream;
    }

    @Override
    public boolean isHiddenFromRecipeViewersByTags(ItemStack ingredient) {
        if (ingredient.m_204117_(this.itemHiddenFromRecipeViewers)) {
            return true;
        }
        Item item = ingredient.m_41720_();
        if (item instanceof BlockItem) {
            BlockItem blockItem = (BlockItem)item;
            IJeiClientConfigs jeiClientConfigs = Internal.getJeiClientConfigs();
            IClientConfig clientConfig = jeiClientConfigs.getClientConfig();
            if (clientConfig.isLookupBlockTagsEnabled()) {
                Block block = blockItem.m_40614_();
                Holder.Reference holder = block.m_204297_();
                return holder.m_203656_(this.blockHiddenFromRecipeViewers);
            }
        }
        return false;
    }

    @Override
    public String getErrorInfo(@Nullable ItemStack ingredient) {
        return ErrorUtil.getItemStackInfo(ingredient);
    }

    @Override
    public Optional<ResourceLocation> getTagEquivalent(Collection<ItemStack> ingredients) {
        return TagUtil.getTagEquivalent(ingredients, ItemStack::m_41720_, () -> ((DefaultedRegistry)BuiltInRegistries.f_257033_).m_203612_());
    }
}

