/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.library.plugins.jei.info;

import java.util.Objects;
import mezz.jei.api.constants.RecipeTypes;
import mezz.jei.api.gui.builder.IIngredientAcceptor;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.ITypedIngredient;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.recipe.vanilla.IJeiIngredientInfoRecipe;
import mezz.jei.common.gui.textures.Textures;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;

public class IngredientInfoRecipeCategory
implements IRecipeCategory<IJeiIngredientInfoRecipe> {
    private final IDrawable background;
    private final IDrawable icon;
    private final IDrawable slotBackground;
    private final Component localizedName;

    public IngredientInfoRecipeCategory(IGuiHelper guiHelper, Textures textures) {
        this.background = guiHelper.createBlankDrawable(160, 125);
        this.icon = textures.getInfoIcon();
        this.slotBackground = guiHelper.getSlotDrawable();
        this.localizedName = Component.m_237115_((String)"gui.jei.category.itemInformation");
    }

    @Override
    public RecipeType<IJeiIngredientInfoRecipe> getRecipeType() {
        return RecipeTypes.INFORMATION;
    }

    @Override
    public Component getTitle() {
        return this.localizedName;
    }

    @Override
    public IDrawable getIcon() {
        return this.icon;
    }

    @Override
    public IDrawable getBackground() {
        return this.background;
    }

    @Override
    public void draw(IJeiIngredientInfoRecipe recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        int xPos = 0;
        int yPos = this.slotBackground.getHeight() + 4;
        Minecraft minecraft = Minecraft.m_91087_();
        for (FormattedText descriptionLine : recipe.getDescription()) {
            guiGraphics.m_280649_(minecraft.f_91062_, Language.m_128107_().m_5536_(descriptionLine), xPos, yPos, -16777216, false);
            Objects.requireNonNull(minecraft.f_91062_);
            yPos += 9 + 2;
        }
    }

    @Override
    public void setRecipe(IRecipeLayoutBuilder builder, IJeiIngredientInfoRecipe recipe, IFocusGroup focuses) {
        int xPos = 72;
        IRecipeSlotBuilder inputSlotBuilder = builder.addSlot(RecipeIngredientRole.INPUT, xPos, 1).setBackground(this.slotBackground, -1, -1);
        IIngredientAcceptor<?> outputSlotBuilder = builder.addInvisibleIngredients(RecipeIngredientRole.OUTPUT);
        for (ITypedIngredient<?> typedIngredient : recipe.getIngredients()) {
            IngredientInfoRecipeCategory.addIngredient(typedIngredient, inputSlotBuilder);
            IngredientInfoRecipeCategory.addIngredient(typedIngredient, outputSlotBuilder);
        }
    }

    @Override
    @Nullable
    public ResourceLocation getRegistryName(IJeiIngredientInfoRecipe recipe) {
        return null;
    }

    private static <T> void addIngredient(ITypedIngredient<T> typedIngredient, IIngredientAcceptor<?> slotBuilder) {
        slotBuilder.addIngredient(typedIngredient.getType(), typedIngredient.getIngredient());
    }
}

