/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.library.plugins.debug;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.RecipeTypes;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.handlers.IGuiContainerHandler;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.helpers.IJeiHelpers;
import mezz.jei.api.helpers.IPlatformFluidHelper;
import mezz.jei.api.ingredients.IIngredientTypeWithSubtypes;
import mezz.jei.api.ingredients.ITypedIngredient;
import mezz.jei.api.registration.IAdvancedRegistration;
import mezz.jei.api.registration.IGuiHandlerRegistration;
import mezz.jei.api.registration.IModIngredientRegistration;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.ISubtypeRegistration;
import mezz.jei.api.runtime.IClickableIngredient;
import mezz.jei.api.runtime.IIngredientManager;
import mezz.jei.api.runtime.IJeiRuntime;
import mezz.jei.common.config.DebugConfig;
import mezz.jei.common.platform.IPlatformFluidHelperInternal;
import mezz.jei.common.platform.IPlatformRegistry;
import mezz.jei.common.platform.IPlatformScreenHelper;
import mezz.jei.common.platform.Services;
import mezz.jei.common.util.ErrorUtil;
import mezz.jei.common.util.MathUtil;
import mezz.jei.library.plugins.debug.DebugCategoryDecorator;
import mezz.jei.library.plugins.debug.DebugFocusRecipeCategory;
import mezz.jei.library.plugins.debug.DebugGhostIngredientHandler;
import mezz.jei.library.plugins.debug.DebugRecipe;
import mezz.jei.library.plugins.debug.DebugRecipeCategory;
import mezz.jei.library.plugins.debug.FluidSubtypeHandlerTest;
import mezz.jei.library.plugins.debug.ObnoxiouslyLargeCategory;
import mezz.jei.library.plugins.debug.ObnoxiouslyLargeRecipe;
import mezz.jei.library.plugins.debug.ingredients.DebugIngredient;
import mezz.jei.library.plugins.debug.ingredients.DebugIngredientHelper;
import mezz.jei.library.plugins.debug.ingredients.DebugIngredientListFactory;
import mezz.jei.library.plugins.debug.ingredients.DebugIngredientRenderer;
import mezz.jei.library.plugins.debug.ingredients.ErrorIngredient;
import mezz.jei.library.plugins.debug.ingredients.ErrorIngredientHelper;
import mezz.jei.library.plugins.debug.ingredients.ErrorIngredientListFactory;
import mezz.jei.library.plugins.debug.ingredients.ErrorIngredientRenderer;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.BrewingStandScreen;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.SmithingTrimRecipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import org.jetbrains.annotations.Nullable;

@JeiPlugin
public class JeiDebugPlugin
implements IModPlugin {
    @Nullable
    private DebugRecipeCategory<?> debugRecipeCategory;

    @Override
    public ResourceLocation getPluginUid() {
        return new ResourceLocation("jei", "debug");
    }

    @Override
    public void registerIngredients(IModIngredientRegistration registration) {
        if (DebugConfig.isDebugModeEnabled()) {
            DebugIngredientHelper ingredientHelper = new DebugIngredientHelper();
            DebugIngredientRenderer ingredientRenderer = new DebugIngredientRenderer(ingredientHelper);
            registration.register(DebugIngredient.TYPE, Collections.emptyList(), ingredientHelper, ingredientRenderer);
            if (DebugConfig.isCrashingTestIngredientsEnabled()) {
                ErrorIngredientHelper errorIngredientHelper = new ErrorIngredientHelper();
                ErrorIngredientRenderer errorIngredientRenderer = new ErrorIngredientRenderer(errorIngredientHelper);
                Collection<ErrorIngredient> errorIngredients = ErrorIngredientListFactory.create();
                registration.register(ErrorIngredient.TYPE, errorIngredients, errorIngredientHelper, errorIngredientRenderer);
            }
        }
    }

    @Override
    public void registerCategories(IRecipeCategoryRegistration registration) {
        if (DebugConfig.isDebugModeEnabled()) {
            IJeiHelpers jeiHelpers = registration.getJeiHelpers();
            IGuiHelper guiHelper = jeiHelpers.getGuiHelper();
            IPlatformFluidHelper<?> platformFluidHelper = jeiHelpers.getPlatformFluidHelper();
            IIngredientManager ingredientManager = jeiHelpers.getIngredientManager();
            this.debugRecipeCategory = new DebugRecipeCategory(guiHelper, platformFluidHelper, ingredientManager);
            registration.addRecipeCategories(this.debugRecipeCategory, new DebugFocusRecipeCategory(guiHelper, platformFluidHelper), new ObnoxiouslyLargeCategory(guiHelper, ingredientManager));
        }
    }

    @Override
    public void registerRecipes(IRecipeRegistration registration) {
        if (DebugConfig.isDebugModeEnabled()) {
            registration.addItemStackInfo(List.of(new ItemStack((ItemLike)Blocks.f_50154_), new ItemStack((ItemLike)Blocks.f_50484_), new ItemStack((ItemLike)Blocks.f_50485_), new ItemStack((ItemLike)Blocks.f_50486_), new ItemStack((ItemLike)Blocks.f_50487_), new ItemStack((ItemLike)Blocks.f_50488_)), new Component[]{Component.m_237115_((String)"description.jei.wooden.door.1"), Component.m_237115_((String)"description.jei.wooden.door.2"), Component.m_237115_((String)"description.jei.wooden.door.3")});
            IJeiHelpers jeiHelpers = registration.getJeiHelpers();
            IPlatformFluidHelper<?> platformFluidHelper = jeiHelpers.getPlatformFluidHelper();
            this.registerFluidRecipes(registration, platformFluidHelper);
            registration.addIngredientInfo(new DebugIngredient(1), DebugIngredient.TYPE, new Component[]{Component.m_237113_((String)"debug")});
            registration.addIngredientInfo(new DebugIngredient(2), DebugIngredient.TYPE, new Component[]{Component.m_237113_((String)"debug colored").m_130940_(ChatFormatting.AQUA), Component.m_237113_((String)"debug\\nSplit and colored").m_130940_(ChatFormatting.LIGHT_PURPLE), Component.m_237110_((String)"description.jei.debug.formatting.1", (Object[])new Object[]{"various"}), Component.m_237110_((String)"description.jei.debug.formatting.1", (Object[])new Object[]{"various\\nsplit"}), Component.m_237110_((String)"description.jei.debug.formatting.1", (Object[])new Object[]{Component.m_237113_((String)"various colored").m_130940_(ChatFormatting.RED)}), Component.m_237110_((String)"description.jei.debug.formatting.1", (Object[])new Object[]{Component.m_237113_((String)"various\\nsplit colored").m_130940_(ChatFormatting.DARK_AQUA)}), Component.m_237110_((String)"description.jei.debug.formatting.1", (Object[])new Object[]{"\\nSplitting at the start"}), Component.m_237110_((String)"description.jei.debug.formatting.1", (Object[])new Object[]{"various all colored"}).m_130940_(ChatFormatting.RED), Component.m_237110_((String)"description.jei.debug.formatting.1", (Object[])new Object[]{Component.m_237110_((String)"description.jei.debug.formatting.3", (Object[])new Object[]{"various"}).m_130940_(ChatFormatting.DARK_AQUA)}), Component.m_237110_((String)"description.jei.debug.formatting.2", (Object[])new Object[]{Component.m_237113_((String)"multiple").m_130940_(ChatFormatting.GOLD).m_130940_(ChatFormatting.ITALIC), Component.m_237113_((String)"various").m_130940_(ChatFormatting.RED)}).m_130940_(ChatFormatting.BLUE), Component.m_237110_((String)"description.jei.debug.formatting.1", (Object[])new Object[]{Component.m_237110_((String)"description.jei.debug.formatting.3", (Object[])new Object[]{Component.m_237110_((String)"description.jei.debug.formatting.2", (Object[])new Object[]{Component.m_237113_((String)"multiple").m_130940_(ChatFormatting.GOLD).m_130940_(ChatFormatting.ITALIC), Component.m_237113_((String)"various").m_130940_(ChatFormatting.RED)}).m_130940_(ChatFormatting.DARK_AQUA)})})});
            registration.addRecipes(DebugRecipeCategory.TYPE, List.of(new DebugRecipe(), new DebugRecipe()));
            registration.addRecipes(DebugFocusRecipeCategory.TYPE, List.of(new DebugRecipe()));
            SmithingTrimRecipe testRecipeWithoutTemplate = new SmithingTrimRecipe(new ResourceLocation("jei", "test_recipe_without_template"), Ingredient.f_43901_, Ingredient.m_43927_((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)Items.f_42410_)}), Ingredient.m_43927_((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)Items.f_42674_)}));
            registration.addRecipes(RecipeTypes.SMITHING, List.of(testRecipeWithoutTemplate));
            registration.addRecipes(ObnoxiouslyLargeCategory.TYPE, List.of(new ObnoxiouslyLargeRecipe()));
        }
    }

    private <T> void registerFluidRecipes(IRecipeRegistration registration, IPlatformFluidHelper<T> platformFluidHelper) {
        long bucketVolume = platformFluidHelper.bucketVolume();
        T fluidIngredient = platformFluidHelper.create((Fluid)Fluids.f_76193_, bucketVolume, null);
        registration.addIngredientInfo(fluidIngredient, platformFluidHelper.getFluidIngredientType(), new Component[]{Component.m_237113_((String)"water")});
        fluidIngredient = platformFluidHelper.create(Fluids.f_76195_.m_76145_().m_76152_(), 1L);
        registration.addIngredientInfo(fluidIngredient, platformFluidHelper.getFluidIngredientType(), new Component[]{Component.m_237113_((String)"small amount of lava that should still show as 1 bucket")});
    }

    @Override
    public void registerGuiHandlers(IGuiHandlerRegistration registration) {
        if (DebugConfig.isDebugModeEnabled()) {
            IJeiHelpers jeiHelpers = registration.getJeiHelpers();
            final IIngredientManager ingredientManager = jeiHelpers.getIngredientManager();
            registration.addGuiContainerHandler(BrewingStandScreen.class, new IGuiContainerHandler<BrewingStandScreen>(){

                @Override
                public List<Rect2i> getGuiExtraAreas(BrewingStandScreen containerScreen) {
                    int widthMovement = (int)(System.currentTimeMillis() / 100L % 100L);
                    int size = 25 + widthMovement;
                    IPlatformScreenHelper screenHelper = Services.PLATFORM.getScreenHelper();
                    int guiLeft = screenHelper.getGuiLeft((AbstractContainerScreen<?>)containerScreen);
                    int xSize = screenHelper.getXSize((AbstractContainerScreen<?>)containerScreen);
                    int guiTop = screenHelper.getGuiTop((AbstractContainerScreen<?>)containerScreen);
                    return List.of(new Rect2i(guiLeft + xSize, guiTop + 40, size, size));
                }

                @Override
                public Optional<IClickableIngredient<?>> getClickableIngredientUnderMouse(BrewingStandScreen containerScreen, double mouseX, double mouseY) {
                    Rect2i area = new Rect2i(0, 0, 10, 10);
                    if (MathUtil.contains(area, mouseX, mouseY)) {
                        return ingredientManager.createTypedIngredient(VanillaTypes.ITEM_STACK, new ItemStack((ItemLike)Items.f_42411_)).map(item -> new DebugClickableIngredient(item, area));
                    }
                    return Optional.empty();
                }
            });
            registration.addGhostIngredientHandler(BrewingStandScreen.class, new DebugGhostIngredientHandler(ingredientManager));
        }
    }

    @Override
    public <T> void registerFluidSubtypes(ISubtypeRegistration registration, IPlatformFluidHelper<T> platformFluidHelper) {
        FlowingFluid water = Fluids.f_76193_;
        IIngredientTypeWithSubtypes<Fluid, T> ingredientType = platformFluidHelper.getFluidIngredientType();
        FluidSubtypeHandlerTest<T> subtype = new FluidSubtypeHandlerTest<T>(ingredientType);
        registration.registerSubtypeInterpreter(ingredientType, water, subtype);
    }

    @Override
    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        if (DebugConfig.isDebugModeEnabled()) {
            IPlatformFluidHelperInternal<?> fluidHelper = Services.PLATFORM.getFluidHelper();
            this.registerRecipeCatalysts(registration, fluidHelper);
        }
    }

    private <T> void registerRecipeCatalysts(IRecipeCatalystRegistration registration, IPlatformFluidHelper<T> fluidHelper) {
        long bucketVolume = fluidHelper.bucketVolume();
        registration.addRecipeCatalyst(DebugIngredient.TYPE, new DebugIngredient(7), DebugRecipeCategory.TYPE);
        registration.addRecipeCatalyst(fluidHelper.getFluidIngredientType(), fluidHelper.create((Fluid)Fluids.f_76193_, bucketVolume, null), DebugRecipeCategory.TYPE);
        registration.addRecipeCatalyst(new ItemStack((ItemLike)Items.f_42398_), DebugRecipeCategory.TYPE);
        IPlatformRegistry registry = Services.PLATFORM.getRegistry(Registries.f_256913_);
        registry.getValues().limit(300L).forEach(item -> {
            ItemStack catalystIngredient = new ItemStack((ItemLike)item);
            if (!catalystIngredient.m_41619_()) {
                registration.addRecipeCatalyst(catalystIngredient, DebugRecipeCategory.TYPE);
            }
        });
    }

    @Override
    public void registerAdvanced(IAdvancedRegistration registration) {
        if (DebugConfig.isDebugModeEnabled()) {
            registration.getJeiHelpers().getAllRecipeTypes().filter(r -> r.getUid().m_135827_().equals("jei")).forEach(r -> registration.addRecipeCategoryDecorator(r, DebugCategoryDecorator.getInstance()));
        }
    }

    @Override
    public void onRuntimeAvailable(IJeiRuntime jeiRuntime) {
        if (DebugConfig.isDebugModeEnabled()) {
            ErrorUtil.assertMainThread();
            if (this.debugRecipeCategory != null) {
                this.debugRecipeCategory.setRuntime(jeiRuntime);
            }
            IIngredientManager ingredientManager = jeiRuntime.getIngredientManager();
            ingredientManager.addIngredientsAtRuntime(DebugIngredient.TYPE, DebugIngredientListFactory.create());
        }
    }

    private record DebugClickableIngredient<T>(ITypedIngredient<T> typedIngredient, Rect2i area) implements IClickableIngredient<T>
    {
        @Override
        public ITypedIngredient<T> getTypedIngredient() {
            return this.typedIngredient;
        }

        @Override
        public Rect2i getArea() {
            return this.area;
        }
    }
}

