/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.library.plugins.debug;

import java.util.ArrayList;
import java.util.List;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.handlers.IGhostIngredientHandler;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.ingredients.ITypedIngredient;
import mezz.jei.api.runtime.IIngredientManager;
import mezz.jei.common.platform.IPlatformScreenHelper;
import mezz.jei.common.platform.Services;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.world.inventory.Slot;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DebugGhostIngredientHandler<T extends AbstractContainerScreen<?>>
implements IGhostIngredientHandler<T> {
    private static final Logger LOGGER = LogManager.getLogger();
    private final IIngredientManager ingredientManager;

    public DebugGhostIngredientHandler(IIngredientManager ingredientManager) {
        this.ingredientManager = ingredientManager;
    }

    @Override
    public <I> List<IGhostIngredientHandler.Target<I>> getTargetsTyped(T gui, ITypedIngredient<I> typedIngredient, boolean doStart) {
        ArrayList targets = new ArrayList();
        targets.add(new DebugInfoTarget("Got an Ingredient", new Rect2i(0, 0, 20, 20), this.ingredientManager));
        if (doStart) {
            IIngredientType<I> ingredientType = typedIngredient.getType();
            IIngredientHelper<I> ingredientHelper = this.ingredientManager.getIngredientHelper(ingredientType);
            LOGGER.info("Ghost Ingredient Handling Starting with {}", (Object)ingredientHelper.getErrorInfo(typedIngredient.getIngredient()));
            targets.add(new DebugInfoTarget("Got an Ingredient", new Rect2i(20, 20, 20, 20), this.ingredientManager));
        }
        typedIngredient.getIngredient(VanillaTypes.ITEM_STACK).ifPresent(itemStack -> {
            boolean even = true;
            IPlatformScreenHelper screenHelper = Services.PLATFORM.getScreenHelper();
            for (Slot slot : gui.m_6262_().f_38839_) {
                if (even) {
                    int guiLeft = screenHelper.getGuiLeft((AbstractContainerScreen<?>)gui);
                    int guiTop = screenHelper.getGuiTop((AbstractContainerScreen<?>)gui);
                    Rect2i area = new Rect2i(guiLeft + slot.f_40220_, guiTop + slot.f_40221_, 16, 16);
                    targets.add(new DebugInfoTarget("Got an Ingredient in Gui", area, this.ingredientManager));
                }
                even = !even;
            }
        });
        return targets;
    }

    @Override
    public void onComplete() {
        LOGGER.info("Ghost Ingredient Handling Complete");
    }

    private record DebugInfoTarget<I>(String message, Rect2i rectangle, IIngredientManager ingredientManager) implements IGhostIngredientHandler.Target<I>
    {
        @Override
        public Rect2i getArea() {
            return this.rectangle;
        }

        @Override
        public void accept(I ingredient) {
            IIngredientType<I> ingredientType = this.ingredientManager.getIngredientTypeChecked(ingredient).orElseThrow();
            IIngredientHelper<I> ingredientHelper = this.ingredientManager.getIngredientHelper(ingredientType);
            LOGGER.info("{}: {}", (Object)this.message, (Object)ingredientHelper.getErrorInfo(ingredient));
        }
    }
}

