/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.library.ingredients;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.ingredients.ITypedIngredient;
import mezz.jei.api.runtime.IIngredientManager;
import org.jetbrains.annotations.Nullable;

public final class TypedIngredient<T>
implements ITypedIngredient<T> {
    private final IIngredientType<T> ingredientType;
    private final T ingredient;

    private static <T> void checkParameters(IIngredientType<T> ingredientType, T ingredient) {
        Preconditions.checkNotNull(ingredientType, (Object)"ingredientType");
        Preconditions.checkNotNull(ingredient, (Object)"ingredient");
        Class<T> ingredientClass = ingredientType.getIngredientClass();
        if (!ingredientClass.isInstance(ingredient)) {
            throw new IllegalArgumentException("Invalid ingredient found.  Should be an instance of: " + ingredientClass + " Instead got: " + ingredient.getClass());
        }
    }

    public static <T> ITypedIngredient<T> createUnvalidated(IIngredientType<T> ingredientType, T ingredient) {
        TypedIngredient.checkParameters(ingredientType, ingredient);
        return new TypedIngredient<T>(ingredientType, ingredient);
    }

    public static <T> Optional<ITypedIngredient<?>> createAndFilterInvalid(IIngredientManager ingredientManager, @Nullable T ingredient, boolean normalize) {
        if (ingredient == null) {
            return Optional.empty();
        }
        return ingredientManager.getIngredientTypeChecked(ingredient).flatMap(ingredientType -> TypedIngredient.createAndFilterInvalid(ingredientManager, ingredientType, ingredient, normalize));
    }

    public static <T> Optional<ITypedIngredient<T>> createAndFilterInvalid(IIngredientManager ingredientManager, IIngredientType<T> ingredientType, @Nullable T ingredient, boolean normalize) {
        if (ingredient == null) {
            return Optional.empty();
        }
        TypedIngredient.checkParameters(ingredientType, ingredient);
        IIngredientHelper<T> ingredientHelper = ingredientManager.getIngredientHelper(ingredientType);
        return TypedIngredient.createAndFilterInvalid(ingredientHelper, ingredientType, ingredient, normalize);
    }

    public static <T> List<Optional<ITypedIngredient<T>>> createAndFilterInvalidList(IIngredientManager ingredientManager, IIngredientType<T> ingredientType, List<@Nullable T> ingredients, boolean normalize) {
        IIngredientHelper<T> ingredientHelper = ingredientManager.getIngredientHelper(ingredientType);
        ArrayList<Optional<ITypedIngredient<T>>> results = new ArrayList<Optional<ITypedIngredient<T>>>(ingredients.size());
        for (T ingredient : ingredients) {
            if (ingredient == null) {
                results.add(Optional.empty());
                continue;
            }
            Optional<ITypedIngredient<T>> result = TypedIngredient.createAndFilterInvalid(ingredientHelper, ingredientType, ingredient, normalize);
            results.add(result);
        }
        return results;
    }

    public static <T> Optional<ITypedIngredient<T>> createAndFilterInvalid(IIngredientHelper<T> ingredientHelper, IIngredientType<T> ingredientType, T ingredient, boolean normalize) {
        try {
            if (normalize) {
                ingredient = ingredientHelper.normalizeIngredient(ingredient);
            }
            if (!ingredientHelper.isValidIngredient(ingredient)) {
                return Optional.empty();
            }
        }
        catch (RuntimeException e) {
            String ingredientInfo = ingredientHelper.getErrorInfo(ingredient);
            throw new IllegalArgumentException("Crashed when checking if ingredient is valid. Ingredient Info: " + ingredientInfo, e);
        }
        TypedIngredient<T> typedIngredient = new TypedIngredient<T>(ingredientType, ingredient);
        return Optional.of(typedIngredient);
    }

    public static <T> Optional<ITypedIngredient<T>> deepCopy(IIngredientManager ingredientManager, ITypedIngredient<T> value) {
        IIngredientHelper<T> ingredientHelper = ingredientManager.getIngredientHelper(value.getType());
        T ingredient = ingredientHelper.copyIngredient(value.getIngredient());
        return TypedIngredient.createAndFilterInvalid(ingredientManager, value.getType(), ingredient, false);
    }

    private TypedIngredient(IIngredientType<T> ingredientType, T ingredient) {
        this.ingredientType = ingredientType;
        this.ingredient = ingredient;
    }

    @Override
    public T getIngredient() {
        return this.ingredient;
    }

    @Override
    public IIngredientType<T> getType() {
        return this.ingredientType;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("type", this.ingredientType).add("ingredient", this.ingredient).toString();
    }
}

