/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.gui.recipes;

import java.util.Optional;
import mezz.jei.api.gui.IRecipeLayoutDrawable;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.common.input.IInternalKeyMappings;
import mezz.jei.gui.input.IUserInputHandler;
import mezz.jei.gui.input.UserInput;
import mezz.jei.gui.input.handlers.CombinedInputHandler;
import mezz.jei.gui.recipes.RecipeBookmarkButton;
import mezz.jei.gui.recipes.RecipeTransferButton;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;

public record RecipeLayoutWithButtons<R>(IRecipeLayoutDrawable<R> recipeLayout, RecipeTransferButton transferButton, RecipeBookmarkButton bookmarkButton) {
    public int totalWidth() {
        int buttonRight;
        Rect2i buttonArea;
        Rect2i area = this.recipeLayout.getRect();
        Rect2i areaWithBorder = this.recipeLayout.getRectWithBorder();
        int leftBorderWidth = area.m_110085_() - areaWithBorder.m_110085_();
        int rightAreaWidth = areaWithBorder.m_110090_() - leftBorderWidth;
        if (this.transferButton.isVisible()) {
            buttonArea = this.recipeLayout.getRecipeTransferButtonArea();
            buttonRight = buttonArea.m_110085_() + buttonArea.m_110090_();
            rightAreaWidth = Math.max(buttonRight, rightAreaWidth);
        }
        if (this.bookmarkButton.isVisible()) {
            buttonArea = this.recipeLayout.getRecipeBookmarkButtonArea();
            buttonRight = buttonArea.m_110085_() + buttonArea.m_110090_();
            rightAreaWidth = Math.max(buttonRight, rightAreaWidth);
        }
        return leftBorderWidth + rightAreaWidth;
    }

    public IUserInputHandler createUserInputHandler() {
        return new CombinedInputHandler(new RecipeLayoutUserInputHandler<R>(this.recipeLayout), this.bookmarkButton.createInputHandler(), this.transferButton.createInputHandler());
    }

    private record RecipeLayoutUserInputHandler<R>(IRecipeLayoutDrawable<R> recipeLayout) implements IUserInputHandler
    {
        @Override
        public Optional<IUserInputHandler> handleUserInput(Screen screen, UserInput input, IInternalKeyMappings keyBindings) {
            if (!this.recipeLayout.isMouseOver(input.getMouseX(), input.getMouseY())) {
                return Optional.empty();
            }
            Rect2i recipeArea = this.recipeLayout.getRect();
            double recipeMouseX = input.getMouseX() - (double)recipeArea.m_110085_();
            double recipeMouseY = input.getMouseY() - (double)recipeArea.m_110086_();
            R recipe = this.recipeLayout.getRecipe();
            IRecipeCategory<R> recipeCategory = this.recipeLayout.getRecipeCategory();
            if (recipeCategory.handleInput(recipe, recipeMouseX, recipeMouseY, input.getKey())) {
                return Optional.of(this);
            }
            if (input.is(keyBindings.getCopyRecipeId()) && this.handleCopyRecipeId(this.recipeLayout)) {
                return Optional.of(this);
            }
            return Optional.empty();
        }

        private boolean handleCopyRecipeId(IRecipeLayoutDrawable<R> recipeLayout) {
            R recipe;
            Minecraft minecraft = Minecraft.m_91087_();
            LocalPlayer player = minecraft.f_91074_;
            IRecipeCategory<R> recipeCategory = recipeLayout.getRecipeCategory();
            ResourceLocation registryName = recipeCategory.getRegistryName(recipe = recipeLayout.getRecipe());
            if (registryName == null) {
                MutableComponent message = Component.m_237115_((String)"jei.message.copy.recipe.id.failure");
                if (player != null) {
                    player.m_5661_((Component)message, false);
                }
                return false;
            }
            String recipeId = registryName.toString();
            minecraft.f_91068_.m_90911_(recipeId);
            MutableComponent message = Component.m_237110_((String)"jei.message.copy.recipe.id.success", (Object[])new Object[]{Component.m_237113_((String)recipeId)});
            if (player != null) {
                player.m_5661_((Component)message, false);
            }
            return true;
        }
    }
}

