/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.gui.recipes;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import mezz.jei.api.gui.IRecipeLayoutDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotDrawable;
import mezz.jei.common.util.ImmutableRect2i;
import mezz.jei.gui.elements.GuiIconToggleButton;
import mezz.jei.gui.input.ClickableIngredientInternal;
import mezz.jei.gui.input.IClickableIngredientInternal;
import mezz.jei.gui.input.IUserInputHandler;
import mezz.jei.gui.input.handlers.CombinedInputHandler;
import mezz.jei.gui.input.handlers.NullInputHandler;
import mezz.jei.gui.input.handlers.ProxyInputHandler;
import mezz.jei.gui.overlay.elements.IngredientElement;
import mezz.jei.gui.recipes.RecipeBookmarkButton;
import mezz.jei.gui.recipes.RecipeLayoutWithButtons;
import mezz.jei.gui.recipes.RecipeTransferButton;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import org.jetbrains.annotations.Nullable;

public class RecipeGuiLayouts {
    private final List<RecipeLayoutWithButtons<?>> recipeLayoutsWithButtons = new ArrayList();
    @Nullable
    private IUserInputHandler cachedInputHandler = NullInputHandler.INSTANCE;

    public void updateLayout(ImmutableRect2i recipeLayoutsArea, int recipesPerPage) {
        if (this.recipeLayoutsWithButtons.isEmpty()) {
            return;
        }
        RecipeLayoutWithButtons<?> firstLayout = this.recipeLayoutsWithButtons.get(0);
        ImmutableRect2i layoutAreaWithBorder = new ImmutableRect2i(firstLayout.recipeLayout().getRectWithBorder());
        int recipeXOffset = this.getRecipeXOffset(layoutAreaWithBorder, recipeLayoutsArea);
        int recipeHeight = layoutAreaWithBorder.getHeight();
        int availableHeight = Math.max(recipeLayoutsArea.getHeight(), recipeHeight);
        int remainingHeight = availableHeight - recipesPerPage * recipeHeight;
        int recipeSpacing = remainingHeight / (recipesPerPage + 1);
        int spacingY = recipeHeight + recipeSpacing;
        int recipeYOffset = recipeLayoutsArea.getY() + recipeSpacing;
        for (RecipeLayoutWithButtons<?> recipeLayoutWithButtons : this.recipeLayoutsWithButtons) {
            IRecipeLayoutDrawable<?> recipeLayout = recipeLayoutWithButtons.recipeLayout();
            Rect2i rectWithBorder = recipeLayout.getRectWithBorder();
            Rect2i rect = recipeLayout.getRect();
            recipeLayout.setPosition(recipeXOffset - rectWithBorder.m_110085_() + rect.m_110085_(), recipeYOffset - rectWithBorder.m_110086_() + rect.m_110086_());
            recipeYOffset += spacingY;
        }
        this.updateRecipeButtonPositions();
    }

    private void updateRecipeButtonPositions() {
        for (RecipeLayoutWithButtons<?> recipeLayoutWithButtons : this.recipeLayoutsWithButtons) {
            IRecipeLayoutDrawable<?> recipeLayout = recipeLayoutWithButtons.recipeLayout();
            Rect2i layoutArea = recipeLayout.getRect();
            GuiIconToggleButton button = recipeLayoutWithButtons.transferButton();
            Rect2i buttonArea = recipeLayout.getRecipeTransferButtonArea();
            buttonArea.m_173047_(buttonArea.m_110085_() + layoutArea.m_110085_());
            buttonArea.m_173054_(buttonArea.m_110086_() + layoutArea.m_110086_());
            button.updateBounds(buttonArea);
            button = recipeLayoutWithButtons.bookmarkButton();
            buttonArea = recipeLayout.getRecipeBookmarkButtonArea();
            buttonArea.m_173047_(buttonArea.m_110085_() + layoutArea.m_110085_());
            buttonArea.m_173054_(buttonArea.m_110086_() + layoutArea.m_110086_());
            button.updateBounds(buttonArea);
        }
    }

    private int getRecipeXOffset(ImmutableRect2i layoutRect, ImmutableRect2i layoutsArea) {
        if (this.recipeLayoutsWithButtons.isEmpty()) {
            return layoutsArea.getX();
        }
        int recipeWidth = layoutRect.getWidth();
        int recipeWidthWithButtons = this.recipeLayoutsWithButtons.get(0).totalWidth();
        int buttonSpace = recipeWidthWithButtons - recipeWidth;
        int availableArea = layoutsArea.getWidth();
        if (availableArea > recipeWidth + 2 * buttonSpace) {
            return layoutsArea.getX() + (layoutsArea.getWidth() - recipeWidth) / 2;
        }
        return layoutsArea.getX() + (layoutsArea.getWidth() - recipeWidthWithButtons) / 2;
    }

    public IUserInputHandler createInputHandler() {
        return new ProxyInputHandler(() -> {
            if (this.cachedInputHandler == null) {
                List<IUserInputHandler> handlers = this.recipeLayoutsWithButtons.stream().map(RecipeLayoutWithButtons::createUserInputHandler).toList();
                this.cachedInputHandler = new CombinedInputHandler(handlers);
            }
            return this.cachedInputHandler;
        });
    }

    public void tick(@Nullable AbstractContainerMenu parentContainer) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        for (RecipeLayoutWithButtons<?> recipeLayoutWithButtons : this.recipeLayoutsWithButtons) {
            RecipeTransferButton button = recipeLayoutWithButtons.transferButton();
            button.update(parentContainer, (Player)player);
            RecipeBookmarkButton bookmarkButton = recipeLayoutWithButtons.bookmarkButton();
            bookmarkButton.tick();
        }
    }

    public void setRecipeLayoutsWithButtons(List<RecipeLayoutWithButtons<?>> recipeLayoutsWithButtons) {
        this.recipeLayoutsWithButtons.clear();
        this.recipeLayoutsWithButtons.addAll(recipeLayoutsWithButtons);
        this.cachedInputHandler = null;
    }

    public Stream<IClickableIngredientInternal<?>> getIngredientUnderMouse(double mouseX, double mouseY) {
        return this.recipeLayoutsWithButtons.stream().map(RecipeLayoutWithButtons::recipeLayout).map(recipeLayout -> RecipeGuiLayouts.getRecipeLayoutIngredientUnderMouse(recipeLayout, mouseX, mouseY)).flatMap(Optional::stream);
    }

    private static Optional<IClickableIngredientInternal<?>> getRecipeLayoutIngredientUnderMouse(IRecipeLayoutDrawable<?> recipeLayout, double mouseX, double mouseY) {
        return recipeLayout.getRecipeSlotUnderMouse(mouseX, mouseY).flatMap(recipeSlot -> RecipeGuiLayouts.getClickedIngredient(recipeLayout, recipeSlot));
    }

    private static Optional<IClickableIngredientInternal<?>> getClickedIngredient(IRecipeLayoutDrawable<?> recipeLayout, IRecipeSlotDrawable recipeSlot) {
        return recipeSlot.getDisplayedIngredient().map(displayedIngredient -> {
            ImmutableRect2i area = RecipeGuiLayouts.absoluteClickedArea(recipeLayout, recipeSlot.getRect());
            IngredientElement element = new IngredientElement(displayedIngredient);
            return new ClickableIngredientInternal(element, area, false, true);
        });
    }

    private static ImmutableRect2i absoluteClickedArea(IRecipeLayoutDrawable<?> recipeLayout, Rect2i area) {
        Rect2i layoutArea = recipeLayout.getRect();
        return new ImmutableRect2i(area.m_110085_() + layoutArea.m_110085_(), area.m_110086_() + layoutArea.m_110086_(), area.m_110090_(), area.m_110091_());
    }

    public Optional<IRecipeLayoutDrawable<?>> draw(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        IRecipeLayoutDrawable<?> hoveredLayout = null;
        Minecraft minecraft = Minecraft.m_91087_();
        float partialTicks = minecraft.m_91297_();
        for (RecipeLayoutWithButtons<?> recipeLayoutWithButtons : this.recipeLayoutsWithButtons) {
            IRecipeLayoutDrawable<?> recipeLayout = recipeLayoutWithButtons.recipeLayout();
            if (recipeLayout.isMouseOver(mouseX, mouseY)) {
                hoveredLayout = recipeLayout;
            }
            recipeLayout.drawRecipe(guiGraphics, mouseX, mouseY);
            RecipeTransferButton transferButton = recipeLayoutWithButtons.transferButton();
            transferButton.draw(guiGraphics, mouseX, mouseY, partialTicks);
            RecipeBookmarkButton bookmarkButton = recipeLayoutWithButtons.bookmarkButton();
            bookmarkButton.draw(guiGraphics, mouseX, mouseY, partialTicks);
        }
        RenderSystem.disableBlend();
        return Optional.ofNullable(hoveredLayout);
    }

    public void drawTooltips(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        for (RecipeLayoutWithButtons<?> recipeLayoutWithButtons : this.recipeLayoutsWithButtons) {
            recipeLayoutWithButtons.transferButton().drawTooltips(guiGraphics, mouseX, mouseY);
            recipeLayoutWithButtons.bookmarkButton().drawTooltips(guiGraphics, mouseX, mouseY);
        }
    }

    public int getWidth() {
        if (this.recipeLayoutsWithButtons.isEmpty()) {
            return 0;
        }
        RecipeLayoutWithButtons<?> first = this.recipeLayoutsWithButtons.get(0);
        return first.totalWidth();
    }
}

