/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.gui.overlay;

import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import mezz.jei.api.helpers.IColorHelper;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.api.ingredients.IIngredientRenderer;
import mezz.jei.api.ingredients.ITypedIngredient;
import mezz.jei.api.runtime.IIngredientManager;
import mezz.jei.common.config.IClientToggleState;
import mezz.jei.common.config.IIngredientFilterConfig;
import mezz.jei.common.gui.JeiTooltip;
import mezz.jei.common.input.IInternalKeyMappings;
import mezz.jei.common.util.SafeIngredientUtil;
import mezz.jei.core.search.SearchMode;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;

public final class IngredientGridTooltipHelper {
    private final IIngredientManager ingredientManager;
    private final IIngredientFilterConfig ingredientFilterConfig;
    private final IClientToggleState toggleState;
    private final IInternalKeyMappings keyBindings;
    private final IColorHelper colorHelper;

    public IngredientGridTooltipHelper(IIngredientManager ingredientManager, IIngredientFilterConfig ingredientFilterConfig, IClientToggleState toggleState, IInternalKeyMappings keyBindings, IColorHelper colorHelper) {
        this.ingredientManager = ingredientManager;
        this.ingredientFilterConfig = ingredientFilterConfig;
        this.toggleState = toggleState;
        this.keyBindings = keyBindings;
        this.colorHelper = colorHelper;
    }

    public <T> JeiTooltip getIngredientTooltip(ITypedIngredient<T> typedIngredient, IIngredientRenderer<T> ingredientRenderer, IIngredientHelper<T> ingredientHelper) {
        List<Component> ingredientTooltip = SafeIngredientUtil.getTooltip(this.ingredientManager, ingredientRenderer, typedIngredient);
        JeiTooltip tooltip = new JeiTooltip();
        tooltip.addAll(ingredientTooltip);
        if (this.ingredientFilterConfig.getColorSearchMode() != SearchMode.DISABLED) {
            this.addColorSearchInfoToTooltip(tooltip, typedIngredient, ingredientHelper);
        }
        if (this.toggleState.isEditModeEnabled()) {
            IngredientGridTooltipHelper.addEditModeInfoToTooltip(tooltip, this.keyBindings);
        }
        return tooltip;
    }

    private <T> void addColorSearchInfoToTooltip(JeiTooltip tooltip, ITypedIngredient<T> typedIngredient, IIngredientHelper<T> ingredientHelper) {
        Iterable<Integer> colors = ingredientHelper.getColors(typedIngredient.getIngredient());
        String colorNamesString = StreamSupport.stream(colors.spliterator(), false).map(this.colorHelper::getClosestColorName).collect(Collectors.joining(", "));
        if (!colorNamesString.isEmpty()) {
            MutableComponent colorTranslation = Component.m_237110_((String)"jei.tooltip.item.colors", (Object[])new Object[]{colorNamesString}).m_130940_(ChatFormatting.GRAY);
            tooltip.add((FormattedText)colorTranslation);
        }
    }

    private static void addEditModeInfoToTooltip(JeiTooltip tooltip, IInternalKeyMappings keyBindings) {
        tooltip.add((FormattedText)CommonComponents.f_237098_);
        tooltip.add((FormattedText)Component.m_237115_((String)"gui.jei.editMode.description").m_130940_(ChatFormatting.DARK_GREEN));
        tooltip.addKeyUsageComponent("gui.jei.editMode.description.hide", keyBindings.getToggleHideIngredient());
        tooltip.addKeyUsageComponent("gui.jei.editMode.description.hide.wild", keyBindings.getToggleWildcardHideIngredient());
    }
}

