/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.gui.input;

import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.api.ingredients.ITypedIngredient;
import mezz.jei.api.runtime.IIngredientManager;
import mezz.jei.common.util.ErrorUtil;
import mezz.jei.common.util.ImmutableRect2i;
import mezz.jei.gui.input.IClickableIngredientInternal;
import mezz.jei.gui.overlay.elements.IElement;
import net.minecraft.world.item.ItemStack;

public class ClickableIngredientInternal<V>
implements IClickableIngredientInternal<V> {
    private final IElement<V> element;
    private final ImmutableRect2i area;
    private final boolean canClickToFocus;
    private final boolean allowsCheating;

    public ClickableIngredientInternal(IElement<V> element, ImmutableRect2i area, boolean allowsCheating, boolean canClickToFocus) {
        ErrorUtil.checkNotNull(element, "element");
        this.element = element;
        this.area = area;
        this.allowsCheating = allowsCheating;
        this.canClickToFocus = canClickToFocus;
    }

    @Override
    public ITypedIngredient<V> getTypedIngredient() {
        return this.element.getTypedIngredient();
    }

    @Override
    public IElement<V> getElement() {
        return this.element;
    }

    @Override
    public ImmutableRect2i getArea() {
        return this.area;
    }

    @Override
    public boolean canClickToFocus() {
        return this.canClickToFocus;
    }

    @Override
    public ItemStack getCheatItemStack(IIngredientManager ingredientManager) {
        if (this.allowsCheating) {
            ITypedIngredient<V> value = this.element.getTypedIngredient();
            IIngredientHelper<V> ingredientHelper = ingredientManager.getIngredientHelper(value.getType());
            return ingredientHelper.getCheatItemStack(value.getIngredient());
        }
        return ItemStack.f_41583_;
    }
}

