/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.common.gui;

import com.mojang.datafixers.util.Either;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import mezz.jei.api.helpers.IJeiHelpers;
import mezz.jei.api.helpers.IModIdHelper;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.api.ingredients.IIngredientRenderer;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.ingredients.ITypedIngredient;
import mezz.jei.api.ingredients.subtypes.UidContext;
import mezz.jei.api.runtime.IIngredientManager;
import mezz.jei.api.runtime.IJeiKeyMapping;
import mezz.jei.common.Internal;
import mezz.jei.common.config.DebugConfig;
import mezz.jei.common.platform.IPlatformRenderHelper;
import mezz.jei.common.platform.Services;
import mezz.jei.common.util.ErrorUtil;
import net.minecraft.ChatFormatting;
import net.minecraft.CrashReport;
import net.minecraft.ReportedException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.ItemStack;

public class JeiTooltip {
    private final List<Either<FormattedText, TooltipComponent>> list = new ArrayList<Either<FormattedText, TooltipComponent>>();

    public void add(FormattedText formattedText) {
        this.list.add((Either<FormattedText, TooltipComponent>)Either.left((Object)formattedText));
    }

    public void add(TooltipComponent component) {
        this.list.add((Either<FormattedText, TooltipComponent>)Either.right((Object)component));
    }

    public void addKeyUsageComponent(String translationKey, IJeiKeyMapping keyMapping) {
        MutableComponent translatedKeyMessage = keyMapping.getTranslatedKeyMessage().m_6881_();
        this.addKeyUsageComponent(translationKey, translatedKeyMessage);
    }

    public void addKeyUsageComponent(String translationKey, MutableComponent keyMapping) {
        MutableComponent boldKeyMapping = keyMapping.m_130940_(ChatFormatting.BOLD);
        MutableComponent component = Component.m_237110_((String)translationKey, (Object[])new Object[]{boldKeyMapping}).m_130940_(ChatFormatting.ITALIC).m_130940_(ChatFormatting.GRAY);
        this.add((FormattedText)component);
    }

    public void addAll(List<? extends FormattedText> components) {
        for (FormattedText formattedText : components) {
            this.add(formattedText);
        }
    }

    public void addAll(JeiTooltip tooltip) {
        this.list.addAll(tooltip.list);
    }

    public boolean isEmpty() {
        return this.list.isEmpty();
    }

    public String toString() {
        return this.list.stream().map(e -> (String)e.map(FormattedText::getString, Object::toString)).collect(Collectors.joining("\n", "[\n", "\n]"));
    }

    public void draw(GuiGraphics guiGraphics, int x, int y) {
        if (this.isEmpty()) {
            return;
        }
        Minecraft minecraft = Minecraft.m_91087_();
        Font font = minecraft.f_91062_;
        IPlatformRenderHelper renderHelper = Services.PLATFORM.getRenderHelper();
        try {
            renderHelper.renderTooltip(guiGraphics, this.list, x, y, font, ItemStack.f_41583_);
        }
        catch (RuntimeException e) {
            throw new RuntimeException("Crashed when rendering tooltip:\n" + this);
        }
    }

    public <T> void draw(GuiGraphics guiGraphics, int x, int y, ITypedIngredient<T> typedIngredient) {
        IIngredientType<T> ingredientType = typedIngredient.getType();
        IIngredientManager ingredientManager = Internal.getJeiRuntime().getIngredientManager();
        IIngredientRenderer<T> ingredientRenderer = ingredientManager.getIngredientRenderer(ingredientType);
        this.draw(guiGraphics, x, y, typedIngredient, ingredientRenderer, ingredientManager);
    }

    public <T> void draw(GuiGraphics guiGraphics, int x, int y, ITypedIngredient<T> typedIngredient, IIngredientRenderer<T> ingredientRenderer, IIngredientManager ingredientManager) {
        Minecraft minecraft = Minecraft.m_91087_();
        T ingredient = typedIngredient.getIngredient();
        Font font = ingredientRenderer.getFontRenderer(minecraft, ingredient);
        ItemStack itemStack = typedIngredient.getItemStack().orElse(ItemStack.f_41583_);
        itemStack.m_150921_().ifPresent(c -> this.list.add(1, (Either<FormattedText, TooltipComponent>)Either.right((Object)c)));
        this.addDebugInfo(ingredientManager, typedIngredient);
        IJeiHelpers jeiHelpers = Internal.getJeiRuntime().getJeiHelpers();
        IModIdHelper modIdHelper = jeiHelpers.getModIdHelper();
        modIdHelper.getModNameForTooltip(typedIngredient).ifPresent(this::add);
        if (this.isEmpty()) {
            return;
        }
        try {
            IPlatformRenderHelper renderHelper = Services.PLATFORM.getRenderHelper();
            renderHelper.renderTooltip(guiGraphics, this.list, x, y, font, itemStack);
        }
        catch (RuntimeException e) {
            CrashReport crashReport = ErrorUtil.createIngredientCrashReport(e, "Rendering ingredient tooltip", ingredientManager, typedIngredient);
            crashReport.m_127514_("tooltip").m_128159_("value", (Object)this);
            throw new ReportedException(crashReport);
        }
    }

    private <T> void addDebugInfo(IIngredientManager ingredientManager, ITypedIngredient<T> typedIngredient) {
        if (!DebugConfig.isDebugIngredientsEnabled() || !Minecraft.m_91087_().f_91066_.f_92125_) {
            return;
        }
        T ingredient = typedIngredient.getIngredient();
        IIngredientType<T> type = typedIngredient.getType();
        IIngredientHelper<T> ingredientHelper = ingredientManager.getIngredientHelper(type);
        this.add((FormattedText)Component.m_237119_());
        this.add((FormattedText)Component.m_237113_((String)"JEI Debug:").m_130940_(ChatFormatting.DARK_GRAY));
        this.add((FormattedText)Component.m_237113_((String)("* type: " + ingredientHelper.getIngredientType().getUid())).m_130940_(ChatFormatting.DARK_GRAY));
        this.add((FormattedText)Component.m_237113_((String)("* has subtypes: " + (ingredientHelper.hasSubtypes(ingredient) ? "true" : "false"))).m_130940_(ChatFormatting.DARK_GRAY));
        this.add((FormattedText)Component.m_237113_((String)("* uid: " + ingredientHelper.getUniqueId(ingredient, UidContext.Ingredient))).m_130940_(ChatFormatting.DARK_GRAY));
        this.add((FormattedText)Component.m_237113_((String)("* extra info: " + ingredientHelper.getErrorInfo(ingredient))).m_130940_(ChatFormatting.DARK_GRAY));
        this.add((FormattedText)Component.m_237119_());
    }
}

