/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.common.config;

import java.util.function.Supplier;
import mezz.jei.common.config.file.IConfigCategoryBuilder;
import mezz.jei.common.config.file.IConfigSchemaBuilder;
import mezz.jei.common.platform.IPlatformModHelper;
import mezz.jei.common.platform.Services;
import org.jetbrains.annotations.Nullable;

public final class DebugConfig {
    @Nullable
    private static DebugConfig instance;
    private final Supplier<Boolean> debugModeEnabled;
    private final Supplier<Boolean> debugGuisEnabled;
    private final Supplier<Boolean> debugInputsEnabled;
    private final Supplier<Boolean> debugIngredientsEnabled;
    private final Supplier<Boolean> crashingTestIngredientsEnabled;

    public static void create(IConfigSchemaBuilder schema) {
        instance = new DebugConfig(schema);
    }

    private DebugConfig(IConfigSchemaBuilder schema) {
        IPlatformModHelper modHelper = Services.PLATFORM.getModHelper();
        boolean inDev = modHelper.isInDev();
        IConfigCategoryBuilder advanced = schema.addCategory("debug");
        this.debugModeEnabled = advanced.addBoolean("DebugMode", false, "Debug mode enabled");
        this.debugGuisEnabled = advanced.addBoolean("DebugGuis", false, "Debug GUIs enabled");
        this.debugInputsEnabled = advanced.addBoolean("DebugInputs", false, "Debug inputs enabled");
        this.debugIngredientsEnabled = advanced.addBoolean("DebugIngredients", inDev, "Debug ingredients enabled");
        this.crashingTestIngredientsEnabled = advanced.addBoolean("CrashingTestItemsEnabled", false, "Adds ingredients to JEI that intentionally crash, to help debug JEI.");
    }

    public static boolean isDebugModeEnabled() {
        if (instance == null) {
            return false;
        }
        return DebugConfig.instance.debugModeEnabled.get();
    }

    public static boolean isDebugGuisEnabled() {
        if (instance == null) {
            return false;
        }
        return DebugConfig.instance.debugGuisEnabled.get();
    }

    public static boolean isDebugInputsEnabled() {
        if (instance == null) {
            return false;
        }
        return DebugConfig.instance.debugInputsEnabled.get();
    }

    public static boolean isDebugIngredientsEnabled() {
        if (instance == null) {
            return false;
        }
        return DebugConfig.instance.debugIngredientsEnabled.get();
    }

    public static boolean isCrashingTestIngredientsEnabled() {
        if (instance == null) {
            return false;
        }
        return DebugConfig.instance.crashingTestIngredientsEnabled.get();
    }
}

