/*
 * Decompiled with CFR 0.152.
 */
package net.fabric_extras.ranged_weapon.client;

import com.ibm.icu.text.DecimalFormat;
import java.util.List;
import net.fabric_extras.ranged_weapon.api.CustomRangedWeapon;
import net.fabric_extras.ranged_weapon.api.EntityAttributes_RangedWeapon;
import net.minecraft.class_124;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_310;
import net.minecraft.class_7417;
import net.minecraft.class_746;

public class TooltipUtil {
    public static void addPullTime(class_1799 itemStack, List<class_2561> lines) {
        int lastAttributeLine;
        int pullTime = TooltipUtil.readablePullTime(itemStack);
        if (pullTime > 0 && (lastAttributeLine = TooltipUtil.getLastAttributeLine(lines)) > 0) {
            lines.add(lastAttributeLine + 1, (class_2561)class_2561.method_43470((String)" ").method_10852((class_2561)class_2561.method_43469((String)"item.ranged_weapon.pull_time", (Object[])new Object[]{TooltipUtil.formattedNumber((float)pullTime / 20.0f)}).method_27692(class_124.field_1077)));
        }
    }

    private static int getLastAttributeLine(List<class_2561> lines) {
        int lastAttributeLine = -1;
        String attributePrefix = "attribute.modifier";
        String handPrefix = "item.modifiers";
        for (int i = 0; i < lines.size(); ++i) {
            class_2588 translatableText;
            String key;
            class_2561 line = lines.get(i);
            class_7417 content = line.method_10851();
            if (!(content instanceof class_2588) || !(key = (translatableText = (class_2588)content).method_11022()).startsWith(attributePrefix) && !key.startsWith(handPrefix)) continue;
            lastAttributeLine = i;
        }
        return lastAttributeLine;
    }

    private static int readablePullTime(class_1799 itemStack) {
        class_746 player;
        class_1792 item = itemStack.method_7909();
        double pullTime = 0.0;
        if (item instanceof CustomRangedWeapon) {
            CustomRangedWeapon customBow = (CustomRangedWeapon)item;
            pullTime = customBow.getRangedWeaponConfig().pull_time();
        }
        if ((player = class_310.method_1551().field_1724) != null && pullTime > 0.0) {
            double haste = player.method_26825(EntityAttributes_RangedWeapon.HASTE.attribute);
            pullTime /= EntityAttributes_RangedWeapon.HASTE.asMultiplier(haste);
        }
        return (int)pullTime;
    }

    private static String formattedNumber(float number) {
        DecimalFormat formatter = new DecimalFormat();
        formatter.setMaximumFractionDigits(1);
        return formatter.format((double)number);
    }
}

