/*
 * Decompiled with CFR 0.152.
 */
package net.rogues.mixin;

import java.util.Collection;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.rogues.RoguesMod;
import net.rogues.config.TweaksConfig;
import org.apache.commons.lang3.mutable.MutableFloat;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={EnchantmentHelper.class})
public abstract class EnchantmentHelperMixin {
    @Inject(method={"getAttackDamage"}, at={@At(value="RETURN")}, cancellable=true)
    private static void getAttackDamage_rebalance_RETURN(ItemStack weapon, MobType group, CallbackInfoReturnable<Float> cir) {
        Collection attackModifiers = weapon.m_41638_(EquipmentSlot.MAINHAND).get((Object)Attributes.f_22281_);
        if (attackModifiers != null && !attackModifiers.isEmpty()) {
            double attackDamage = 0.0;
            for (AttributeModifier modifier : attackModifiers) {
                if (modifier.m_22217_() != AttributeModifier.Operation.ADDITION) continue;
                attackDamage += modifier.m_22218_();
            }
            if (attackDamage > 0.0) {
                ListTag nbtList = weapon.m_41785_();
                MutableFloat mutableFloat = new MutableFloat();
                float weaponDamage = (float)attackDamage;
                for (int i = 0; i < nbtList.size(); ++i) {
                    CompoundTag nbtCompound = nbtList.m_128728_(i);
                    BuiltInRegistries.f_256876_.m_6612_(EnchantmentHelper.m_182446_((CompoundTag)nbtCompound)).ifPresent(enchantment -> {
                        int level = EnchantmentHelper.m_182438_((CompoundTag)nbtCompound);
                        float vanillaDamage = 0.0f;
                        float rebalancedDamage = 0.0f;
                        if (enchantment == Enchantments.f_44977_ && ((TweaksConfig)RoguesMod.tweaksConfig.value).enable_rebalance_enchantment_sharpness && (vanillaDamage = enchantment.m_7335_(level, group)) > 0.0f) {
                            rebalancedDamage = weaponDamage * (float)level * ((TweaksConfig)RoguesMod.tweaksConfig.value).enchantment_sharpness_multiplier_per_level;
                        }
                        if (enchantment == Enchantments.f_44978_ && ((TweaksConfig)RoguesMod.tweaksConfig.value).enable_rebalance_enchantment_smite && (vanillaDamage = enchantment.m_7335_(level, group)) > 0.0f) {
                            rebalancedDamage = weaponDamage * (float)level * ((TweaksConfig)RoguesMod.tweaksConfig.value).enchantment_smite_multiplier_per_level;
                        }
                        if (enchantment == Enchantments.f_44979_ && ((TweaksConfig)RoguesMod.tweaksConfig.value).enable_rebalance_enchantment_arthropods && (vanillaDamage = enchantment.m_7335_(level, group)) > 0.0f) {
                            rebalancedDamage = weaponDamage * (float)level * ((TweaksConfig)RoguesMod.tweaksConfig.value).enchantment_arthropods_multiplier_per_level;
                        }
                        mutableFloat.add(rebalancedDamage - vanillaDamage);
                    });
                }
                cir.setReturnValue((Object)Float.valueOf(((Float)cir.getReturnValue()).floatValue() + mutableFloat.floatValue()));
            }
        }
    }
}

