/*
 * Decompiled with CFR 0.152.
 */
package net.rogues.effect;

import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeMap;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.spell_engine.internals.WorldScheduler;
import org.jetbrains.annotations.Nullable;

public class ChargeEffect
extends MobEffect {
    private static final HashSet<MobEffect> movementImpairingEffects = new HashSet();

    protected ChargeEffect(MobEffectCategory category, int color) {
        super(category, color);
    }

    private void updateMovementImpairingEffects() {
        if (!movementImpairingEffects.isEmpty()) {
            return;
        }
        for (Holder entry : BuiltInRegistries.f_256974_.m_206115_()) {
            MobEffect effect = (MobEffect)entry.m_203334_();
            Map attributeModifiers = effect.m_19485_();
            for (Map.Entry modifierEntry : attributeModifiers.entrySet()) {
                Attribute attribute = (Attribute)modifierEntry.getKey();
                AttributeModifier modifier = (AttributeModifier)modifierEntry.getValue();
                if (attribute != Attributes.f_22279_) continue;
                double treshold = 0.0;
                switch (modifier.m_22217_()) {
                    case ADDITION: 
                    case MULTIPLY_BASE: {
                        treshold = 0.0;
                        break;
                    }
                    case MULTIPLY_TOTAL: {
                        treshold = 1.0;
                    }
                }
                if (!(modifier.m_22218_() < treshold)) continue;
                movementImpairingEffects.add(effect);
            }
        }
    }

    private void removeMovementImpairingEffects(LivingEntity entity) {
        this.updateMovementImpairingEffects();
        Collection effects = entity.m_21220_();
        for (MobEffectInstance effect : effects) {
            MobEffect type = effect.m_19544_();
            if (!movementImpairingEffects.contains(type)) continue;
            ((WorldScheduler)entity.m_9236_()).schedule(1, () -> entity.m_21195_(type));
        }
    }

    public void m_6742_(LivingEntity entity, int amplifier) {
        this.removeMovementImpairingEffects(entity);
    }

    public void m_19461_(@Nullable Entity source, @Nullable Entity attacker, LivingEntity target, int amplifier, double proximity) {
        this.removeMovementImpairingEffects(target);
    }

    public void m_6385_(LivingEntity entity, AttributeMap attributes, int amplifier) {
        super.m_6385_(entity, attributes, amplifier);
        this.removeMovementImpairingEffects(entity);
    }
}

