/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.datagen.betterend.worldgen;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.worldgen.BootstapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.biome.Biome;
import org.betterx.bclib.api.v2.levelgen.biomes.BCLBiome;
import org.betterx.bclib.api.v2.levelgen.biomes.BCLBiomeBuilder;
import org.betterx.bclib.api.v2.levelgen.biomes.BCLBiomeRegistry;
import org.betterx.bclib.api.v2.levelgen.biomes.BiomeAPI;
import org.betterx.bclib.api.v3.datagen.TagDataProvider;
import org.betterx.betterend.BetterEnd;
import org.betterx.betterend.registry.EndStructures;
import org.betterx.betterend.world.biome.EndBiome;
import org.betterx.betterend.world.biome.air.BiomeIceStarfield;
import org.betterx.betterend.world.biome.cave.EmptyAuroraCaveBiome;
import org.betterx.betterend.world.biome.cave.EmptyEndCaveBiome;
import org.betterx.betterend.world.biome.cave.EmptySmaragdantCaveBiome;
import org.betterx.betterend.world.biome.cave.EndCaveBiome;
import org.betterx.betterend.world.biome.cave.JadeCaveBiome;
import org.betterx.betterend.world.biome.cave.LushAuroraCaveBiome;
import org.betterx.betterend.world.biome.cave.LushSmaragdantCaveBiome;
import org.betterx.betterend.world.biome.land.AmberLandBiome;
import org.betterx.betterend.world.biome.land.BlossomingSpiresBiome;
import org.betterx.betterend.world.biome.land.ChorusForestBiome;
import org.betterx.betterend.world.biome.land.CrystalMountainsBiome;
import org.betterx.betterend.world.biome.land.DragonGraveyardsBiome;
import org.betterx.betterend.world.biome.land.DryShrublandBiome;
import org.betterx.betterend.world.biome.land.DustWastelandsBiome;
import org.betterx.betterend.world.biome.land.FoggyMushroomlandBiome;
import org.betterx.betterend.world.biome.land.GlowingGrasslandsBiome;
import org.betterx.betterend.world.biome.land.LanternWoodsBiome;
import org.betterx.betterend.world.biome.land.MegalakeBiome;
import org.betterx.betterend.world.biome.land.MegalakeGroveBiome;
import org.betterx.betterend.world.biome.land.NeonOasisBiome;
import org.betterx.betterend.world.biome.land.PaintedMountainsBiome;
import org.betterx.betterend.world.biome.land.ShadowForestBiome;
import org.betterx.betterend.world.biome.land.SulphurSpringsBiome;
import org.betterx.betterend.world.biome.land.UmbraValleyBiome;
import org.betterx.betterend.world.biome.land.UmbrellaJungleBiome;
import org.betterx.datagen.betterend.EndRegistrySupplier;
import org.betterx.worlds.together.tag.v3.TagManager;
import org.betterx.worlds.together.tag.v3.TagRegistry;

public class EndBiomesDataProvider
extends TagDataProvider<Biome> {
    private static final Set<BCLBiome> BIOMES = new HashSet<BCLBiome>();
    private static final EndBiome FOGGY_MUSHROOMLAND = EndBiomesDataProvider.registerBiome(new FoggyMushroomlandBiome(), BiomeAPI.BiomeType.END_LAND);
    private static final EndBiome CHORUS_FOREST = EndBiomesDataProvider.registerBiome(new ChorusForestBiome(), BiomeAPI.BiomeType.END_LAND);
    private static final EndBiome DUST_WASTELANDS = EndBiomesDataProvider.registerBiome(new DustWastelandsBiome(), BiomeAPI.BiomeType.END_LAND);
    private static final EndBiome NEON_OASIS = EndBiomesDataProvider.registerSubBiome(new NeonOasisBiome(), DUST_WASTELANDS);
    private static final EndBiome PAINTED_MOUNTAINS = EndBiomesDataProvider.registerSubBiome(new PaintedMountainsBiome(), DUST_WASTELANDS);
    private static final EndBiome MEGALAKE = EndBiomesDataProvider.registerBiome(new MegalakeBiome(), BiomeAPI.BiomeType.END_LAND);
    private static final EndBiome MEGALAKE_GROVE = EndBiomesDataProvider.registerSubBiome(new MegalakeGroveBiome(), MEGALAKE);
    private static final EndBiome CRYSTAL_MOUNTAINS = EndBiomesDataProvider.registerBiome(new CrystalMountainsBiome(), BiomeAPI.BiomeType.END_LAND);
    private static final EndBiome SHADOW_FOREST = EndBiomesDataProvider.registerBiome(new ShadowForestBiome(), BiomeAPI.BiomeType.END_LAND);
    private static final EndBiome AMBER_LAND = EndBiomesDataProvider.registerBiome(new AmberLandBiome(), BiomeAPI.BiomeType.END_LAND);
    private static final EndBiome BLOSSOMING_SPIRES = EndBiomesDataProvider.registerBiome(new BlossomingSpiresBiome(), BiomeAPI.BiomeType.END_LAND);
    private static final EndBiome SULPHUR_SPRINGS = EndBiomesDataProvider.registerBiome(new SulphurSpringsBiome(), BiomeAPI.BiomeType.END_LAND);
    private static final EndBiome UMBRELLA_JUNGLE = EndBiomesDataProvider.registerBiome(new UmbrellaJungleBiome(), BiomeAPI.BiomeType.END_LAND);
    private static final EndBiome GLOWING_GRASSLANDS = EndBiomesDataProvider.registerBiome(new GlowingGrasslandsBiome(), BiomeAPI.BiomeType.END_LAND);
    private static final EndBiome DRAGON_GRAVEYARDS = EndBiomesDataProvider.registerBiome(new DragonGraveyardsBiome(), BiomeAPI.BiomeType.END_LAND);
    private static final EndBiome DRY_SHRUBLAND = EndBiomesDataProvider.registerBiome(new DryShrublandBiome(), BiomeAPI.BiomeType.END_LAND);
    private static final EndBiome LANTERN_WOODS = EndBiomesDataProvider.registerBiome(new LanternWoodsBiome(), BiomeAPI.BiomeType.END_LAND);
    private static final EndBiome UMBRA_VALLEY = EndBiomesDataProvider.registerBiome(new UmbraValleyBiome(), BiomeAPI.BiomeType.END_LAND);
    private static final EndBiome ICE_STARFIELD = EndBiomesDataProvider.registerBiome(new BiomeIceStarfield(), BiomeAPI.BiomeType.END_VOID);
    private static final EndCaveBiome EMPTY_END_CAVE = EndBiomesDataProvider.registerCaveBiome(new EmptyEndCaveBiome());
    private static final EndCaveBiome EMPTY_SMARAGDANT_CAVE = EndBiomesDataProvider.registerCaveBiome(new EmptySmaragdantCaveBiome());
    private static final EndCaveBiome LUSH_SMARAGDANT_CAVE = EndBiomesDataProvider.registerCaveBiome(new LushSmaragdantCaveBiome());
    private static final EndCaveBiome EMPTY_AURORA_CAVE = EndBiomesDataProvider.registerCaveBiome(new EmptyAuroraCaveBiome());
    private static final EndCaveBiome LUSH_AURORA_CAVE = EndBiomesDataProvider.registerCaveBiome(new LushAuroraCaveBiome());
    private static final EndCaveBiome JADE_CAVE = EndBiomesDataProvider.registerCaveBiome(new JadeCaveBiome());

    public EndBiomesDataProvider(FabricDataOutput output, CompletableFuture<HolderLookup.Provider> registriesFuture) {
        super((TagRegistry)TagManager.BIOMES, List.of("betterend"), output, registriesFuture);
    }

    public static void bootstrap(BootstapContext<Biome> ctx) {
        BCLBiomeBuilder.registerUnbound(ctx);
        EndRegistrySupplier.INSTANCE.MAIN_LOCK.release();
        BetterEnd.LOGGER.info("Registered Biomes");
    }

    public static void bootstrapBCL(BootstapContext<BCLBiome> ctx) {
        for (BCLBiome biome : BIOMES) {
            ctx.m_255272_(biome.getBCLBiomeKey(), (Object)biome);
        }
        BetterEnd.LOGGER.info("Registered BCLBiomes: " + BCLBiomeRegistry.BUILTIN_BCL_BIOMES.m_13562_());
    }

    public static void ensureStaticallyLoaded() {
        TagManager.BIOMES.add(EndStructures.ETERNAL_PORTAL.biomeTag, new ResourceKey[]{BiomeAPI.END_BARRENS.getBiomeKey(), BiomeAPI.END_MIDLANDS.getBiomeKey(), BiomeAPI.END_HIGHLANDS.getBiomeKey()});
    }

    public static EndBiome registerSubBiome(EndBiome.Config biomeConfig, EndBiome parent) {
        EndBiome biome = EndBiome.createSubBiome(biomeConfig, parent);
        BIOMES.add(biome);
        return biome;
    }

    public static EndBiome registerBiome(EndBiome.Config biomeConfig, BiomeAPI.BiomeType type) {
        EndBiome biome = EndBiome.create(biomeConfig, type);
        BIOMES.add(biome);
        return biome;
    }

    public static EndCaveBiome registerCaveBiome(EndCaveBiome.Config biomeConfig) {
        EndCaveBiome biome = EndCaveBiome.create(biomeConfig);
        BIOMES.add(biome);
        return biome;
    }

    static {
        try {
            EndRegistrySupplier.INSTANCE.MAIN_LOCK.acquire();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }
}

