/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betterend.world.surface;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.levelgen.Noises;
import net.minecraft.world.level.levelgen.synth.NormalNoise;
import org.betterx.bclib.interfaces.NumericProvider;
import org.betterx.bclib.mixin.common.SurfaceRulesContextAccessor;

public class VerticalBandNoiseCondition
implements NumericProvider {
    public static final VerticalBandNoiseCondition DEFAULT = new VerticalBandNoiseCondition((ResourceKey<NormalNoise.NoiseParameters>)Noises.f_189258_, 4.0, 4.0, 6.0, 1.3);
    public static final Codec<VerticalBandNoiseCondition> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ResourceKey.m_195966_((ResourceKey)Registries.f_256865_).fieldOf("noise").forGetter(o -> o.noise), (App)Codec.DOUBLE.fieldOf("offset_scale").orElse((Object)4.0).forGetter(o -> o.offsetScale), (App)Codec.DOUBLE.fieldOf("band_scale").orElse((Object)4.0).forGetter(o -> o.bandScale), (App)Codec.DOUBLE.fieldOf("xz_scale").orElse((Object)6.0).forGetter(o -> o.xzScale), (App)Codec.DOUBLE.fieldOf("y_scale").orElse((Object)1.3).forGetter(o -> o.yScale)).apply((Applicative)instance, VerticalBandNoiseCondition::new));
    private final ResourceKey<NormalNoise.NoiseParameters> noise;
    private final double offsetScale;
    private final double bandScale;
    private final double xzScale;
    private final double yScale;

    public VerticalBandNoiseCondition(ResourceKey<NormalNoise.NoiseParameters> noise, double offsetScale, double bandScale, double xzScale, double yScale) {
        this.noise = noise;
        this.offsetScale = offsetScale;
        this.bandScale = bandScale;
        this.xzScale = xzScale;
        this.yScale = yScale;
    }

    public int getNumber(SurfaceRulesContextAccessor context) {
        NormalNoise normalNoise = context.getRandomState().m_224560_(this.noise);
        double offset = normalNoise.m_75380_((double)context.getBlockX() * this.xzScale, (double)context.getBlockY() * this.yScale * 10.0, (double)context.getBlockZ() * this.xzScale) * this.offsetScale;
        return (int)((double)context.getBlockY() / this.bandScale + offset);
    }

    public Codec<? extends NumericProvider> pcodec() {
        return CODEC;
    }
}

