/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betterend.world.generator;

import net.minecraft.util.Mth;
import org.betterx.bclib.config.PathConfig;

public class LayerOptions {
    public final float distance;
    public final float scale;
    public final float coverage;
    public final float center;
    public final float heightVariation;
    public final float minY;
    public final float maxY;
    public final long centerDist;
    public final boolean hasCentralIsland;

    public LayerOptions(String name, PathConfig config, float distance, float scale, float center, float heightVariation, boolean hasCentral) {
        this.distance = this.clampDistance(config.getFloat(name, "distance[1-8192]", distance));
        this.scale = this.clampScale(config.getFloat(name, "scale[0.1-1024]", scale));
        this.center = this.clampCenter(config.getFloat(name, "averageHeight[0-1]", center));
        this.heightVariation = this.clampVariation(config.getFloat(name, "heightVariation[0-1]", heightVariation));
        this.coverage = this.clampCoverage(config.getFloat(name, "coverage[0-1]", 0.5f));
        this.minY = this.center - this.heightVariation;
        this.maxY = this.center + this.heightVariation;
        this.centerDist = Mth.m_14143_((float)(1000.0f / this.distance));
        this.hasCentralIsland = config.getBoolean(name, "hasCentralIsland", hasCentral);
    }

    private float clampDistance(float value) {
        return Mth.m_14036_((float)value, (float)1.0f, (float)8192.0f);
    }

    private float clampScale(float value) {
        return Mth.m_14036_((float)value, (float)0.1f, (float)1024.0f);
    }

    private float clampCoverage(float value) {
        return 0.9999f - Mth.m_14036_((float)value, (float)0.0f, (float)1.0f) * 2.0f;
    }

    private float clampCenter(float value) {
        return Mth.m_14036_((float)value, (float)0.0f, (float)1.0f);
    }

    private float clampVariation(float value) {
        return Mth.m_14036_((float)value, (float)0.0f, (float)1.0f);
    }
}

