/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betterend.world.features.terrain;

import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import org.betterx.bclib.sdf.SDF;
import org.betterx.bclib.sdf.operator.SDFCoordModify;
import org.betterx.bclib.sdf.operator.SDFScale3D;
import org.betterx.bclib.sdf.primitive.SDFSphere;
import org.betterx.bclib.util.MHelper;
import org.betterx.betterend.world.features.terrain.OreLayerFeatureConfig;

public class OreLayerFeature
extends Feature<OreLayerFeatureConfig> {
    private static final SDFSphere SPHERE = new SDFSphere();
    private static final SDFCoordModify NOISE = new SDFCoordModify();
    private static final SDF FUNCTION;

    public OreLayerFeature() {
        super(OreLayerFeatureConfig.CODEC);
    }

    public boolean m_142674_(FeaturePlaceContext<OreLayerFeatureConfig> featureConfig) {
        OreLayerFeatureConfig cfg = (OreLayerFeatureConfig)featureConfig.m_159778_();
        RandomSource random = featureConfig.m_225041_();
        BlockPos pos = featureConfig.m_159777_();
        WorldGenLevel world = featureConfig.m_159774_();
        float radius = cfg.radius * 0.5f;
        int r = MHelper.floor((double)(radius + 1.0f));
        int posX = MHelper.randRange((int)Math.max(r - 16, 0), (int)Math.min(31 - r, 15), (RandomSource)random) + pos.m_123341_();
        int posZ = MHelper.randRange((int)Math.max(r - 16, 0), (int)Math.min(31 - r, 15), (RandomSource)random) + pos.m_123343_();
        int posY = MHelper.randRange((int)cfg.minY, (int)cfg.maxY, (RandomSource)random);
        SPHERE.setRadius(radius).setBlock(cfg.state);
        NOISE.setFunction(vec -> {
            double x = (double)(vec.x() + (float)pos.m_123341_()) * 0.1;
            double z = (double)(vec.z() + (float)pos.m_123343_()) * 0.1;
            double offset = cfg.getNoise(world.m_7328_()).eval(x, z);
            vec.set(vec.x(), vec.y() + (float)offset * 8.0f, vec.z());
        });
        FUNCTION.fillRecursive((ServerLevelAccessor)world, new BlockPos(posX, posY, posZ));
        return true;
    }

    static {
        SDFSphere body = SPHERE;
        body = new SDFScale3D().setScale(1.0f, 0.2f, 1.0f).setSource((SDF)body);
        body = NOISE.setSource((SDF)body);
        body.setReplaceFunction(state -> state.m_60713_(Blocks.f_50259_));
        FUNCTION = body;
    }
}

