/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betterend.world.features.terrain;

import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.minecraft.world.level.material.FluidState;
import org.betterx.bclib.api.v2.levelgen.features.features.DefaultFeature;
import org.betterx.bclib.util.BlocksHelper;
import org.betterx.bclib.util.MHelper;
import org.betterx.betterend.noise.OpenSimplexNoise;
import org.betterx.betterend.registry.EndBlocks;
import org.betterx.betterend.util.BlockFixer;
import org.betterx.betterend.util.GlobalState;
import org.betterx.betterend.world.biome.EndBiome;
import org.betterx.worlds.together.tag.v3.CommonBlockTags;

public class EndLakeFeature
extends DefaultFeature {
    private static final BlockState END_STONE = Blocks.f_50259_.m_49966_();
    private static final OpenSimplexNoise NOISE = new OpenSimplexNoise(15152L);

    public boolean m_142674_(FeaturePlaceContext<NoneFeatureConfiguration> featureConfig) {
        BlockState state;
        double r;
        int y;
        int x;
        BlockPos.MutableBlockPos POS = GlobalState.stateForThread().POS;
        RandomSource random = featureConfig.m_225041_();
        BlockPos blockPos = featureConfig.m_159777_();
        WorldGenLevel world = featureConfig.m_159774_();
        double radius = MHelper.randRange((double)10.0, (double)20.0, (RandomSource)random);
        double depth = radius * 0.5 * MHelper.randRange((double)0.8, (double)1.2, (RandomSource)random);
        int dist = MHelper.floor((double)radius);
        int dist2 = MHelper.floor((double)(radius * 1.5));
        int bott = MHelper.floor((double)depth);
        if ((blockPos = EndLakeFeature.getPosOnSurfaceWG((WorldGenLevel)world, (BlockPos)blockPos)).m_123342_() < 10) {
            return false;
        }
        int waterLevel = blockPos.m_123342_();
        BlockPos pos = EndLakeFeature.getPosOnSurfaceRaycast((WorldGenLevel)world, (BlockPos)blockPos.m_122013_(dist).m_6630_(10), (int)20);
        if (Math.abs(blockPos.m_123342_() - pos.m_123342_()) > 5) {
            return false;
        }
        waterLevel = MHelper.min((int)pos.m_123342_(), (int)waterLevel);
        pos = EndLakeFeature.getPosOnSurfaceRaycast((WorldGenLevel)world, (BlockPos)blockPos.m_122020_(dist).m_6630_(10), (int)20);
        if (Math.abs(blockPos.m_123342_() - pos.m_123342_()) > 5) {
            return false;
        }
        waterLevel = MHelper.min((int)pos.m_123342_(), (int)waterLevel);
        pos = EndLakeFeature.getPosOnSurfaceRaycast((WorldGenLevel)world, (BlockPos)blockPos.m_122030_(dist).m_6630_(10), (int)20);
        if (Math.abs(blockPos.m_123342_() - pos.m_123342_()) > 5) {
            return false;
        }
        waterLevel = MHelper.min((int)pos.m_123342_(), (int)waterLevel);
        pos = EndLakeFeature.getPosOnSurfaceRaycast((WorldGenLevel)world, (BlockPos)blockPos.m_122025_(dist).m_6630_(10), (int)20);
        if (Math.abs(blockPos.m_123342_() - pos.m_123342_()) > 5) {
            return false;
        }
        waterLevel = MHelper.min((int)pos.m_123342_(), (int)waterLevel);
        int minX = blockPos.m_123341_() - dist2;
        int maxX = blockPos.m_123341_() + dist2;
        int minZ = blockPos.m_123343_() - dist2;
        int maxZ = blockPos.m_123343_() + dist2;
        int maskMinX = minX - 1;
        int maskMinZ = minZ - 1;
        boolean[][] mask = new boolean[maxX - minX + 3][maxZ - minZ + 3];
        for (x = minX; x <= maxX; ++x) {
            POS.m_142451_(x);
            int mx = x - maskMinX;
            block1: for (int z = minZ; z <= maxZ; ++z) {
                POS.m_142443_(z);
                int mz = z - maskMinZ;
                if (mask[mx][mz]) continue;
                for (int y2 = waterLevel + 1; y2 <= waterLevel + 20; ++y2) {
                    POS.m_142448_(y2);
                    FluidState fluid = world.m_6425_((BlockPos)POS);
                    if (fluid.m_76178_()) continue;
                    for (int i = -1; i < 2; ++i) {
                        int px = mx + i;
                        for (int j = -1; j < 2; ++j) {
                            int pz = mz + j;
                            mask[px][pz] = true;
                        }
                    }
                    continue block1;
                }
            }
        }
        for (x = minX; x <= maxX; ++x) {
            POS.m_142451_(x);
            int x2 = x - blockPos.m_123341_();
            x2 *= x2;
            int mx = x - maskMinX;
            block6: for (int z = minZ; z <= maxZ; ++z) {
                POS.m_142443_(z);
                int z2 = z - blockPos.m_123343_();
                z2 *= z2;
                int mz = z - maskMinZ;
                if (mask[mx][mz]) continue;
                double size = 1.0;
                for (y = blockPos.m_123342_(); y <= blockPos.m_123342_() + 20; ++y) {
                    POS.m_142448_(y);
                    double add = y - blockPos.m_123342_();
                    if (add > 5.0) {
                        size *= 0.8;
                        add = 5.0;
                    }
                    if (!((r = add * 1.8 + radius * (NOISE.eval((double)x * 0.2, (double)y * 0.2, (double)z * 0.2) * 0.25 + 0.75) - 1.0 / size) > 0.0)) continue block6;
                    if (!((double)(x2 + z2) <= (r *= r))) continue;
                    state = world.m_8055_((BlockPos)POS);
                    if (state.m_204336_(CommonBlockTags.GEN_END_STONES)) {
                        BlocksHelper.setWithoutUpdate((LevelAccessor)world, (BlockPos)POS, (BlockState)AIR);
                    }
                    if (!world.m_8055_(pos = POS.m_7495_()).m_204336_(CommonBlockTags.GEN_END_STONES)) continue;
                    state = EndBiome.findTopMaterial(world, pos);
                    if (y > waterLevel + 1) {
                        BlocksHelper.setWithoutUpdate((LevelAccessor)world, (BlockPos)pos, (BlockState)state);
                        continue;
                    }
                    if (y > waterLevel) {
                        BlocksHelper.setWithoutUpdate((LevelAccessor)world, (BlockPos)pos, (BlockState)(random.m_188499_() ? state : EndBlocks.ENDSTONE_DUST.m_49966_()));
                        continue;
                    }
                    BlocksHelper.setWithoutUpdate((LevelAccessor)world, (BlockPos)pos, (BlockState)EndBlocks.ENDSTONE_DUST.m_49966_());
                }
            }
        }
        double aspect = radius / depth;
        for (int x2 = blockPos.m_123341_() - dist; x2 <= blockPos.m_123341_() + dist; ++x2) {
            POS.m_142451_(x2);
            int x22 = x2 - blockPos.m_123341_();
            x22 *= x22;
            int mx = x2 - maskMinX;
            for (int z = blockPos.m_123343_() - dist; z <= blockPos.m_123343_() + dist; ++z) {
                POS.m_142443_(z);
                int z2 = z - blockPos.m_123343_();
                z2 *= z2;
                int mz = z - maskMinZ;
                if (mask[mx][mz]) continue;
                for (y = blockPos.m_123342_() - bott; y < blockPos.m_123342_(); ++y) {
                    POS.m_142448_(y);
                    double y2 = (double)(y - blockPos.m_123342_()) * aspect;
                    y2 *= y2;
                    r = radius * (NOISE.eval((double)x2 * 0.2, (double)y * 0.2, (double)z * 0.2) * 0.25 + 0.75);
                    double rb = r * 1.2;
                    r *= r;
                    rb *= rb;
                    if (y2 + (double)x22 + (double)z2 <= r) {
                        state = world.m_8055_((BlockPos)POS);
                        if (this.canReplace(state)) {
                            state = world.m_8055_(POS.m_7494_());
                            state = this.canReplace(state) ? (y < waterLevel ? WATER : AIR) : state;
                            BlocksHelper.setWithoutUpdate((LevelAccessor)world, (BlockPos)POS, (BlockState)state);
                        }
                        if (world.m_8055_(pos = POS.m_7495_()).m_204336_(CommonBlockTags.GEN_END_STONES)) {
                            BlocksHelper.setWithoutUpdate((LevelAccessor)world, (BlockPos)pos, (BlockState)EndBlocks.ENDSTONE_DUST.m_49966_());
                        }
                        pos = POS.m_7494_();
                        while (this.canReplace(state = world.m_8055_(pos)) && !state.m_60795_() && state.m_60819_().m_76178_()) {
                            BlocksHelper.setWithoutUpdate((LevelAccessor)world, (BlockPos)pos, (BlockState)(pos.m_123342_() < waterLevel ? WATER : AIR));
                            pos = pos.m_7494_();
                        }
                        continue;
                    }
                    if (y >= waterLevel || !(y2 + (double)x22 + (double)z2 <= rb)) continue;
                    if (world.m_46859_(POS.m_7494_())) {
                        state = EndBiome.findTopMaterial(world, pos);
                        BlocksHelper.setWithoutUpdate((LevelAccessor)world, (BlockPos)POS, (BlockState)(random.m_188499_() ? state : EndBlocks.ENDSTONE_DUST.m_49966_()));
                        BlocksHelper.setWithoutUpdate((LevelAccessor)world, (BlockPos)POS.m_7495_(), (BlockState)END_STONE);
                        continue;
                    }
                    BlocksHelper.setWithoutUpdate((LevelAccessor)world, (BlockPos)POS, (BlockState)EndBlocks.ENDSTONE_DUST.m_49966_());
                    BlocksHelper.setWithoutUpdate((LevelAccessor)world, (BlockPos)POS.m_7495_(), (BlockState)END_STONE);
                }
            }
        }
        BlockFixer.fixBlocks((LevelAccessor)world, new BlockPos(minX - 2, waterLevel - 2, minZ - 2), new BlockPos(maxX + 2, blockPos.m_123342_() + 20, maxZ + 2));
        return true;
    }

    private boolean canReplace(BlockState state) {
        return state.m_204336_(CommonBlockTags.GEN_END_STONES) || state.m_60713_(EndBlocks.ENDSTONE_DUST) || BlocksHelper.replaceableOrPlant((BlockState)state) != false || state.m_204336_(CommonBlockTags.WATER_PLANT);
    }
}

