/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betterend.world.features;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.RandomizableContainerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorType;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import org.betterx.bclib.util.StructureHelper;
import org.betterx.betterend.util.LootTableUtil;
import org.betterx.betterend.world.features.BuildingListFeatureConfig;
import org.betterx.betterend.world.features.NBTFeature;
import org.betterx.worlds.together.tag.v3.CommonBlockTags;
import org.jetbrains.annotations.Nullable;

public class BuildingListFeature
extends NBTFeature<BuildingListFeatureConfig> {
    private StructureInfo selected;

    public BuildingListFeature() {
        super(BuildingListFeatureConfig.CODEC);
    }

    @Override
    protected void addStructureData(StructurePlaceSettings data) {
        data.m_74383_((StructureProcessor)new ChestProcessor());
    }

    @Override
    protected StructureTemplate getStructure(BuildingListFeatureConfig cfg, WorldGenLevel world, BlockPos pos, RandomSource random) {
        this.selected = cfg.getRandom(random);
        return this.selected.getStructure();
    }

    @Override
    protected boolean canSpawn(WorldGenLevel world, BlockPos pos, RandomSource random) {
        int cz;
        int cx = pos.m_123341_() >> 4;
        return (cx + (cz = pos.m_123343_() >> 4) & 1) == 0 && pos.m_123342_() > 58 && world.m_8055_(pos).m_60795_() && world.m_8055_(pos.m_7495_()).m_204336_(CommonBlockTags.TERRAIN);
    }

    @Override
    protected Rotation getRotation(WorldGenLevel world, BlockPos pos, RandomSource random) {
        return Rotation.m_221990_((RandomSource)random);
    }

    @Override
    protected Mirror getMirror(WorldGenLevel world, BlockPos pos, RandomSource random) {
        return Mirror.values()[random.m_188503_(3)];
    }

    @Override
    protected int getYOffset(StructureTemplate structure, WorldGenLevel world, BlockPos pos, RandomSource random) {
        return this.selected.offsetY;
    }

    @Override
    protected NBTFeature.TerrainMerge getTerrainMerge(WorldGenLevel world, BlockPos pos, RandomSource random) {
        return this.selected.terrainMerge;
    }

    class ChestProcessor
    extends StructureProcessor {
        ChestProcessor() {
        }

        @Nullable
        public StructureTemplate.StructureBlockInfo m_7382_(LevelReader levelReader, BlockPos blockPos, BlockPos blockPos2, StructureTemplate.StructureBlockInfo structureBlockInfo, StructureTemplate.StructureBlockInfo structureBlockInfo2, StructurePlaceSettings structurePlaceSettings) {
            BlockState blockState = structureBlockInfo2.f_74676_();
            if (blockState.m_60734_() instanceof ChestBlock) {
                RandomSource random = structurePlaceSettings.m_230326_(structureBlockInfo2.f_74675_());
                BlockPos chestPos = structureBlockInfo2.f_74675_();
                ChestBlock chestBlock = (ChestBlock)blockState.m_60734_();
                BlockEntity entity = chestBlock.m_142194_(chestPos, blockState);
                levelReader.m_46865_(chestPos).m_142169_(entity);
                RandomizableContainerBlockEntity chestEntity = (RandomizableContainerBlockEntity)entity;
                Holder biome = levelReader.m_203495_(chestPos.m_123341_() >> 2, chestPos.m_123342_() >> 2, chestPos.m_123343_() >> 2);
                chestEntity.m_59626_(LootTableUtil.getTable((Holder<Biome>)biome), random.m_188505_());
                chestEntity.m_6596_();
            }
            return structureBlockInfo2;
        }

        protected StructureProcessorType<?> m_6953_() {
            return StructureProcessorType.f_74461_;
        }
    }

    public static final class StructureInfo {
        public static final Codec<StructureInfo> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf("path").forGetter(o -> o.structurePath), (App)Codec.INT.fieldOf("offset_y").forGetter(o -> o.offsetY), (App)NBTFeature.TerrainMerge.CODEC.fieldOf("terrain_merger").forGetter(o -> o.terrainMerge)).apply((Applicative)instance, StructureInfo::new));
        public final NBTFeature.TerrainMerge terrainMerge;
        public final String structurePath;
        public final int offsetY;
        private StructureTemplate structure;

        public StructureInfo(String structurePath, int offsetY, NBTFeature.TerrainMerge terrainMerge) {
            this.terrainMerge = terrainMerge;
            this.structurePath = structurePath;
            this.offsetY = offsetY;
        }

        public StructureTemplate getStructure() {
            if (this.structure == null) {
                this.structure = StructureHelper.readStructure((String)this.structurePath);
            }
            return this.structure;
        }
    }
}

