/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betterend.world.biome.cave;

import com.mojang.serialization.Codec;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.KeyDispatchDataCodec;
import net.minecraft.util.Mth;
import net.minecraft.world.level.biome.Climate;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import org.betterx.bclib.api.v2.levelgen.biomes.BCLBiome;
import org.betterx.bclib.api.v2.levelgen.biomes.BCLBiomeBuilder;
import org.betterx.bclib.api.v2.levelgen.biomes.BCLBiomeSettings;
import org.betterx.bclib.interfaces.SurfaceMaterialProvider;
import org.betterx.bclib.util.WeightedList;
import org.betterx.betterend.noise.OpenSimplexNoise;
import org.betterx.betterend.registry.EndBlocks;
import org.betterx.betterend.world.biome.EndBiome;
import org.betterx.betterend.world.biome.cave.EndCaveBiome;

public class JadeCaveBiome
extends EndCaveBiome.Config {
    public static final Codec<Biome> CODEC = EndCaveBiome.simpleCaveBiomeCodec(Biome::new);
    public static final KeyDispatchDataCodec<Biome> KEY_CODEC = KeyDispatchDataCodec.m_216236_(CODEC);

    public JadeCaveBiome() {
        super("jade_cave");
    }

    @Override
    protected void addCustomBuildData(BCLBiomeBuilder builder) {
        super.addCustomBuildData(builder);
        builder.fogColor(118, 150, 112).fogDensity(2.0f).waterAndFogColor(95, 223, 255);
    }

    @Override
    public BCLBiomeBuilder.BiomeSupplier<EndBiome> getSupplier() {
        return Biome::new;
    }

    public static class Biome
    extends EndCaveBiome {
        private static final OpenSimplexNoise WALL_NOISE = new OpenSimplexNoise("jade_cave".hashCode());
        private static final OpenSimplexNoise DEPTH_NOISE = new OpenSimplexNoise("depth_noise".hashCode());
        private static final BlockState[] JADE = new BlockState[3];

        public Biome(ResourceKey<net.minecraft.world.level.biome.Biome> biomeID, BCLBiomeSettings settings) {
            super(biomeID, settings);
        }

        @Override
        public KeyDispatchDataCodec<? extends BCLBiome> codec() {
            return KEY_CODEC;
        }

        protected Biome(float terrainHeight, float fogDensity, float genChance, int edgeSize, boolean vertical, Optional<ResourceLocation> edge, ResourceLocation biomeID, Optional<List<Climate.ParameterPoint>> parameterPoints, Optional<ResourceLocation> biomeParent, Optional<String> intendedType, boolean hasCaves, SurfaceMaterialProvider surface, WeightedList<Holder<ConfiguredFeature<?, ?>>> floorFeatures, WeightedList<Holder<ConfiguredFeature<?, ?>>> ceilFeatures) {
            super(terrainHeight, fogDensity, genChance, edgeSize, vertical, edge, biomeID, parameterPoints, biomeParent, intendedType, hasCaves, surface, floorFeatures, ceilFeatures);
        }

        @Override
        public BlockState getWall(BlockPos pos) {
            double depth = DEPTH_NOISE.eval((double)pos.m_123341_() * 0.02, (double)pos.m_123343_() * 0.02) * 0.2 + 0.5;
            int index = Mth.m_14107_((double)(((double)pos.m_123342_() + WALL_NOISE.eval((double)pos.m_123341_() * 0.2, (double)pos.m_123343_() * 0.2) * 1.5) * depth + 0.5));
            index = Mth.m_14040_((int)index) % 3;
            return JADE[index];
        }

        static {
            Biome.JADE[0] = EndBlocks.VIRID_JADESTONE.stone.m_49966_();
            Biome.JADE[1] = EndBlocks.AZURE_JADESTONE.stone.m_49966_();
            Biome.JADE[2] = EndBlocks.SANDY_JADESTONE.stone.m_49966_();
        }
    }
}

