/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betterend.util;

import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.IntStream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FallingBlock;
import net.minecraft.world.level.block.state.BlockState;
import org.betterx.bclib.blocks.BaseDoublePlantBlock;
import org.betterx.bclib.blocks.BaseVineBlock;
import org.betterx.bclib.blocks.StalactiteBlock;
import org.betterx.bclib.util.BlocksHelper;
import org.betterx.betterend.blocks.BlueVineBlock;
import org.betterx.betterend.blocks.basis.FurBlock;
import org.betterx.betterend.registry.EndBlocks;

public class BlockFixer {
    private static final BlockState AIR = Blocks.f_50016_.m_49966_();
    private static final BlockState WATER = Blocks.f_49990_.m_49966_();

    public static void fixBlocks(LevelAccessor level, BlockPos start, BlockPos end) {
        Registry registry = level.m_9598_().m_175515_(Registries.f_256787_);
        ResourceLocation dimKey = registry.m_7981_((Object)level.m_6042_());
        if (dimKey != null && "world_blender".equals(dimKey.m_135827_())) {
            return;
        }
        Set doubleCheck = Sets.newConcurrentHashSet();
        int dx = end.m_123341_() - start.m_123341_() + 1;
        int dz = end.m_123343_() - start.m_123343_() + 1;
        int count = dx * dz;
        int minY = Math.max(start.m_123342_(), level.m_141937_());
        int maxY = Math.min(end.m_123342_(), level.m_151558_());
        IntStream.range(0, count).forEach(index -> {
            BlockPos.MutableBlockPos POS = new BlockPos.MutableBlockPos();
            POS.m_142451_(index % dx + start.m_123341_());
            POS.m_142443_(index / dx + start.m_123343_());
            block2: for (int y = minY; y <= maxY; ++y) {
                POS.m_142448_(y);
                BlockState state = level.m_8055_((BlockPos)POS);
                if (state.m_60734_() instanceof FurBlock) {
                    doubleCheck.add(POS.m_7949_());
                    continue;
                }
                if (!state.m_60819_().m_76178_()) {
                    if (!state.m_60710_((LevelReader)level, (BlockPos)POS)) {
                        BlockFixer.setWithoutUpdate(level, (BlockPos)POS, WATER);
                        POS.m_142448_(POS.m_123342_() - 1);
                        state = level.m_8055_((BlockPos)POS);
                        while (!state.m_60710_((LevelReader)level, (BlockPos)POS)) {
                            state = state.m_60819_().m_76178_() ? AIR : WATER;
                            BlockFixer.setWithoutUpdate(level, (BlockPos)POS, state);
                            POS.m_142448_(POS.m_123342_() - 1);
                            state = level.m_8055_((BlockPos)POS);
                        }
                    }
                    POS.m_142448_(y - 1);
                    if (level.m_46859_((BlockPos)POS)) {
                        POS.m_142448_(y);
                        while (!level.m_6425_((BlockPos)POS).m_76178_()) {
                            BlockFixer.setWithoutUpdate(level, (BlockPos)POS, AIR);
                            POS.m_142448_(POS.m_123342_() + 1);
                        }
                        continue;
                    }
                    for (Direction dir : BlocksHelper.HORIZONTAL) {
                        if (!level.m_46859_(POS.m_121945_(dir))) continue;
                        try {
                            level.m_186469_((BlockPos)POS, state.m_60819_().m_76152_(), 0);
                        }
                        catch (Exception exception) {}
                        continue block2;
                    }
                    continue;
                }
                if (state.m_60713_(EndBlocks.SMARAGDANT_CRYSTAL) || state.m_60713_(EndBlocks.BUDDING_SMARAGDANT_CRYSTAL)) {
                    POS.m_142448_(POS.m_123342_() - 1);
                    if (!level.m_46859_((BlockPos)POS)) continue;
                    POS.m_142448_(POS.m_123342_() + 1);
                    while (state.m_60713_(EndBlocks.SMARAGDANT_CRYSTAL) || state.m_60713_(EndBlocks.BUDDING_SMARAGDANT_CRYSTAL)) {
                        BlockFixer.setWithoutUpdate(level, (BlockPos)POS, AIR);
                        POS.m_142448_(POS.m_123342_() + 1);
                        state = level.m_8055_((BlockPos)POS);
                    }
                    continue;
                }
                if (state.m_60734_() instanceof StalactiteBlock) {
                    if (state.m_60710_((LevelReader)level, (BlockPos)POS)) continue;
                    if (level.m_8055_(POS.m_7494_()).m_60734_() instanceof StalactiteBlock) {
                        while (state.m_60734_() instanceof StalactiteBlock) {
                            BlockFixer.setWithoutUpdate(level, (BlockPos)POS, AIR);
                            POS.m_142448_(POS.m_123342_() + 1);
                            state = level.m_8055_((BlockPos)POS);
                        }
                        continue;
                    }
                    while (state.m_60734_() instanceof StalactiteBlock) {
                        BlockFixer.setWithoutUpdate(level, (BlockPos)POS, AIR);
                        POS.m_142448_(POS.m_123342_() - 1);
                        state = level.m_8055_((BlockPos)POS);
                    }
                    continue;
                }
                if (state.m_60713_(EndBlocks.CAVE_PUMPKIN)) {
                    if (level.m_8055_(POS.m_7494_()).m_60713_(EndBlocks.CAVE_PUMPKIN_SEED)) continue;
                    BlockFixer.setWithoutUpdate(level, (BlockPos)POS, AIR);
                    continue;
                }
                if (state.m_60710_((LevelReader)level, (BlockPos)POS)) continue;
                if (state.m_60713_(Blocks.f_50490_)) {
                    HashSet ends = Sets.newHashSet();
                    HashSet add = Sets.newHashSet();
                    ends.add(POS.m_7949_());
                    for (int i = 0; i < 64 && !ends.isEmpty(); ++i) {
                        ends.forEach(pos -> {
                            BlockFixer.setWithoutUpdate(level, pos, AIR);
                            for (Direction dir : BlocksHelper.HORIZONTAL) {
                                BlockPos p = pos.m_121945_(dir);
                                BlockState st = level.m_8055_(p);
                                if (!st.m_60713_(Blocks.f_50490_) && !st.m_60713_(Blocks.f_50491_) || st.m_60710_((LevelReader)level, p)) continue;
                                add.add(p);
                            }
                            BlockPos p = pos.m_7494_();
                            BlockState st = level.m_8055_(p);
                            if ((st.m_60713_(Blocks.f_50490_) || st.m_60713_(Blocks.f_50491_)) && !st.m_60710_((LevelReader)level, p)) {
                                add.add(p);
                            }
                        });
                        ends.clear();
                        ends.addAll(add);
                        add.clear();
                    }
                    continue;
                }
                if (state.m_60734_() instanceof BaseVineBlock) {
                    while (level.m_8055_((BlockPos)POS).m_60734_() instanceof BaseVineBlock) {
                        BlockFixer.setWithoutUpdate(level, (BlockPos)POS, AIR);
                        POS.m_142448_(POS.m_123342_() - 1);
                    }
                    continue;
                }
                if (state.m_60734_() instanceof FallingBlock) {
                    BlockState falling = state;
                    POS.m_142448_(POS.m_123342_() - 1);
                    state = level.m_8055_((BlockPos)POS);
                    int ray = BlocksHelper.downRayRep((LevelAccessor)level, (BlockPos)POS.m_7949_(), (int)64);
                    if (ray > 32) {
                        BlockFixer.setWithoutUpdate(level, (BlockPos)POS, Blocks.f_50259_.m_49966_());
                        if (!level.m_213780_().m_188499_()) continue;
                        POS.m_142448_(POS.m_123342_() - 1);
                        state = level.m_8055_((BlockPos)POS);
                        BlockFixer.setWithoutUpdate(level, (BlockPos)POS, Blocks.f_50259_.m_49966_());
                        continue;
                    }
                    POS.m_142448_(y);
                    BlockState replacement = AIR;
                    for (Direction dir : BlocksHelper.HORIZONTAL) {
                        state = level.m_8055_(POS.m_121945_(dir));
                        if (state.m_60819_().m_76178_()) continue;
                        replacement = state;
                        break;
                    }
                    BlockFixer.setWithoutUpdate(level, (BlockPos)POS, replacement);
                    POS.m_142448_(y - ray);
                    BlockFixer.setWithoutUpdate(level, (BlockPos)POS, falling);
                    continue;
                }
                if (state.m_60734_() instanceof BlueVineBlock) {
                    while (state.m_60713_(EndBlocks.BLUE_VINE) || state.m_60713_(EndBlocks.BLUE_VINE_LANTERN) || state.m_60713_(EndBlocks.BLUE_VINE_FUR)) {
                        BlockFixer.setWithoutUpdate(level, (BlockPos)POS, AIR);
                        POS.m_142448_(POS.m_123342_() + 1);
                        state = level.m_8055_((BlockPos)POS);
                    }
                }
                if (state.m_60734_() instanceof BaseDoublePlantBlock) {
                    BlockFixer.setWithoutUpdate(level, (BlockPos)POS, AIR);
                    POS.m_142448_(POS.m_123342_() + 1);
                    BlockFixer.setWithoutUpdate(level, (BlockPos)POS, AIR);
                    continue;
                }
                BlockFixer.setWithoutUpdate(level, (BlockPos)POS, BlockFixer.getAirOrFluid(state));
            }
        });
        doubleCheck.forEach(pos -> {
            if (!level.m_8055_(pos).m_60710_((LevelReader)level, pos)) {
                BlockFixer.setWithoutUpdate(level, pos, AIR);
            }
        });
    }

    private static BlockState getAirOrFluid(BlockState state) {
        return state.m_60819_().m_76178_() ? AIR : state.m_60819_().m_76188_();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void setWithoutUpdate(LevelAccessor world, BlockPos pos, BlockState state) {
        LevelAccessor levelAccessor = world;
        synchronized (levelAccessor) {
            BlocksHelper.setWithoutUpdate((LevelAccessor)world, (BlockPos)pos, (BlockState)state);
        }
    }
}

