/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betterend.recipe.builders;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Arrays;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.EnchantedBookItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentInstance;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.betterx.bclib.BCLib;
import org.betterx.bclib.interfaces.UnknownReceipBookCategory;
import org.betterx.bclib.recipes.AbstractSingleInputRecipeBuilder;
import org.betterx.bclib.recipes.BCLRecipeManager;
import org.betterx.bclib.util.ItemUtil;
import org.betterx.betterend.BetterEnd;
import org.betterx.betterend.rituals.InfusionRitual;

public class InfusionRecipe
implements Recipe<InfusionRitual>,
UnknownReceipBookCategory {
    public static final String GROUP = "infusion";
    public static final RecipeType<InfusionRecipe> TYPE = BCLRecipeManager.registerType((String)"betterend", (String)"infusion");
    public static final Serializer SERIALIZER = (Serializer)BCLRecipeManager.registerSerializer((String)"betterend", (String)"infusion", (RecipeSerializer)new Serializer());
    private final ResourceLocation id;
    private final Ingredient[] catalysts;
    private Ingredient input;
    private ItemStack output;
    private int time = 1;
    private String group;

    private InfusionRecipe(ResourceLocation id) {
        this(id, null, null);
    }

    private InfusionRecipe(ResourceLocation id, Ingredient input, ItemStack output) {
        this.id = id;
        this.input = input;
        this.output = output;
        this.catalysts = new Ingredient[]{Ingredient.f_43901_, Ingredient.f_43901_, Ingredient.f_43901_, Ingredient.f_43901_, Ingredient.f_43901_, Ingredient.f_43901_, Ingredient.f_43901_, Ingredient.f_43901_};
    }

    public static Builder create(String id, ItemLike output) {
        return InfusionRecipe.create(BetterEnd.makeID(id), output);
    }

    public static Builder create(ResourceLocation id, ItemLike output) {
        return new Builder(id, output);
    }

    public static Builder create(String id, ItemStack output) {
        return InfusionRecipe.create(BetterEnd.makeID(id), output);
    }

    public static Builder create(ResourceLocation id, ItemStack output) {
        return new Builder(id, output);
    }

    public static Builder create(String id, Enchantment enchantment, int level) {
        return InfusionRecipe.create(BetterEnd.makeID(id), enchantment, level);
    }

    public static Builder create(ResourceLocation id, Enchantment enchantment, int level) {
        return new Builder(id, InfusionRecipe.createEnchantedBook(enchantment, level));
    }

    public static ItemStack createEnchantedBook(Enchantment enchantment, int level) {
        ItemStack book = new ItemStack((ItemLike)Items.f_42690_);
        EnchantedBookItem.m_41153_((ItemStack)book, (EnchantmentInstance)new EnchantmentInstance(enchantment, level));
        return book;
    }

    public int getInfusionTime() {
        return this.time;
    }

    public boolean matches(InfusionRitual inv, Level world) {
        boolean valid = this.input.test(inv.m_8020_(0));
        if (!valid) {
            return false;
        }
        for (int i = 0; i < 8; ++i) {
            valid &= this.catalysts[i].test(inv.m_8020_(i + 1));
        }
        return valid;
    }

    public ItemStack assemble(InfusionRitual ritual, RegistryAccess acc) {
        return this.output.m_41777_();
    }

    public boolean m_8004_(int width, int height) {
        return true;
    }

    public NonNullList<Ingredient> m_7527_() {
        NonNullList defaultedList = NonNullList.m_122779_();
        defaultedList.add((Object)this.input);
        defaultedList.addAll(Arrays.asList(this.catalysts));
        return defaultedList;
    }

    public ItemStack m_8043_(RegistryAccess acc) {
        return this.output;
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public RecipeSerializer<?> m_7707_() {
        return SERIALIZER;
    }

    public RecipeType<?> m_6671_() {
        return TYPE;
    }

    public static void register() {
    }

    public static class Builder
    extends AbstractSingleInputRecipeBuilder<Builder, InfusionRecipe> {
        private final Ingredient[] catalysts = new Ingredient[]{Ingredient.f_43901_, Ingredient.f_43901_, Ingredient.f_43901_, Ingredient.f_43901_, Ingredient.f_43901_, Ingredient.f_43901_, Ingredient.f_43901_, Ingredient.f_43901_};
        private int time = 1;

        protected Builder(ResourceLocation id, ItemLike output) {
            this(id, new ItemStack(output, 1));
        }

        protected Builder(ResourceLocation id, ItemStack output) {
            super(id, output);
        }

        public Builder setGroup(String group) {
            return (Builder)super.setGroup(group);
        }

        @Deprecated(forRemoval=true)
        public Builder setInput(ItemLike input) {
            super.setPrimaryInputAndUnlock(new ItemLike[]{input});
            return this;
        }

        public Builder setTime(int time) {
            this.time = time;
            return this;
        }

        public Builder addCatalyst(Catalysts slot, ItemLike ... items) {
            this.catalysts[slot.index] = Ingredient.m_43929_((ItemLike[])items);
            return this;
        }

        public Builder addCatalyst(Catalysts slot, ItemStack stack) {
            this.catalysts[slot.index] = Ingredient.m_43927_((ItemStack[])new ItemStack[]{stack});
            return this;
        }

        public Builder addCatalyst(Catalysts slot, TagKey<Item> tag) {
            this.catalysts[slot.index] = Ingredient.m_204132_(tag);
            return this;
        }

        protected boolean checkRecipe() {
            if (this.time < 0) {
                BCLib.LOGGER.warning("Time should be positive, recipe {} will be ignored!", new Object[]{this.id});
                return false;
            }
            return super.checkRecipe();
        }

        protected void serializeRecipeData(JsonObject root) {
            super.serializeRecipeData(root);
            if (this.time != 1) {
                root.addProperty("time", (Number)this.time);
            }
            JsonObject catalystObject = new JsonObject();
            for (Catalysts cat : Catalysts.values()) {
                if (this.catalysts[cat.index] == null || this.catalysts[cat.index].m_43947_()) continue;
                catalystObject.add(cat.key, ItemUtil.toJsonIngredientWithNBT((Ingredient)this.catalysts[cat.index]));
            }
            root.add("catalysts", (JsonElement)catalystObject);
        }

        protected RecipeSerializer<InfusionRecipe> getSerializer() {
            return SERIALIZER;
        }
    }

    public static class Serializer
    implements RecipeSerializer<InfusionRecipe> {
        private Ingredient readIngredient(JsonObject obj, String key) {
            if (obj.has(key)) {
                JsonElement el = obj.get(key);
                if (el.isJsonObject()) {
                    JsonObject o = el.getAsJsonObject();
                    if (o.has("tag")) {
                        Ingredient res = ItemUtil.fromJsonIngredientWithNBT((JsonObject)o);
                        if (res == null) {
                            return Ingredient.f_43901_;
                        }
                        return res;
                    }
                    Ingredient res = Ingredient.m_43927_((ItemStack[])new ItemStack[]{ItemUtil.fromJsonRecipeWithNBT((JsonObject)o)});
                    if (res == null) {
                        return Ingredient.f_43901_;
                    }
                    return res;
                }
                if (el.isJsonArray()) {
                    Ingredient res = Ingredient.m_43917_((JsonElement)el);
                    if (res == null) {
                        return Ingredient.f_43901_;
                    }
                    return res;
                }
                if (obj.isJsonPrimitive()) {
                    String s = GsonHelper.m_13851_((JsonObject)obj, (String)key, (String)"");
                    ItemStack catalyst = ItemUtil.fromStackString((String)s);
                    return catalyst != null && !catalyst.m_41619_() ? Ingredient.m_43929_((ItemLike[])new ItemLike[]{catalyst.m_41720_()}) : Ingredient.f_43901_;
                }
                throw new IllegalStateException("Invalid catalyst ingredient for " + key + ": " + el.toString());
            }
            return Ingredient.f_43901_;
        }

        public InfusionRecipe fromJson(ResourceLocation id, JsonObject json) {
            InfusionRecipe recipe = new InfusionRecipe(id);
            JsonObject inputObject = GsonHelper.m_13930_((JsonObject)json, (String)"input");
            recipe.input = ItemUtil.fromJsonIngredientWithNBT((JsonObject)inputObject);
            JsonObject result = GsonHelper.m_13930_((JsonObject)json, (String)"result");
            recipe.output = ItemUtil.fromJsonRecipeWithNBT((JsonObject)result);
            if (recipe.output == null) {
                throw new IllegalStateException("Output item does not exists!");
            }
            recipe.group = GsonHelper.m_13851_((JsonObject)json, (String)"group", (String)InfusionRecipe.GROUP);
            recipe.time = GsonHelper.m_13824_((JsonObject)json, (String)"time", (int)1);
            JsonObject catalysts = GsonHelper.m_13930_((JsonObject)json, (String)"catalysts");
            for (Catalysts cat : Catalysts.values()) {
                recipe.catalysts[cat.index] = this.readIngredient(catalysts, cat.key);
            }
            return recipe;
        }

        public InfusionRecipe fromNetwork(ResourceLocation id, FriendlyByteBuf buffer) {
            InfusionRecipe recipe = new InfusionRecipe(id);
            recipe.input = Ingredient.m_43940_((FriendlyByteBuf)buffer);
            recipe.output = buffer.m_130267_();
            recipe.group = buffer.m_130277_();
            recipe.time = buffer.m_130242_();
            for (int i = 0; i < 8; ++i) {
                recipe.catalysts[i] = Ingredient.m_43940_((FriendlyByteBuf)buffer);
            }
            return recipe;
        }

        public void toNetwork(FriendlyByteBuf buffer, InfusionRecipe recipe) {
            recipe.input.m_43923_(buffer);
            buffer.m_130055_(recipe.output);
            buffer.m_130070_(recipe.group);
            buffer.m_130130_(recipe.time);
            for (int i = 0; i < 8; ++i) {
                recipe.catalysts[i].m_43923_(buffer);
            }
        }
    }

    public static enum Catalysts {
        NORTH(0, "north"),
        NORTH_EAST(1, "north_east"),
        EAST(2, "east"),
        SOUTH_EAST(3, "south_east"),
        SOUTH(4, "south"),
        SOUTH_WEST(5, "south_west"),
        WEST(6, "west"),
        NORTH_WEST(7, "north_west");

        public final int index;
        public final String key;

        private Catalysts(int index, String key) {
            this.index = index;
            this.key = key;
        }
    }
}

