/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betterend.item.material;

import java.util.function.Supplier;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.LazyLoadedValue;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import org.betterx.betterend.registry.EndBlocks;
import org.betterx.betterend.registry.EndItems;

public enum EndArmorMaterial implements ArmorMaterial
{
    THALLASIUM("thallasium", 17, new int[]{1, 4, 5, 2}, 12, SoundEvents.f_11677_, 0.0f, 0.0f, () -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{EndBlocks.THALLASIUM.ingot})),
    TERMINITE("terminite", 26, new int[]{3, 6, 7, 3}, 14, SoundEvents.f_11677_, 1.0f, 0.05f, () -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{EndBlocks.TERMINITE.ingot})),
    AETERNIUM("aeternium", 40, new int[]{4, 7, 9, 4}, 18, SoundEvents.f_11679_, 3.5f, 0.2f, () -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{EndItems.AETERNIUM_INGOT})),
    CRYSTALITE("crystalite", 30, new int[]{3, 6, 8, 3}, 24, SoundEvents.f_11673_, 1.2f, 0.1f, () -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{EndBlocks.TERMINITE.ingot}));

    private static final int[] BASE_DURABILITY;
    private final String name;
    private final int durabilityMultiplier;
    private final int[] protectionAmounts;
    private final int enchantability;
    private final SoundEvent equipSound;
    private final float toughness;
    private final float knockbackResistance;
    private final LazyLoadedValue<Ingredient> repairIngredient;

    private EndArmorMaterial(String name, int durabilityMultiplier, int[] protectionAmounts, int enchantability, SoundEvent equipSound, float toughness, float knockbackResistance, Supplier<Ingredient> repairIngredient) {
        this.name = name;
        this.durabilityMultiplier = durabilityMultiplier;
        this.protectionAmounts = protectionAmounts;
        this.enchantability = enchantability;
        this.equipSound = equipSound;
        this.toughness = toughness;
        this.knockbackResistance = knockbackResistance;
        this.repairIngredient = new LazyLoadedValue(repairIngredient);
    }

    public int m_266425_(ArmorItem.Type type) {
        return BASE_DURABILITY[type.m_266308_().m_20749_()] * this.durabilityMultiplier;
    }

    public int m_7366_(ArmorItem.Type type) {
        return this.protectionAmounts[type.m_266308_().m_20749_()];
    }

    public int m_6646_() {
        return this.enchantability;
    }

    public SoundEvent m_7344_() {
        return this.equipSound;
    }

    public Ingredient m_6230_() {
        return (Ingredient)this.repairIngredient.m_13971_();
    }

    public String m_6082_() {
        return this.name;
    }

    public float m_6651_() {
        return this.toughness;
    }

    public float m_6649_() {
        return this.knockbackResistance;
    }

    static {
        BASE_DURABILITY = new int[]{13, 15, 16, 11};
    }
}

