/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betterend.integration.rei;

import com.google.common.collect.Lists;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import me.shedaniel.math.Point;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.gui.widgets.Widget;
import me.shedaniel.rei.api.client.gui.widgets.Widgets;
import me.shedaniel.rei.api.client.registry.display.DisplayCategory;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.entry.EntryStack;
import net.minecraft.network.chat.Component;
import org.betterx.betterend.integration.rei.REIAlloyingDisplay;
import org.betterx.betterend.integration.rei.REIPlugin;
import org.betterx.betterend.registry.EndBlocks;
import org.jetbrains.annotations.NotNull;

public class REIAlloyingCategory
implements DisplayCategory<REIAlloyingDisplay> {
    private final EntryStack ICON;

    REIAlloyingCategory(EntryStack icon) {
        this.ICON = icon;
    }

    @NotNull
    public CategoryIdentifier getCategoryIdentifier() {
        return REIPlugin.ALLOYING;
    }

    @NotNull
    public Component getTitle() {
        return Component.m_237115_((String)EndBlocks.END_STONE_SMELTER.m_7705_());
    }

    @NotNull
    public EntryStack getIcon() {
        return this.ICON;
    }

    @NotNull
    public List<Widget> setupDisplay(REIAlloyingDisplay display, Rectangle bounds) {
        Point startPoint = new Point(bounds.getCenterX() - 41, bounds.y + 10);
        double smeltTime = display.getSmeltTime();
        DecimalFormat df = new DecimalFormat("###.##");
        ArrayList widgets = Lists.newArrayList();
        widgets.add(Widgets.createRecipeBase((Rectangle)bounds));
        widgets.add(Widgets.createResultSlotBackground((Point)new Point(startPoint.x + 61, startPoint.y + 9)));
        widgets.add(Widgets.createBurningFire((Point)new Point(startPoint.x - 9, startPoint.y + 20)).animationDurationMS(10000.0));
        widgets.add(Widgets.createLabel((Point)new Point(bounds.x + bounds.width - 5, bounds.y + 5), (Component)Component.m_237110_((String)"category.rei.cooking.time&xp", (Object[])new Object[]{df.format(display.getXp()), df.format(smeltTime / 20.0)})).noShadow().rightAligned().color(-12566464, -4473925));
        widgets.add(Widgets.createArrow((Point)new Point(startPoint.x + 24, startPoint.y + 8)).animationDurationTicks(smeltTime));
        List inputEntries = display.getInputEntries();
        widgets.add(Widgets.createSlot((Point)new Point(startPoint.x - 20, startPoint.y + 1)).entries((Collection)inputEntries.get(0)).markInput());
        if (inputEntries.size() > 1) {
            widgets.add(Widgets.createSlot((Point)new Point(startPoint.x + 1, startPoint.y + 1)).entries((Collection)inputEntries.get(1)).markInput());
        } else {
            widgets.add(Widgets.createSlot((Point)new Point(startPoint.x + 1, startPoint.y + 1)).entries((Collection)Lists.newArrayList()).markInput());
        }
        widgets.add(Widgets.createSlot((Point)new Point(startPoint.x + 61, startPoint.y + 9)).entries((Collection)display.getOutputEntries().get(0)).disableBackground().markOutput());
        return widgets;
    }

    public int getDisplayHeight() {
        return 49;
    }
}

