/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betterend.client.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import org.betterx.bclib.util.MHelper;
import org.betterx.betterend.BetterEnd;
import org.betterx.betterend.blocks.AuroraCrystalBlock;
import org.betterx.ui.ColorUtil;

public class EternalCrystalRenderer {
    private static final RenderType RENDER_LAYER = RenderType.m_110467_((ResourceLocation)BetterEnd.makeID("textures/entity/eternal_crystal.png"));
    private static final ModelPart[] SHARDS = new ModelPart[4];
    private static final ModelPart CORE;

    public static void render(int age, float tickDelta, PoseStack matrices, MultiBufferSource vertexConsumerProvider, int light) {
        VertexConsumer vertexConsumer = vertexConsumerProvider.m_6299_(RENDER_LAYER);
        float[] colors = EternalCrystalRenderer.colors(age);
        float rotation = ((float)age + tickDelta) / 25.0f + 6.0f;
        matrices.m_85836_();
        matrices.m_85841_(0.6f, 0.6f, 0.6f);
        matrices.m_252781_(Axis.f_252436_.m_252961_(rotation));
        CORE.m_104306_(matrices, vertexConsumer, light, OverlayTexture.f_118083_, colors[0], colors[1], colors[2], colors[3]);
        for (int i = 0; i < 4; ++i) {
            matrices.m_85836_();
            float offset = Mth.m_14031_((float)(rotation * 2.0f + (float)i)) * 0.15f;
            matrices.m_252880_(0.0f, offset, 0.0f);
            SHARDS[i].m_104306_(matrices, vertexConsumer, light, OverlayTexture.f_118083_, colors[0], colors[1], colors[2], colors[3]);
            matrices.m_85849_();
        }
        matrices.m_85849_();
    }

    public static float[] colors(int age) {
        double delta = (double)age * 0.01;
        int index = MHelper.floor((double)delta);
        int index2 = index + 1 & 3;
        delta -= (double)index;
        Vec3i color1 = AuroraCrystalBlock.COLORS[index &= 3];
        Vec3i color2 = AuroraCrystalBlock.COLORS[index2];
        int r = MHelper.floor((double)Mth.m_14139_((double)delta, (double)color1.m_123341_(), (double)color2.m_123341_()));
        int g = MHelper.floor((double)Mth.m_14139_((double)delta, (double)color1.m_123342_(), (double)color2.m_123342_()));
        int b = MHelper.floor((double)Mth.m_14139_((double)delta, (double)color1.m_123343_(), (double)color2.m_123343_()));
        return ColorUtil.toFloatArray((int)ColorUtil.color((int)r, (int)g, (int)b));
    }

    public static LayerDefinition getTexturedModelData() {
        MeshDefinition modelData = new MeshDefinition();
        PartDefinition modelPartData = modelData.m_171576_();
        modelPartData.m_171599_("SHARDS_0", CubeListBuilder.m_171558_().m_171514_(2, 4).m_171481_(-5.0f, 1.0f, -3.0f, 2.0f, 8.0f, 2.0f), PartPose.f_171404_);
        modelPartData.m_171599_("SHARDS_1", CubeListBuilder.m_171558_().m_171514_(2, 4).m_171481_(3.0f, -1.0f, -1.0f, 2.0f, 8.0f, 2.0f), PartPose.f_171404_);
        modelPartData.m_171599_("SHARDS_2", CubeListBuilder.m_171558_().m_171514_(2, 4).m_171481_(-1.0f, 0.0f, -5.0f, 2.0f, 4.0f, 2.0f), PartPose.f_171404_);
        modelPartData.m_171599_("SHARDS_3", CubeListBuilder.m_171558_().m_171514_(2, 4).m_171481_(0.0f, 3.0f, 4.0f, 2.0f, 6.0f, 2.0f), PartPose.f_171404_);
        modelPartData.m_171599_("CORE", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(-2.0f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f), PartPose.f_171404_);
        return LayerDefinition.m_171565_((MeshDefinition)modelData, (int)16, (int)16);
    }

    static {
        ModelPart root = EternalCrystalRenderer.getTexturedModelData().m_171564_();
        EternalCrystalRenderer.SHARDS[0] = root.m_171324_("SHARDS_0");
        EternalCrystalRenderer.SHARDS[1] = root.m_171324_("SHARDS_1");
        EternalCrystalRenderer.SHARDS[2] = root.m_171324_("SHARDS_2");
        EternalCrystalRenderer.SHARDS[3] = root.m_171324_("SHARDS_3");
        CORE = root.m_171324_("CORE");
    }
}

