/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betterend.client.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import org.joml.Quaternionf;

public class EndCrystalRenderer {
    private static final ResourceLocation CRYSTAL_TEXTURE = new ResourceLocation("textures/entity/end_crystal/end_crystal.png");
    private static final ResourceLocation CRYSTAL_BEAM_TEXTURE = new ResourceLocation("textures/entity/end_crystal/end_crystal_beam.png");
    private static final RenderType END_CRYSTAL = RenderType.m_110458_((ResourceLocation)CRYSTAL_TEXTURE);
    private static final ModelPart CORE;
    private static final ModelPart FRAME;
    private static final int AGE_CYCLE = 240;
    private static final float SINE_45_DEGREES;
    private static final Quaternionf ROTATOR;

    public static void render(int age, int maxAge, float tickDelta, PoseStack matrices, MultiBufferSource vertexConsumerProvider, int light) {
        float k = 240.0f / (float)maxAge;
        float rotation = ((float)age * k + tickDelta) * 3.0f;
        VertexConsumer vertexConsumer = vertexConsumerProvider.m_6299_(END_CRYSTAL);
        matrices.m_85836_();
        matrices.m_85841_(0.8f, 0.8f, 0.8f);
        matrices.m_85837_(0.0, -0.5, 0.0);
        matrices.m_252781_(Axis.f_252436_.m_252977_(rotation));
        matrices.m_85837_(0.0, (double)0.8f, 0.0);
        matrices.m_252781_(ROTATOR);
        FRAME.m_104301_(matrices, vertexConsumer, light, OverlayTexture.f_118083_);
        matrices.m_85841_(0.875f, 0.875f, 0.875f);
        matrices.m_252781_(ROTATOR);
        matrices.m_252781_(Axis.f_252436_.m_252977_(rotation));
        FRAME.m_104301_(matrices, vertexConsumer, light, OverlayTexture.f_118083_);
        matrices.m_85841_(0.875f, 0.875f, 0.875f);
        matrices.m_252781_(ROTATOR);
        matrices.m_252781_(Axis.f_252436_.m_252977_(rotation));
        CORE.m_104301_(matrices, vertexConsumer, light, OverlayTexture.f_118083_);
        matrices.m_85849_();
    }

    public static LayerDefinition getTexturedModelData() {
        MeshDefinition modelData = new MeshDefinition();
        PartDefinition modelPartData = modelData.m_171576_();
        modelPartData.m_171599_("FRAME", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(-4.0f, -4.0f, -4.0f, 8.0f, 8.0f, 8.0f), PartPose.f_171404_);
        modelPartData.m_171599_("CORE", CubeListBuilder.m_171558_().m_171514_(32, 0).m_171481_(-4.0f, -4.0f, -4.0f, 8.0f, 8.0f, 8.0f), PartPose.f_171404_);
        return LayerDefinition.m_171565_((MeshDefinition)modelData, (int)64, (int)32);
    }

    static {
        RenderType.m_110476_((ResourceLocation)CRYSTAL_BEAM_TEXTURE);
        SINE_45_DEGREES = (float)Math.sin(0.7853981633974483);
        ModelPart root = EndCrystalRenderer.getTexturedModelData().m_171564_();
        FRAME = root.m_171324_("FRAME");
        CORE = root.m_171324_("CORE");
        ROTATOR = new Quaternionf().setAngleAxis(1.0471976f, SINE_45_DEGREES, 0.0f, SINE_45_DEGREES);
    }
}

