/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betterend.blocks;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.EnumMap;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.betterx.bclib.behaviours.BehaviourBuilders;
import org.betterx.bclib.behaviours.interfaces.BehaviourPlant;
import org.betterx.bclib.blocks.BaseAttachedBlock;
import org.betterx.bclib.client.render.BCLRenderLayer;
import org.betterx.bclib.interfaces.RenderLayerProvider;
import org.betterx.bclib.items.tool.BaseShearsItem;
import org.betterx.bclib.util.BlocksHelper;
import org.betterx.betterend.interfaces.PottablePlant;
import org.betterx.betterend.registry.EndFeatures;
import org.betterx.betterend.world.features.trees.JellyshroomFeature;
import org.betterx.worlds.together.tag.v3.CommonBlockTags;

public class SmallJellyshroomBlock
extends BaseAttachedBlock
implements RenderLayerProvider,
BonemealableBlock,
PottablePlant,
BehaviourPlant {
    private static final EnumMap<Direction, VoxelShape> BOUNDING_SHAPES = Maps.newEnumMap(Direction.class);

    public SmallJellyshroomBlock() {
        super(BehaviourBuilders.createPlant((MapColor)MapColor.f_283869_).m_60918_(SoundType.f_56761_).m_222979_(BlockBehaviour.OffsetType.NONE));
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter view, BlockPos pos, CollisionContext ePos) {
        return BOUNDING_SHAPES.get(state.m_61143_((Property)FACING));
    }

    public List<ItemStack> m_49635_(BlockState state, LootParams.Builder builder) {
        ItemStack tool = (ItemStack)builder.m_287261_(LootContextParams.f_81463_);
        if (tool != null && BaseShearsItem.isShear((ItemStack)tool) || EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44985_, (ItemStack)tool) > 0) {
            return Lists.newArrayList((Object[])new ItemStack[]{new ItemStack((ItemLike)this)});
        }
        return Lists.newArrayList();
    }

    public boolean m_7898_(BlockState state, LevelReader world, BlockPos pos) {
        Direction direction = (Direction)state.m_61143_((Property)FACING);
        BlockPos blockPos = pos.m_121945_(direction.m_122424_());
        BlockState support = world.m_8055_(blockPos);
        return SmallJellyshroomBlock.m_49863_((LevelReader)world, (BlockPos)blockPos, (Direction)direction) && support.m_60815_() && support.m_60791_() == 0;
    }

    public BCLRenderLayer getRenderLayer() {
        return BCLRenderLayer.CUTOUT;
    }

    public boolean m_7370_(LevelReader world, BlockPos pos, BlockState state, boolean isClient) {
        return state.m_61143_((Property)FACING) == Direction.UP && world.m_8055_(pos.m_7495_()).m_204336_(CommonBlockTags.END_STONES);
    }

    public boolean m_214167_(Level world, RandomSource random, BlockPos pos, BlockState state) {
        return random.m_188503_(16) == 0;
    }

    public void m_214148_(ServerLevel world, RandomSource random, BlockPos pos, BlockState state) {
        BlocksHelper.setWithUpdate((LevelAccessor)world, (BlockPos)pos, (Block)Blocks.f_50016_);
        ((JellyshroomFeature)EndFeatures.JELLYSHROOM.getFeature()).m_142674_((FeaturePlaceContext<NoneFeatureConfiguration>)new FeaturePlaceContext(Optional.empty(), (WorldGenLevel)world, null, random, pos, null));
    }

    @Override
    public boolean canPlantOn(Block block) {
        return true;
    }

    static {
        BOUNDING_SHAPES.put(Direction.UP, Block.m_49796_((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)16.0, (double)13.0));
        BOUNDING_SHAPES.put(Direction.DOWN, Block.m_49796_((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)16.0, (double)13.0));
        BOUNDING_SHAPES.put(Direction.NORTH, Shapes.m_83048_((double)0.0, (double)0.0, (double)0.5, (double)1.0, (double)1.0, (double)1.0));
        BOUNDING_SHAPES.put(Direction.SOUTH, Shapes.m_83048_((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)1.0, (double)0.5));
        BOUNDING_SHAPES.put(Direction.WEST, Shapes.m_83048_((double)0.5, (double)0.0, (double)0.0, (double)1.0, (double)1.0, (double)1.0));
        BOUNDING_SHAPES.put(Direction.EAST, Shapes.m_83048_((double)0.0, (double)0.0, (double)0.0, (double)0.5, (double)1.0, (double)1.0));
    }
}

