/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betterend.blocks;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.fabricmc.fabric.api.object.builder.v1.block.FabricBlockSettings;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.betterx.bclib.behaviours.interfaces.BehaviourStone;
import org.betterx.bclib.blocks.BaseBlockNotFull;
import org.betterx.bclib.client.render.BCLRenderLayer;
import org.betterx.bclib.interfaces.PostInitable;
import org.betterx.bclib.interfaces.RenderLayerProvider;
import org.betterx.bclib.util.BlocksHelper;
import org.betterx.bclib.util.JsonFactory;
import org.betterx.betterend.blocks.EndBlockProperties;
import org.betterx.betterend.config.Configs;
import org.betterx.betterend.interfaces.PottablePlant;
import org.betterx.betterend.interfaces.PottableTerrain;
import org.betterx.betterend.registry.EndBlocks;

public class FlowerPotBlock
extends BaseBlockNotFull
implements RenderLayerProvider,
PostInitable {
    private static final IntegerProperty PLANT_ID = EndBlockProperties.PLANT_ID;
    private static final IntegerProperty SOIL_ID = EndBlockProperties.SOIL_ID;
    private static final IntegerProperty POT_LIGHT = EndBlockProperties.POT_LIGHT;
    private static final VoxelShape SHAPE_EMPTY = Shapes.m_83110_((VoxelShape)Block.m_49796_((double)4.0, (double)1.0, (double)4.0, (double)12.0, (double)8.0, (double)12.0), (VoxelShape)Block.m_49796_((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)1.0, (double)11.0));
    private static final VoxelShape SHAPE_FULL = Shapes.m_83110_((VoxelShape)SHAPE_EMPTY, (VoxelShape)Block.m_49796_((double)3.0, (double)8.0, (double)3.0, (double)13.0, (double)16.0, (double)13.0));
    private static Block[] plants;
    private static Block[] soils;

    public FlowerPotBlock(Block source) {
        super((BlockBehaviour.Properties)FabricBlockSettings.copyOf((BlockBehaviour)source).luminance(state -> (Integer)state.m_61143_((Property)POT_LIGHT) * 5));
        this.m_49959_((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)PLANT_ID, (Comparable)Integer.valueOf(0))).m_61124_((Property)SOIL_ID, (Comparable)Integer.valueOf(0))).m_61124_((Property)POT_LIGHT, (Comparable)Integer.valueOf(0)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{PLANT_ID, SOIL_ID, POT_LIGHT});
    }

    public List<ItemStack> m_49635_(BlockState state, LootParams.Builder builder) {
        ArrayList drop = Lists.newArrayList((Object[])new ItemStack[]{new ItemStack((ItemLike)this)});
        int id = (Integer)state.m_61143_((Property)SOIL_ID) - 1;
        if (id >= 0 && id < soils.length && soils[id] != null) {
            drop.add(new ItemStack((ItemLike)soils[id]));
        }
        if ((id = (Integer)state.m_61143_((Property)PLANT_ID) - 1) >= 0 && id < plants.length && plants[id] != null) {
            drop.add(new ItemStack((ItemLike)plants[id]));
        }
        return drop;
    }

    public BlockState m_7417_(BlockState state, Direction facing, BlockState neighborState, LevelAccessor world, BlockPos pos, BlockPos neighborPos) {
        int plantID = (Integer)state.m_61143_((Property)PLANT_ID);
        if (plantID < 1 || plantID > plants.length || plants[plantID - 1] == null) {
            return (Integer)state.m_61143_((Property)POT_LIGHT) > 0 ? (BlockState)state.m_61124_((Property)POT_LIGHT, (Comparable)Integer.valueOf(0)) : state;
        }
        int light = plants[plantID - 1].m_49966_().m_60791_() / 5;
        if ((Integer)state.m_61143_((Property)POT_LIGHT) != light) {
            state = (BlockState)state.m_61124_((Property)POT_LIGHT, (Comparable)Integer.valueOf(light));
        }
        return state;
    }

    public void postInit() {
        if (plants != null) {
            return;
        }
        Block[] plants = new Block[128];
        Block[] soils = new Block[16];
        HashMap reservedPlantsIDs = Maps.newHashMap();
        HashMap reservedSoilIDs = Maps.newHashMap();
        JsonObject obj = JsonFactory.getJsonObject((File)new File(FabricLoader.getInstance().getConfigDir().toFile(), "betterend/blocks.json"));
        if (obj.get("flower_pots") != null) {
            JsonElement plantsObj = obj.get("flower_pots").getAsJsonObject().get("plants");
            JsonElement soilsObj = obj.get("flower_pots").getAsJsonObject().get("soils");
            if (plantsObj != null) {
                plantsObj.getAsJsonObject().entrySet().forEach(entry -> {
                    String name = ((String)entry.getKey()).substring(0, ((String)entry.getKey()).indexOf(32));
                    reservedPlantsIDs.put(name, ((JsonElement)entry.getValue()).getAsInt());
                });
            }
            if (soilsObj != null) {
                soilsObj.getAsJsonObject().entrySet().forEach(entry -> {
                    String name = ((String)entry.getKey()).substring(0, ((String)entry.getKey()).indexOf(32));
                    reservedSoilIDs.put(name, ((JsonElement)entry.getValue()).getAsInt());
                });
            }
        }
        EndBlocks.getModBlocks().forEach(block -> {
            if (block instanceof PottablePlant && ((PottablePlant)block).canBePotted()) {
                this.processBlock(plants, (Block)block, "flower_pots.plants", reservedPlantsIDs);
            } else if (block instanceof PottableTerrain && ((PottableTerrain)block).canBePotted()) {
                this.processBlock(soils, (Block)block, "flower_pots.soils", reservedSoilIDs);
            }
        });
        Configs.BLOCK_CONFIG.saveChanges();
        FlowerPotBlock.plants = new Block[this.maxNotNull(plants) + 1];
        System.arraycopy(plants, 0, FlowerPotBlock.plants, 0, FlowerPotBlock.plants.length);
        FlowerPotBlock.soils = new Block[this.maxNotNull(soils) + 1];
        System.arraycopy(soils, 0, FlowerPotBlock.soils, 0, FlowerPotBlock.soils.length);
        if (PLANT_ID.m_6215_(Integer.toString(FlowerPotBlock.plants.length)).isEmpty()) {
            throw new RuntimeException("There are too much plant ID values!");
        }
        if (SOIL_ID.m_6215_(Integer.toString(FlowerPotBlock.soils.length)).isEmpty()) {
            throw new RuntimeException("There are too much soil ID values!");
        }
    }

    private int maxNotNull(Block[] array) {
        int max = 0;
        for (int i = 0; i < array.length; ++i) {
            if (array[i] == null) continue;
            max = i;
        }
        return max;
    }

    private void processBlock(Block[] target, Block block, String path, Map<String, Integer> idMap) {
        ResourceLocation location = BuiltInRegistries.f_256975_.m_7981_((Object)block);
        if (idMap.containsKey(location.m_135815_())) {
            target[idMap.get((Object)location.m_135815_()).intValue()] = block;
        } else {
            for (int i = 0; i < target.length; ++i) {
                if (idMap.containsValue(i)) continue;
                target[i] = block;
                idMap.put(location.m_135815_(), i);
                Configs.BLOCK_CONFIG.getInt(path, location.m_135815_(), i);
                break;
            }
        }
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (level.f_46443_) {
            return InteractionResult.CONSUME;
        }
        ItemStack itemStack = player.m_21120_(hand);
        int soilID = (Integer)state.m_61143_((Property)SOIL_ID);
        if (soilID == 0 || soilID > soils.length || soils[soilID - 1] == null) {
            if (!(itemStack.m_41720_() instanceof BlockItem)) {
                return InteractionResult.PASS;
            }
            Block block = ((BlockItem)itemStack.m_41720_()).m_40614_();
            for (int i = 0; i < soils.length; ++i) {
                if (block != soils[i]) continue;
                BlocksHelper.setWithUpdate((LevelAccessor)level, (BlockPos)pos, (BlockState)((BlockState)state.m_61124_((Property)SOIL_ID, (Comparable)Integer.valueOf(i + 1))));
                if (!player.m_7500_()) {
                    itemStack.m_41774_(1);
                }
                level.m_6263_(player, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, SoundEvents.f_12401_, SoundSource.BLOCKS, 1.0f, 1.0f);
                return InteractionResult.SUCCESS;
            }
            return InteractionResult.PASS;
        }
        int plantID = (Integer)state.m_61143_((Property)PLANT_ID);
        if (itemStack.m_41619_()) {
            if (plantID > 0 && plantID <= plants.length && plants[plantID - 1] != null) {
                BlocksHelper.setWithUpdate((LevelAccessor)level, (BlockPos)pos, (BlockState)((BlockState)((BlockState)state.m_61124_((Property)PLANT_ID, (Comparable)Integer.valueOf(0))).m_61124_((Property)POT_LIGHT, (Comparable)Integer.valueOf(0))));
                player.m_36356_(new ItemStack((ItemLike)plants[plantID - 1]));
                return InteractionResult.SUCCESS;
            }
            if (soilID > 0 && soilID <= soils.length && soils[soilID - 1] != null) {
                BlocksHelper.setWithUpdate((LevelAccessor)level, (BlockPos)pos, (BlockState)((BlockState)state.m_61124_((Property)SOIL_ID, (Comparable)Integer.valueOf(0))));
                player.m_36356_(new ItemStack((ItemLike)soils[soilID - 1]));
            }
            return InteractionResult.PASS;
        }
        if (!(itemStack.m_41720_() instanceof BlockItem)) {
            return InteractionResult.PASS;
        }
        BlockItem item = (BlockItem)itemStack.m_41720_();
        for (int i = 0; i < plants.length; ++i) {
            if (item.m_40614_() != plants[i]) continue;
            if (!((PottablePlant)plants[i]).canPlantOn(soils[soilID - 1])) {
                return InteractionResult.PASS;
            }
            int light = plants[i].m_49966_().m_60791_() / 5;
            BlocksHelper.setWithUpdate((LevelAccessor)level, (BlockPos)pos, (BlockState)((BlockState)((BlockState)state.m_61124_((Property)PLANT_ID, (Comparable)Integer.valueOf(i + 1))).m_61124_((Property)POT_LIGHT, (Comparable)Integer.valueOf(light))));
            level.m_6263_(player, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, SoundEvents.f_11955_, SoundSource.BLOCKS, 1.0f, 1.0f);
            if (!player.m_7500_()) {
                itemStack.m_41774_(1);
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter view, BlockPos pos, CollisionContext ePos) {
        int id = (Integer)state.m_61143_((Property)PLANT_ID);
        return id > 0 && id <= plants.length ? SHAPE_FULL : SHAPE_EMPTY;
    }

    public VoxelShape m_5939_(BlockState state, BlockGetter view, BlockPos pos, CollisionContext ePos) {
        return SHAPE_EMPTY;
    }

    public BCLRenderLayer getRenderLayer() {
        return BCLRenderLayer.CUTOUT;
    }

    public static class Stone
    extends FlowerPotBlock
    implements BehaviourStone {
        public Stone(Block source) {
            super(source);
        }
    }
}

