/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betterend.blocks;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import org.betterx.bclib.behaviours.interfaces.BehaviourStone;
import org.betterx.betterend.blocks.EndBlockProperties;
import org.betterx.betterend.blocks.basis.PedestalBlock;
import org.betterx.betterend.blocks.entities.EternalPedestalEntity;
import org.betterx.betterend.registry.EndBlocks;
import org.betterx.betterend.registry.EndPortals;
import org.betterx.betterend.rituals.EternalRitual;

public class EternalPedestal
extends PedestalBlock
implements BehaviourStone {
    public static final BooleanProperty ACTIVATED = EndBlockProperties.ACTIVE;

    public EternalPedestal() {
        super(EndBlocks.FLAVOLITE_RUNED_ETERNAL);
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)ACTIVATED, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    public void checkRitual(Level sourceLevel, Player player, BlockPos pos) {
        BlockEntity blockEntity = sourceLevel.m_7702_(pos);
        if (blockEntity instanceof EternalPedestalEntity) {
            EternalPedestalEntity pedestal = (EternalPedestalEntity)blockEntity;
            BlockState updatedState = sourceLevel.m_8055_(pos);
            if (pedestal.m_7983_()) {
                EternalRitual ritual;
                if (pedestal.hasRitual() && (ritual = pedestal.getRitual()).isActive()) {
                    ResourceLocation targetWorld;
                    if (ritual.getWorld() == null) {
                        ritual.setWorld(sourceLevel);
                    }
                    int portalId = (targetWorld = ritual.getTargetWorldId()) != null ? EndPortals.getPortalIdByWorld(targetWorld) : EndPortals.getPortalIdByWorld(EndPortals.OVERWORLD_ID);
                    ritual.disablePortal(portalId);
                }
                sourceLevel.m_46597_(pos, (BlockState)((BlockState)updatedState.m_61124_((Property)ACTIVATED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)HAS_LIGHT, (Comparable)Boolean.valueOf(false)));
            } else {
                ItemStack itemStack = pedestal.m_8020_(0);
                ResourceLocation id = BuiltInRegistries.f_257033_.m_7981_((Object)itemStack.m_41720_());
                if (EndPortals.isAvailableItem(id)) {
                    sourceLevel.m_46597_(pos, (BlockState)((BlockState)updatedState.m_61124_((Property)ACTIVATED, (Comparable)Boolean.valueOf(true))).m_61124_((Property)HAS_LIGHT, (Comparable)Boolean.valueOf(true)));
                    if (pedestal.hasRitual()) {
                        if (pedestal.getRitual().getWorld() == null) {
                            pedestal.getRitual().setWorld(sourceLevel);
                        }
                        pedestal.getRitual().checkStructure(player);
                    } else {
                        EternalRitual ritual = new EternalRitual(sourceLevel, pos);
                        pedestal.linkRitual(ritual);
                        ritual.checkStructure(player);
                    }
                }
            }
        }
    }

    @Override
    @Deprecated
    public BlockState m_7417_(BlockState state, Direction direction, BlockState newState, LevelAccessor world, BlockPos pos, BlockPos posFrom) {
        BlockState updated = super.m_7417_(state, direction, newState, world, pos, posFrom);
        if (!updated.m_60713_((Block)this)) {
            return updated;
        }
        if (!this.isPlaceable(updated)) {
            return (BlockState)updated.m_61124_((Property)ACTIVATED, (Comparable)Boolean.valueOf(false));
        }
        return updated;
    }

    @Deprecated
    public float m_5880_(BlockState state, Player player, BlockGetter world, BlockPos pos) {
        return 0.0f;
    }

    public float m_7325_() {
        return Blocks.f_50752_.m_7325_();
    }

    public boolean m_6903_(Explosion explosion) {
        return false;
    }

    @Override
    public List<ItemStack> m_49635_(BlockState state, LootParams.Builder builder) {
        EternalPedestalEntity pedestal;
        EndBlockProperties.PedestalState currentState;
        if (state.m_60713_((Block)this) && ((currentState = (EndBlockProperties.PedestalState)((Object)state.m_61143_(EndBlockProperties.PEDESTAL_STATE))).equals((Object)EndBlockProperties.PedestalState.BOTTOM) || currentState.equals((Object)EndBlockProperties.PedestalState.PILLAR))) {
            return Lists.newArrayList();
        }
        ArrayList drop = Lists.newArrayList();
        BlockEntity blockEntity = (BlockEntity)builder.m_287159_(LootContextParams.f_81462_);
        if (blockEntity instanceof EternalPedestalEntity && !(pedestal = (EternalPedestalEntity)blockEntity).m_7983_()) {
            drop.add(pedestal.m_8020_(0));
        }
        return drop;
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> stateManager) {
        super.m_7926_(stateManager);
        stateManager.m_61104_(new Property[]{ACTIVATED});
    }

    @Override
    public BlockEntity m_142194_(BlockPos blockPos, BlockState blockState) {
        return new EternalPedestalEntity(blockPos, blockState);
    }

    @Override
    public boolean hasUniqueEntity() {
        return true;
    }
}

