/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betterend.blocks;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.BlockHitResult;
import org.betterx.bclib.behaviours.BehaviourBuilders;
import org.betterx.bclib.blocks.BaseBlockWithEntity;
import org.betterx.bclib.interfaces.AlloyingRecipeWorkstation;
import org.betterx.betterend.blocks.entities.EndStoneSmelterBlockEntity;
import org.betterx.betterend.registry.EndBlockEntities;
import org.jetbrains.annotations.Nullable;

public class EndStoneSmelter
extends BaseBlockWithEntity.Stone
implements AlloyingRecipeWorkstation {
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.f_54117_;
    public static final BooleanProperty LIT = BlockStateProperties.f_61443_;
    public static final String ID = "end_stone_smelter";

    public EndStoneSmelter() {
        super(BehaviourBuilders.createStone((MapColor)MapColor.f_283832_).m_60953_(state -> (Boolean)state.m_61143_((Property)LIT) != false ? 15 : 0).m_60913_(4.0f, 100.0f).m_60999_());
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)LIT, (Comparable)Boolean.valueOf(false)));
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (world.f_46443_) {
            return InteractionResult.SUCCESS;
        }
        this.openScreen(world, pos, player);
        return InteractionResult.CONSUME;
    }

    private void openScreen(Level world, BlockPos pos, Player player) {
        BlockEntity blockEntity = world.m_7702_(pos);
        if (blockEntity instanceof EndStoneSmelterBlockEntity) {
            player.m_5893_((MenuProvider)((EndStoneSmelterBlockEntity)blockEntity));
        }
    }

    public BlockState m_5573_(BlockPlaceContext ctx) {
        return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)ctx.m_8125_().m_122424_());
    }

    public BlockEntity m_142194_(BlockPos blockPos, BlockState blockState) {
        return new EndStoneSmelterBlockEntity(blockPos, blockState);
    }

    public List<ItemStack> m_49635_(BlockState state, LootParams.Builder builder) {
        ArrayList drop = Lists.newArrayList((Object[])new ItemStack[]{new ItemStack((ItemLike)this)});
        BlockEntity blockEntity = (BlockEntity)builder.m_287159_(LootContextParams.f_81462_);
        if (blockEntity instanceof EndStoneSmelterBlockEntity) {
            EndStoneSmelterBlockEntity smelterBlockEntity = (EndStoneSmelterBlockEntity)blockEntity;
            for (int i = 0; i < smelterBlockEntity.m_6643_(); ++i) {
                ItemStack item = smelterBlockEntity.m_8020_(i);
                if (item.m_41619_()) continue;
                drop.add(item);
            }
        }
        return drop;
    }

    public boolean m_7278_(BlockState state) {
        return true;
    }

    public int m_6782_(BlockState state, Level world, BlockPos pos) {
        return AbstractContainerMenu.m_38918_((BlockEntity)world.m_7702_(pos));
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    public BlockState m_6843_(BlockState state, Rotation rotation) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rotation.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return state.m_60717_(mirror.m_54846_((Direction)state.m_61143_((Property)FACING)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, LIT});
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState blockState, BlockEntityType<T> blockEntityType) {
        return level.m_5776_() ? null : EndStoneSmelter.m_152132_(blockEntityType, EndBlockEntities.END_STONE_SMELTER, EndStoneSmelterBlockEntity::tick);
    }
}

