/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betterend;

import java.util.List;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Biomes;
import org.betterx.bclib.api.v2.dataexchange.DataExchangeAPI;
import org.betterx.bclib.api.v2.generator.BiomeDecider;
import org.betterx.bclib.api.v2.levelgen.biomes.BiomeAPI;
import org.betterx.betterend.advancements.BECriteria;
import org.betterx.betterend.api.BetterEndPlugin;
import org.betterx.betterend.commands.CommandRegistry;
import org.betterx.betterend.config.Configs;
import org.betterx.betterend.effects.EndPotions;
import org.betterx.betterend.integration.Integrations;
import org.betterx.betterend.integration.trinkets.Elytra;
import org.betterx.betterend.network.RitualUpdate;
import org.betterx.betterend.recipe.builders.InfusionRecipe;
import org.betterx.betterend.registry.EndBiomes;
import org.betterx.betterend.registry.EndBlockEntities;
import org.betterx.betterend.registry.EndBlocks;
import org.betterx.betterend.registry.EndEnchantments;
import org.betterx.betterend.registry.EndEntities;
import org.betterx.betterend.registry.EndFeatures;
import org.betterx.betterend.registry.EndItems;
import org.betterx.betterend.registry.EndMenuTypes;
import org.betterx.betterend.registry.EndNumericProviders;
import org.betterx.betterend.registry.EndParticles;
import org.betterx.betterend.registry.EndPoiTypes;
import org.betterx.betterend.registry.EndPortals;
import org.betterx.betterend.registry.EndSounds;
import org.betterx.betterend.registry.EndStructures;
import org.betterx.betterend.registry.EndTags;
import org.betterx.betterend.registry.EndTemplates;
import org.betterx.betterend.tab.CreativeTabs;
import org.betterx.betterend.util.BonemealPlants;
import org.betterx.betterend.util.LootTableUtil;
import org.betterx.betterend.world.generator.EndLandBiomeDecider;
import org.betterx.betterend.world.generator.GeneratorOptions;
import org.betterx.worlds.together.util.Logger;
import org.betterx.worlds.together.world.WorldConfig;

public class BetterEnd
implements ModInitializer {
    public static final String MOD_ID = "betterend";
    public static final Logger LOGGER = new Logger("betterend");
    public static final boolean RUNS_TRINKETS = FabricLoader.getInstance().getModContainer("trinkets").isPresent();

    public void onInitialize() {
        WorldConfig.registerModCache((String)MOD_ID);
        EndNumericProviders.register();
        EndPortals.loadPortals();
        EndSounds.register();
        EndMenuTypes.ensureStaticallyLoaded();
        EndBlockEntities.register();
        EndPoiTypes.register();
        EndFeatures.register();
        EndEntities.register();
        EndBiomes.register();
        EndTags.register();
        EndBlocks.ensureStaticallyLoaded();
        EndItems.register();
        EndTemplates.ensureStaticallyLoaded();
        EndEnchantments.register();
        EndPotions.register();
        InfusionRecipe.register();
        EndStructures.register();
        BonemealPlants.init();
        GeneratorOptions.init();
        LootTableUtil.init();
        CommandRegistry.register();
        EndParticles.ensureStaticallyLoadedServerside();
        BECriteria.register();
        FabricLoader.getInstance().getEntrypoints(MOD_ID, BetterEndPlugin.class).forEach(BetterEndPlugin::register);
        Integrations.init();
        Configs.saveConfigs();
        CreativeTabs.register();
        if (GeneratorOptions.useNewGenerator()) {
            BiomeDecider.registerHighPriorityDecider((ResourceLocation)BetterEnd.makeID("end_land"), (BiomeDecider)new EndLandBiomeDecider());
        }
        BiomeAPI.registerEndBiomeModification((biomeID, biome) -> {
            if (!biomeID.equals((Object)Biomes.f_48173_.m_135782_())) {
                EndFeatures.addBiomeFeatures(biomeID, (Holder<Biome>)biome);
            }
        });
        BiomeAPI.onFinishingEndBiomeTags((biomeID, biome) -> {
            if (!biomeID.equals((Object)Biomes.f_48173_.m_135782_())) {
                EndStructures.addBiomeStructures(biomeID, (Holder<Biome>)biome);
            }
        });
        DataExchangeAPI.registerDescriptors(List.of(RitualUpdate.DESCRIPTOR));
        if (RUNS_TRINKETS) {
            Elytra.register();
        }
    }

    public static ResourceLocation makeID(String path) {
        return new ResourceLocation(MOD_ID, path);
    }
}

