/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.cumulus.api;

import com.aetherteam.cumulus.CumulusConfig;
import com.aetherteam.cumulus.api.Menu;
import com.aetherteam.cumulus.api.Menus;
import com.aetherteam.cumulus.mixin.mixins.client.accessor.SplashRendererAccessor;
import com.aetherteam.cumulus.mixin.mixins.client.accessor.TitleScreenAccessor;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.TitleScreen;
import net.minecraft.sounds.Music;

public class MenuHelper {
    @Nullable
    private Menu activeMenu = null;
    @Nullable
    private TitleScreen fallbackTitleScreen = null;
    @Nullable
    private Menu.Background fallbackBackground = null;
    @Nullable
    private String lastSplash = null;
    private boolean shouldFade = true;

    @Nullable
    public Menu getActiveMenu() {
        return this.activeMenu;
    }

    public void setActiveMenu(@Nullable Menu activeMenu) {
        this.activeMenu = activeMenu;
    }

    public void prepareMenu(Menu menu) {
        if (menu.getCondition().getAsBoolean()) {
            this.setActiveMenu(menu);
        }
    }

    @Nullable
    public TitleScreen applyMenu(Menu menu) {
        if (((Boolean)CumulusConfig.CLIENT.enable_menu_api.get()).booleanValue()) {
            TitleScreen screen = this.checkFallbackScreen(menu, menu.getScreen());
            if (this.shouldFade()) {
                TitleScreenAccessor defaultMenuAccessor = (TitleScreenAccessor)screen;
                defaultMenuAccessor.cumulus$setFading(true);
                defaultMenuAccessor.cumulus$setFadeInStart(0L);
            }
            Menu.Background background = this.checkFallbackBackground(menu, screen, menu.getBackground());
            this.applyBackgrounds(background);
            if (this.getLastSplash() != null) {
                this.migrateSplash(this.getLastSplash(), screen);
            }
            menu.getApply().run();
            return screen;
        }
        return this.getFallbackTitleScreen();
    }

    private TitleScreen checkFallbackScreen(Menu menu, TitleScreen screen) {
        if ((screen.getClass() == TitleScreen.class || menu == Menus.MINECRAFT.get()) && this.getFallbackTitleScreen() != null) {
            screen = this.getFallbackTitleScreen();
        }
        return screen;
    }

    private Menu.Background checkFallbackBackground(Menu menu, TitleScreen screen, Menu.Background background) {
        if ((screen.getClass() == TitleScreen.class || menu == Menus.MINECRAFT.get()) && this.getFallbackBackground() != null) {
            background = this.getFallbackBackground();
        }
        return background;
    }

    public void clearActiveMenu() {
        this.activeMenu = (Menu)Menus.MINECRAFT.get();
    }

    @Nullable
    public TitleScreen getActiveScreen() {
        return this.getActiveMenu() != null ? this.getActiveMenu().getScreen() : null;
    }

    @Nullable
    public Music getActiveMusic() {
        return this.getActiveMenu() != null ? this.getActiveMenu().getMusic() : null;
    }

    @Nullable
    public TitleScreen getFallbackTitleScreen() {
        return this.fallbackTitleScreen;
    }

    public void setFallbackTitleScreen(@Nullable TitleScreen fallbackTitleScreen) {
        this.fallbackTitleScreen = fallbackTitleScreen;
    }

    @Nullable
    public Menu.Background getFallbackBackground() {
        return this.fallbackBackground;
    }

    public void setFallbackBackground(@Nullable Menu.Background fallbackBackground) {
        this.fallbackBackground = fallbackBackground;
    }

    @Nullable
    public String getLastSplash() {
        return this.lastSplash;
    }

    public void setLastSplash(@Nullable String lastSplash) {
        this.lastSplash = lastSplash;
    }

    public void migrateSplash(String originalSplash, TitleScreen newScreen) {
        TitleScreenAccessor newScreenAccessor = (TitleScreenAccessor)newScreen;
        if (newScreenAccessor.cumulus$getSplash() == null) {
            newScreenAccessor.setSplash(Minecraft.m_91087_().m_91310_().m_280369_());
        }
        SplashRendererAccessor splashRendererAccessor = (SplashRendererAccessor)newScreenAccessor.cumulus$getSplash();
        splashRendererAccessor.cumulus$setSplash(originalSplash);
    }

    public void setCustomSplash(TitleScreen screen, Predicate<Calendar> condition, String splash) {
        TitleScreenAccessor screenAccessor = (TitleScreenAccessor)screen;
        SplashRendererAccessor splashRendererAccessor = (SplashRendererAccessor)screenAccessor.cumulus$getSplash();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date());
        if (condition.test(calendar)) {
            splashRendererAccessor.cumulus$setSplash(splash);
        }
    }

    public void applyBackgrounds(Menu.Background background) {
        Menu.Background.apply(background);
    }

    public void resetBackgrounds() {
        Menu.Background.reset();
    }

    public boolean doesScreenMatchMenu(TitleScreen titleScreen) {
        boolean matches = false;
        List<Screen> menuScreens = Menus.getMenuScreens();
        for (Screen screen : menuScreens) {
            if (!titleScreen.getClass().equals(screen.getClass())) continue;
            matches = true;
            break;
        }
        return matches;
    }

    public boolean shouldFade() {
        return this.shouldFade;
    }

    public void setShouldFade(boolean shouldFade) {
        this.shouldFade = shouldFade;
    }
}

