/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.cumulus;

import com.aetherteam.cumulus.CumulusConfig;
import com.aetherteam.cumulus.api.Menu;
import com.aetherteam.cumulus.api.Menus;
import com.aetherteam.cumulus.data.generators.CumulusLanguageData;
import com.mojang.logging.LogUtils;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.SharedConstants;
import net.minecraft.core.Registry;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.metadata.PackMetadataGenerator;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.metadata.pack.PackMetadataSection;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryBuilder;
import org.slf4j.Logger;

@Mod(value="cumulus_menus")
public class Cumulus {
    public static final String MODID = "cumulus_menus";
    public static final Logger LOGGER = LogUtils.getLogger();
    public static final ResourceKey<Registry<Menu>> MENU_REGISTRY_KEY = ResourceKey.m_135788_((ResourceLocation)new ResourceLocation("cumulus_menus", "menu"));
    public static final DeferredRegister<Menu> DEFERRED_MENUS = DeferredRegister.create(MENU_REGISTRY_KEY, (String)MENU_REGISTRY_KEY.m_135782_().m_135827_());
    public static final Supplier<IForgeRegistry<Menu>> MENU_REGISTRY = DEFERRED_MENUS.makeRegistry(RegistryBuilder::new);

    public Cumulus() {
        DistExecutor.unsafeRunForDist(() -> () -> {
            DeferredRegister[] registers;
            IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
            modEventBus.addListener(this::dataSetup);
            for (DeferredRegister register : registers = new DeferredRegister[]{Menus.MENUS, DEFERRED_MENUS}) {
                register.register(modEventBus);
            }
            ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)CumulusConfig.CLIENT_SPEC);
            return true;
        }, () -> () -> {
            LOGGER.info("Disabling Cumulus as it is on server.");
            return false;
        });
    }

    public void dataSetup(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        PackOutput packOutput = generator.getPackOutput();
        generator.addProvider(event.includeClient(), (DataProvider)new CumulusLanguageData(packOutput));
        PackMetadataGenerator packMeta = new PackMetadataGenerator(packOutput);
        Map<PackType, Integer> packTypes = Map.of(PackType.SERVER_DATA, SharedConstants.m_183709_().m_264084_(PackType.SERVER_DATA));
        packMeta.m_247300_(PackMetadataSection.f_243696_, (Object)new PackMetadataSection((Component)Component.m_237115_((String)"pack.cumulus_menus.mod.description"), SharedConstants.m_183709_().m_264084_(PackType.CLIENT_RESOURCES), packTypes));
        generator.addProvider(true, (DataProvider)packMeta);
    }
}

