/*
 * Decompiled with CFR 0.152.
 */
package net.paladins.item;

import java.util.ArrayList;
import java.util.Map;
import java.util.function.Supplier;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.paladins.PaladinsMod;
import net.paladins.config.TweaksConfig;
import net.paladins.item.Group;
import net.spell_engine.api.item.ItemConfig;
import net.spell_engine.api.item.weapon.SpellSwordItem;
import net.spell_engine.api.item.weapon.SpellWeaponItem;
import net.spell_engine.api.item.weapon.StaffItem;
import net.spell_engine.api.item.weapon.Weapon;
import net.spell_power.api.SpellSchools;

public class Weapons {
    public static final ArrayList<Weapon.Entry> entries = new ArrayList();
    private static final String BETTER_END = "betterend";
    private static final String BETTER_NETHER = "betternether";
    private static final float claymoreHealing = 0.0f;
    public static final Weapon.Entry stone_claymore = Weapons.claymore("stone_claymore", Weapon.CustomMaterial.matching((Tiers)Tiers.STONE, () -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42594_})), 6.8f);
    public static final Weapon.Entry iron_claymore = Weapons.claymore("iron_claymore", Weapon.CustomMaterial.matching((Tiers)Tiers.IRON, () -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42416_})), 8.3f);
    public static final Weapon.Entry golden_claymore = Weapons.claymore("golden_claymore", Weapon.CustomMaterial.matching((Tiers)Tiers.GOLD, () -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42417_})), 5.2f);
    public static final Weapon.Entry diamond_claymore = Weapons.claymore("diamond_claymore", Weapon.CustomMaterial.matching((Tiers)Tiers.DIAMOND, () -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42415_})), 9.9f);
    public static final Weapon.Entry netherite_claymore = Weapons.claymore("netherite_claymore", Weapon.CustomMaterial.matching((Tiers)Tiers.NETHERITE, () -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42418_})), 11.5f);
    private static final float hammerHealing = 0.0f;
    public static final Weapon.Entry wooden_great_hammer = Weapons.hammer("wooden_great_hammer", Weapon.CustomMaterial.matching((Tiers)Tiers.WOOD, () -> Ingredient.m_204132_((TagKey)ItemTags.f_13168_)), 6.6f);
    public static final Weapon.Entry stone_great_hammer = Weapons.hammer("stone_great_hammer", Weapon.CustomMaterial.matching((Tiers)Tiers.STONE, () -> Ingredient.m_204132_((TagKey)ItemTags.f_13165_)), 8.5f);
    public static final Weapon.Entry iron_great_hammer = Weapons.hammer("iron_great_hammer", Weapon.CustomMaterial.matching((Tiers)Tiers.IRON, () -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42416_})), 10.3f);
    public static final Weapon.Entry golden_great_hammer = Weapons.hammer("golden_great_hammer", Weapon.CustomMaterial.matching((Tiers)Tiers.GOLD, () -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42417_})), 6.6f);
    public static final Weapon.Entry diamond_great_hammer = Weapons.hammer("diamond_great_hammer", Weapon.CustomMaterial.matching((Tiers)Tiers.DIAMOND, () -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42415_})), 12.2f);
    public static final Weapon.Entry netherite_great_hammer = Weapons.hammer("netherite_great_hammer", Weapon.CustomMaterial.matching((Tiers)Tiers.NETHERITE, () -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42418_})), 14.1f);
    private static final float maceHealing = 0.0f;
    public static final Weapon.Entry iron_mace = Weapons.mace("iron_mace", Weapon.CustomMaterial.matching((Tiers)Tiers.IRON, () -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42416_})), 7.0f);
    public static final Weapon.Entry golden_mace = Weapons.mace("golden_mace", Weapon.CustomMaterial.matching((Tiers)Tiers.GOLD, () -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42417_})), 4.3f);
    public static final Weapon.Entry diamond_mace = Weapons.mace("diamond_mace", Weapon.CustomMaterial.matching((Tiers)Tiers.DIAMOND, () -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42415_})), 8.3f);
    public static final Weapon.Entry netherite_mace = Weapons.mace("netherite_mace", Weapon.CustomMaterial.matching((Tiers)Tiers.NETHERITE, () -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42418_})), 9.6f);
    private static final float wandAttackDamage = 2.0f;
    private static final float wandAttackSpeed = -2.4f;
    public static final Weapon.Entry acolyte_wand = Weapons.wand("acolyte_wand", Weapon.CustomMaterial.matching((Tiers)Tiers.WOOD, () -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42398_}))).attribute(ItemConfig.Attribute.bonus((ResourceLocation)SpellSchools.HEALING.id, (float)1.0f));
    public static final Weapon.Entry holy_wand = Weapons.wand("holy_wand", Weapon.CustomMaterial.matching((Tiers)Tiers.IRON, () -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42417_}))).attribute(ItemConfig.Attribute.bonus((ResourceLocation)SpellSchools.HEALING.id, (float)2.0f));
    public static final Weapon.Entry diamond_holy_wand = Weapons.wand("diamond_holy_wand", Weapon.CustomMaterial.matching((Tiers)Tiers.DIAMOND, () -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42415_}))).attribute(ItemConfig.Attribute.bonus((ResourceLocation)SpellSchools.HEALING.id, (float)2.5f));
    public static final Weapon.Entry netherite_holy_wand = Weapons.wand("netherite_holy_wand", Weapon.CustomMaterial.matching((Tiers)Tiers.NETHERITE, () -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42418_}))).attribute(ItemConfig.Attribute.bonus((ResourceLocation)SpellSchools.HEALING.id, (float)3.0f));
    private static final float staffAttackDamage = 4.0f;
    private static final float staffAttackSpeed = -3.0f;
    public static final Weapon.Entry holy_staff = Weapons.staff("holy_staff", Weapon.CustomMaterial.matching((Tiers)Tiers.IRON, () -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42417_}))).attribute(ItemConfig.Attribute.bonus((ResourceLocation)SpellSchools.HEALING.id, (float)3.0f));
    public static final Weapon.Entry diamond_holy_staff = Weapons.staff("diamond_holy_staff", Weapon.CustomMaterial.matching((Tiers)Tiers.DIAMOND, () -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42415_}))).attribute(ItemConfig.Attribute.bonus((ResourceLocation)SpellSchools.HEALING.id, (float)4.0f));
    public static final Weapon.Entry netherite_holy_staff = Weapons.staff("netherite_holy_staff", Weapon.CustomMaterial.matching((Tiers)Tiers.NETHERITE, () -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42418_}))).attribute(ItemConfig.Attribute.bonus((ResourceLocation)SpellSchools.HEALING.id, (float)5.0f));

    private static Weapon.Entry entry(String name, Weapon.CustomMaterial material, Item item, ItemConfig.Weapon defaults) {
        return Weapons.entry(null, name, material, item, defaults);
    }

    private static Weapon.Entry entry(String requiredMod, String name, Weapon.CustomMaterial material, Item item, ItemConfig.Weapon defaults) {
        Weapon.Entry entry = new Weapon.Entry("paladins", name, material, item, defaults, null);
        if (entry.isRequiredModInstalled()) {
            entries.add(entry);
        }
        return entry;
    }

    private static Supplier<Ingredient> ingredient(String idString, boolean requirement, Item fallback) {
        ResourceLocation id = new ResourceLocation(idString);
        if (requirement) {
            return () -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{fallback});
        }
        return () -> {
            Item item = (Item)BuiltInRegistries.f_257033_.m_7745_(id);
            Item ingredient = item != null ? item : fallback;
            return Ingredient.m_43929_((ItemLike[])new ItemLike[]{ingredient});
        };
    }

    private static Weapon.Entry claymore(String name, Weapon.CustomMaterial material, float damage) {
        return Weapons.claymore(null, name, material, damage);
    }

    private static Weapon.Entry claymore(String requiredMod, String name, Weapon.CustomMaterial material, float damage) {
        Item.Properties settings = new Item.Properties();
        SpellSwordItem item = new SpellSwordItem((Tier)material, settings);
        return Weapons.entry(requiredMod, name, material, (Item)item, new ItemConfig.Weapon(damage, -3.0f));
    }

    private static Weapon.Entry hammer(String name, Weapon.CustomMaterial material, float damage) {
        return Weapons.hammer(null, name, material, damage);
    }

    private static Weapon.Entry hammer(String requiredMod, String name, Weapon.CustomMaterial material, float damage) {
        Item.Properties settings = new Item.Properties();
        SpellWeaponItem item = new SpellWeaponItem((Tier)material, settings);
        return Weapons.entry(requiredMod, name, material, (Item)item, new ItemConfig.Weapon(damage, -3.2f));
    }

    private static Weapon.Entry mace(String name, Weapon.CustomMaterial material, float damage) {
        return Weapons.mace(null, name, material, damage);
    }

    private static Weapon.Entry mace(String requiredMod, String name, Weapon.CustomMaterial material, float damage) {
        Item.Properties settings = new Item.Properties();
        SpellWeaponItem item = new SpellWeaponItem((Tier)material, settings);
        return Weapons.entry(requiredMod, name, material, (Item)item, new ItemConfig.Weapon(damage, -2.8f));
    }

    private static Weapon.Entry wand(String name, Weapon.CustomMaterial material) {
        Item.Properties settings = new Item.Properties();
        StaffItem item = new StaffItem((Tier)material, settings);
        return Weapons.entry(name, material, (Item)item, new ItemConfig.Weapon(2.0f, -2.4f));
    }

    private static Weapon.Entry staff(String name, Weapon.CustomMaterial material) {
        return Weapons.staff(null, name, material);
    }

    private static Weapon.Entry staff(String requiredMod, String name, Weapon.CustomMaterial material) {
        Item.Properties settings = new Item.Properties();
        StaffItem item = new StaffItem((Tier)material, settings);
        return Weapons.entry(requiredMod, name, material, (Item)item, new ItemConfig.Weapon(4.0f, -3.0f));
    }

    public static void register(Map<String, ItemConfig.Weapon> configs) {
        Supplier<Ingredient> repair;
        if (((TweaksConfig)PaladinsMod.tweaksConfig.value).ignore_items_required_mods || FabricLoader.getInstance().isModLoaded(BETTER_NETHER)) {
            repair = Weapons.ingredient("betternether:nether_ruby", FabricLoader.getInstance().isModLoaded(BETTER_NETHER), Items.f_42418_);
            Weapons.staff(BETTER_NETHER, "ruby_holy_staff", Weapon.CustomMaterial.matching((Tiers)Tiers.NETHERITE, repair)).attribute(ItemConfig.Attribute.bonus((ResourceLocation)SpellSchools.HEALING.id, (float)6.0f));
            Weapons.claymore("ruby_claymore", Weapon.CustomMaterial.matching((Tiers)Tiers.NETHERITE, repair), 13.0f);
            Weapons.hammer("ruby_great_hammer", Weapon.CustomMaterial.matching((Tiers)Tiers.NETHERITE, repair), 16.0f);
            Weapons.mace("ruby_mace", Weapon.CustomMaterial.matching((Tiers)Tiers.NETHERITE, repair), 11.0f);
        }
        if (((TweaksConfig)PaladinsMod.tweaksConfig.value).ignore_items_required_mods || FabricLoader.getInstance().isModLoaded(BETTER_END)) {
            repair = Weapons.ingredient("betterend:aeternium_ingot", FabricLoader.getInstance().isModLoaded(BETTER_END), Items.f_42418_);
            Weapons.claymore("aeternium_claymore", Weapon.CustomMaterial.matching((Tiers)Tiers.NETHERITE, repair), 13.0f);
            Weapons.hammer("aeternium_great_hammer", Weapon.CustomMaterial.matching((Tiers)Tiers.NETHERITE, repair), 16.0f);
            Weapons.mace("aeternium_mace", Weapon.CustomMaterial.matching((Tiers)Tiers.NETHERITE, repair), 11.0f);
        }
        Weapon.register(configs, entries, Group.KEY);
    }
}

