/*
 * Decompiled with CFR 0.152.
 */
package net.paladins.entity;

import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.level.Level;
import net.paladins.PaladinsMod;
import net.paladins.config.TweaksConfig;
import net.spell_engine.api.effect.EntityImmunity;
import net.spell_engine.api.entity.SpellSpawnedEntity;
import net.spell_engine.api.entity.TwoWayCollisionChecker;
import net.spell_engine.api.spell.Spell;
import net.spell_engine.internals.SpellRegistry;
import net.spell_engine.utils.SoundPlayerWorld;
import net.spell_engine.utils.TargetHelper;
import org.jetbrains.annotations.Nullable;

public class BarrierEntity
extends Entity
implements SpellSpawnedEntity {
    public static EntityType<BarrierEntity> TYPE;
    public static final ResourceLocation activateSoundId;
    public static final SoundEvent activateSound;
    public static final ResourceLocation idleSoundId;
    public static final SoundEvent idleSound;
    public static final ResourceLocation impactSoundId;
    public static final SoundEvent impactSound;
    public static final ResourceLocation deactivateSoundId;
    public static final SoundEvent deactivateSound;
    private ResourceLocation spellId;
    private int ownerId;
    private int timeToLive = 20;
    private static final EntityDataAccessor<String> SPELL_ID_TRACKER;
    private static final EntityDataAccessor<Integer> OWNER_ID_TRACKER;
    private static final EntityDataAccessor<Integer> TIME_TO_LIVE_TRACKER;
    private boolean idleSoundFired = false;
    private static final int checkInterval = 4;
    private LivingEntity cachedOwner = null;

    public BarrierEntity(EntityType<? extends BarrierEntity> entityType, Level world) {
        super(entityType, world);
        ((TwoWayCollisionChecker)this).setReverseCollisionChecker(entity -> this.m_7337_((Entity)entity) ? TwoWayCollisionChecker.CollisionResult.COLLIDE : TwoWayCollisionChecker.CollisionResult.PASS);
    }

    public int getTimeToLive() {
        return this.timeToLive;
    }

    public void onCreatedFromSpell(LivingEntity owner, ResourceLocation spellId, Spell.Impact.Action.Spawn spawn) {
        this.spellId = spellId;
        this.m_20088_().m_135381_(SPELL_ID_TRACKER, (Object)this.spellId.toString());
        this.ownerId = owner.m_19879_();
        this.m_20088_().m_135381_(OWNER_ID_TRACKER, (Object)this.ownerId);
        this.timeToLive = spawn.time_to_live_seconds * 20;
        this.m_20088_().m_135381_(TIME_TO_LIVE_TRACKER, (Object)this.timeToLive);
    }

    public boolean m_5829_() {
        return true;
    }

    public boolean m_6094_() {
        return false;
    }

    public boolean m_271807_() {
        return this.m_6084_();
    }

    public boolean m_7337_(Entity other) {
        LivingEntity owner = this.getOwner();
        if (owner == null) {
            return super.m_7337_(other);
        }
        if (other instanceof LivingEntity) {
            LivingEntity otherLiving = (LivingEntity)other;
            return !this.isProtected((Entity)otherLiving);
        }
        return super.m_7337_(other);
    }

    public boolean m_6469_(DamageSource source, float amount) {
        this.m_9236_().m_6269_(null, (Entity)this, impactSound, SoundSource.PLAYERS, 1.0f, 1.0f);
        return super.m_6469_(source, amount);
    }

    public EntityDimensions m_6972_(Pose pose) {
        Spell spell = this.getSpell();
        if (spell != null) {
            float width = spell.range * 2.0f;
            float height = spell.range;
            return EntityDimensions.m_20395_((float)width, (float)height);
        }
        return super.m_6972_(pose);
    }

    protected void m_8097_() {
        this.m_20088_().m_135372_(SPELL_ID_TRACKER, (Object)"");
        this.m_20088_().m_135372_(OWNER_ID_TRACKER, (Object)0);
        this.m_20088_().m_135372_(TIME_TO_LIVE_TRACKER, (Object)0);
    }

    public void m_7350_(EntityDataAccessor<?> data) {
        super.m_7350_(data);
        String rawSpellId = (String)this.m_20088_().m_135370_(SPELL_ID_TRACKER);
        if (rawSpellId != null && !rawSpellId.isEmpty()) {
            this.spellId = new ResourceLocation(rawSpellId);
        }
        this.timeToLive = (Integer)this.m_20088_().m_135370_(TIME_TO_LIVE_TRACKER);
        this.m_6210_();
    }

    protected void m_7378_(CompoundTag nbt) {
        this.spellId = new ResourceLocation(nbt.m_128461_(NBTKey.SPELL_ID.key));
        this.ownerId = nbt.m_128451_(NBTKey.OWNER_ID.key);
        this.timeToLive = nbt.m_128451_(NBTKey.TIME_TO_LIVE.key);
        this.m_20088_().m_135381_(SPELL_ID_TRACKER, (Object)this.spellId.toString());
        this.m_20088_().m_135381_(OWNER_ID_TRACKER, (Object)this.ownerId);
    }

    protected void m_7380_(CompoundTag nbt) {
        nbt.m_128359_(NBTKey.SPELL_ID.key, this.spellId.toString());
        nbt.m_128405_(NBTKey.OWNER_ID.key, this.ownerId);
        nbt.m_128405_(NBTKey.TIME_TO_LIVE.key, this.timeToLive);
    }

    public boolean m_20067_() {
        return false;
    }

    public void m_8119_() {
        super.m_8119_();
        Spell spell = this.getSpell();
        if (spell == null) {
            return;
        }
        Level world = this.m_9236_();
        if (world.m_5776_()) {
            if (!this.idleSoundFired) {
                ((SoundPlayerWorld)world).playSoundFromEntity((Entity)this, idleSound, SoundSource.PLAYERS, 1.0f, 1.0f);
                this.idleSoundFired = true;
            }
        } else {
            if (this.f_19797_ > this.timeToLive) {
                this.m_6074_();
            }
            if (this.f_19797_ % 4 == 0) {
                List entities = this.m_9236_().m_45933_((Entity)this, this.m_20191_().m_82400_((double)0.1f));
                for (Entity entity : entities) {
                    if (!(entity instanceof LivingEntity)) continue;
                    LivingEntity livingEntity = (LivingEntity)entity;
                    if (this.isProtected((Entity)livingEntity)) {
                        EntityImmunity.setImmune((Entity)livingEntity, (EntityImmunity.Type)EntityImmunity.Type.AREA_EFFECT, (int)5);
                        EntityImmunity.setImmune((Entity)livingEntity, (EntityImmunity.Type)EntityImmunity.Type.EXPLOSION, (int)5);
                        continue;
                    }
                    livingEntity.m_147240_((double)((TweaksConfig)PaladinsMod.tweaksConfig.value).barrier_knockback_strength, this.m_20185_() - livingEntity.m_20185_(), this.m_20189_() - livingEntity.m_20189_());
                }
            }
            if (this.f_19797_ == this.timeToLive - this.expirationDuration()) {
                this.m_9236_().m_6269_(null, (Entity)this, deactivateSound, SoundSource.PLAYERS, 1.0f, 1.0f);
            }
        }
    }

    public int expirationDuration() {
        return 20;
    }

    public boolean isExpiring() {
        return this.f_19797_ >= this.timeToLive - this.expirationDuration();
    }

    public boolean isProtected(Entity other) {
        LivingEntity owner = this.getOwner();
        if (owner == null) {
            return false;
        }
        TargetHelper.Relation relation = TargetHelper.getRelation((LivingEntity)owner, (Entity)other);
        switch (relation) {
            case FRIENDLY: 
            case SEMI_FRIENDLY: {
                return true;
            }
            case NEUTRAL: 
            case MIXED: 
            case HOSTILE: {
                return false;
            }
        }
        return false;
    }

    public Spell getSpell() {
        return SpellRegistry.getSpell((ResourceLocation)this.spellId);
    }

    @Nullable
    public LivingEntity getOwner() {
        if (this.cachedOwner != null) {
            return this.cachedOwner;
        }
        Entity owner = this.m_9236_().m_6815_(this.ownerId);
        if (owner instanceof LivingEntity) {
            LivingEntity livingOwner;
            this.cachedOwner = livingOwner = (LivingEntity)owner;
            return livingOwner;
        }
        return null;
    }

    static {
        activateSoundId = new ResourceLocation("paladins", "holy_barrier_activate");
        activateSound = SoundEvent.m_262824_((ResourceLocation)activateSoundId);
        idleSoundId = new ResourceLocation("paladins", "holy_barrier_idle");
        idleSound = SoundEvent.m_262824_((ResourceLocation)idleSoundId);
        impactSoundId = new ResourceLocation("paladins", "holy_barrier_impact");
        impactSound = SoundEvent.m_262824_((ResourceLocation)impactSoundId);
        deactivateSoundId = new ResourceLocation("paladins", "holy_barrier_deactivate");
        deactivateSound = SoundEvent.m_262824_((ResourceLocation)deactivateSoundId);
        SPELL_ID_TRACKER = SynchedEntityData.m_135353_(BarrierEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
        OWNER_ID_TRACKER = SynchedEntityData.m_135353_(BarrierEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
        TIME_TO_LIVE_TRACKER = SynchedEntityData.m_135353_(BarrierEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    }

    private static enum NBTKey {
        OWNER_ID("OwnerId"),
        SPELL_ID("SpellId"),
        TIME_TO_LIVE("TTL");

        public final String key;

        private NBTKey(String key) {
            this.key = key;
        }
    }
}

