/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelibarmor.renderer;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import java.util.function.BiConsumer;
import mod.azure.azurelibarmor.animatable.GeoItem;
import mod.azure.azurelibarmor.cache.object.BakedGeoModel;
import mod.azure.azurelibarmor.cache.object.GeoBone;
import mod.azure.azurelibarmor.cache.texture.AnimatableTexture;
import mod.azure.azurelibarmor.constant.DataTickets;
import mod.azure.azurelibarmor.core.animatable.GeoAnimatable;
import mod.azure.azurelibarmor.core.animation.AnimationState;
import mod.azure.azurelibarmor.core.object.DataTicket;
import mod.azure.azurelibarmor.model.GeoModel;
import mod.azure.azurelibarmor.platform.Services;
import mod.azure.azurelibarmor.renderer.GeoRenderer;
import mod.azure.azurelibarmor.renderer.layer.GeoRenderLayer;
import mod.azure.azurelibarmor.renderer.layer.GeoRenderLayersContainer;
import mod.azure.azurelibarmor.util.RenderUtils;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_308;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_5599;
import net.minecraft.class_756;
import net.minecraft.class_811;
import net.minecraft.class_824;
import net.minecraft.class_918;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;

public class GeoItemRenderer<T extends class_1792>
extends class_756
implements GeoRenderer<T> {
    protected final GeoRenderLayersContainer<T> renderLayers = new GeoRenderLayersContainer(this);
    protected final GeoModel<T> model;
    protected class_1799 currentItemStack;
    protected class_811 renderPerspective;
    protected T animatable;
    protected float scaleWidth = 1.0f;
    protected float scaleHeight = 1.0f;
    protected Matrix4f itemRenderTranslations = new Matrix4f();
    protected Matrix4f modelRenderTranslations = new Matrix4f();

    public GeoItemRenderer(GeoModel<T> model) {
        this(class_310.method_1551().method_31975(), class_310.method_1551().method_31974(), model);
    }

    public GeoItemRenderer(class_824 dispatcher, class_5599 modelSet, GeoModel<T> model) {
        super(dispatcher, modelSet);
        this.model = model;
    }

    @Override
    public GeoModel<T> getGeoModel() {
        return this.model;
    }

    @Override
    public T getAnimatable() {
        return this.animatable;
    }

    public class_1799 getCurrentItemStack() {
        return this.currentItemStack;
    }

    @Override
    public long getInstanceId(T animatable) {
        return GeoItem.getId(this.currentItemStack);
    }

    @Override
    public class_2960 getTextureLocation(T animatable) {
        return GeoRenderer.super.getTextureLocation(animatable);
    }

    @Override
    public List<GeoRenderLayer<T>> getRenderLayers() {
        return this.renderLayers.getRenderLayers();
    }

    public GeoItemRenderer<T> addRenderLayer(GeoRenderLayer<T> renderLayer) {
        this.renderLayers.addLayer(renderLayer);
        return this;
    }

    public GeoItemRenderer<T> withScale(float scale) {
        return this.withScale(scale, scale);
    }

    public GeoItemRenderer<T> withScale(float scaleWidth, float scaleHeight) {
        this.scaleWidth = scaleWidth;
        this.scaleHeight = scaleHeight;
        return this;
    }

    @Override
    public void preRender(class_4587 poseStack, T animatable, BakedGeoModel model, class_4597 bufferSource, class_4588 buffer, boolean isReRender, float partialTick, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.itemRenderTranslations = new Matrix4f((Matrix4fc)poseStack.method_23760().method_23761());
        this.scaleModelForRender(this.scaleWidth, this.scaleHeight, poseStack, (GeoAnimatable)animatable, model, isReRender, partialTick, packedLight, packedOverlay);
        if (!isReRender) {
            poseStack.method_46416(0.5f, 0.51f, 0.5f);
        }
    }

    public void method_3166(class_1799 stack, class_811 transformType, class_4587 poseStack, class_4597 bufferSource, int packedLight, int packedOverlay) {
        this.animatable = stack.method_7909();
        this.currentItemStack = stack;
        this.renderPerspective = transformType;
        if (transformType == class_811.field_4317) {
            this.renderInGui(transformType, poseStack, bufferSource, packedLight, packedOverlay);
        } else {
            class_1921 renderType = this.getRenderType((GeoAnimatable)this.animatable, this.getTextureLocation(this.animatable), bufferSource, class_310.method_1551().method_1488());
            class_4588 buffer = class_918.method_29711((class_4597)bufferSource, (class_1921)renderType, (boolean)false, (this.currentItemStack != null && this.currentItemStack.method_7958() ? 1 : 0) != 0);
            this.defaultRender(poseStack, (GeoAnimatable)this.animatable, bufferSource, renderType, buffer, 0.0f, class_310.method_1551().method_1488(), packedLight);
        }
    }

    protected void renderInGui(class_811 transformType, class_4587 poseStack, class_4597 bufferSource, int packedLight, int packedOverlay) {
        class_4597.class_4598 bufferSource2;
        class_4597.class_4598 defaultBufferSource = bufferSource instanceof class_4597.class_4598 ? (bufferSource2 = (class_4597.class_4598)bufferSource) : class_310.method_1551().field_1769.field_20951.method_23000();
        class_1921 renderType = this.getRenderType((GeoAnimatable)this.animatable, this.getTextureLocation(this.animatable), (class_4597)defaultBufferSource, class_310.method_1551().method_1488());
        class_4588 buffer = class_918.method_29711((class_4597)bufferSource, (class_1921)renderType, (boolean)true, (this.currentItemStack != null && this.currentItemStack.method_7958() ? 1 : 0) != 0);
        poseStack.method_22903();
        class_308.method_24210();
        this.defaultRender(poseStack, (GeoAnimatable)this.animatable, (class_4597)defaultBufferSource, renderType, buffer, 0.0f, class_310.method_1551().method_1488(), packedLight);
        defaultBufferSource.method_22993();
        RenderSystem.enableDepthTest();
        class_308.method_24211();
        poseStack.method_22909();
    }

    @Override
    public void actuallyRender(class_4587 poseStack, T animatable, BakedGeoModel model, class_1921 renderType, class_4597 bufferSource, class_4588 buffer, boolean isReRender, float partialTick, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        if (!isReRender) {
            AnimationState<T> animationState = new AnimationState<T>(animatable, 0.0f, 0.0f, partialTick, false);
            long instanceId = this.getInstanceId(animatable);
            animationState.setData(DataTickets.TICK, ((GeoAnimatable)animatable).getTick(this.currentItemStack));
            animationState.setData(DataTickets.ITEM_RENDER_PERSPECTIVE, this.renderPerspective);
            animationState.setData(DataTickets.ITEMSTACK, this.currentItemStack);
            ((GeoAnimatable)animatable).getAnimatableInstanceCache().getManagerForId(instanceId).setData(DataTickets.ITEM_RENDER_PERSPECTIVE, this.renderPerspective);
            this.model.addAdditionalStateData((class_1792)animatable, instanceId, (BiConsumer<DataTicket<class_1792>, class_1792>)((BiConsumer<DataTicket, class_1792>)animationState::setData));
            this.model.handleAnimations(animatable, instanceId, animationState);
        }
        this.modelRenderTranslations = new Matrix4f((Matrix4fc)poseStack.method_23760().method_23761());
        GeoRenderer.super.actuallyRender(poseStack, animatable, model, renderType, bufferSource, buffer, isReRender, partialTick, packedLight, packedOverlay, red, green, blue, alpha);
    }

    @Override
    public void renderRecursively(class_4587 poseStack, T animatable, GeoBone bone, class_1921 renderType, class_4597 bufferSource, class_4588 buffer, boolean isReRender, float partialTick, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        if (bone.isTrackingMatrices()) {
            Matrix4f poseState = new Matrix4f((Matrix4fc)poseStack.method_23760().method_23761());
            Matrix4f localMatrix = RenderUtils.invertAndMultiplyMatrices(poseState, this.itemRenderTranslations);
            bone.setModelSpaceMatrix(RenderUtils.invertAndMultiplyMatrices(poseState, this.modelRenderTranslations));
            bone.setLocalSpaceMatrix(RenderUtils.translateMatrix(localMatrix, this.getRenderOffset((class_1792)this.animatable, 1.0f).method_46409()));
        }
        GeoRenderer.super.renderRecursively(poseStack, animatable, bone, renderType, bufferSource, buffer, isReRender, partialTick, packedLight, packedOverlay, red, green, blue, alpha);
    }

    public class_243 getRenderOffset(class_1792 entity, float f) {
        return class_243.field_1353;
    }

    @Override
    public void updateAnimatedTextureFrame(T animatable) {
        AnimatableTexture.setAndUpdate(this.getTextureLocation(animatable), class_1792.method_7880(animatable) + (int)((GeoAnimatable)animatable).getTick(animatable));
    }

    @Override
    public void fireCompileRenderLayersEvent() {
        Services.GEO_RENDER_PHASE_EVENT_FACTORY.fireCompileItemRenderLayers(this);
    }

    @Override
    public boolean firePreRenderEvent(class_4587 poseStack, BakedGeoModel model, class_4597 bufferSource, float partialTick, int packedLight) {
        return Services.GEO_RENDER_PHASE_EVENT_FACTORY.fireItemPreRender(this, poseStack, model, bufferSource, partialTick, packedLight);
    }

    @Override
    public void firePostRenderEvent(class_4587 poseStack, BakedGeoModel model, class_4597 bufferSource, float partialTick, int packedLight) {
        Services.GEO_RENDER_PHASE_EVENT_FACTORY.fireItemPostRender(this, poseStack, model, bufferSource, partialTick, packedLight);
    }
}

