/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammerlib.compat.jei;

import com.google.common.base.Preconditions;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.forge.ForgeTypes;
import mezz.jei.api.gui.handlers.IGuiContainerHandler;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IGuiHandlerRegistration;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.runtime.IIngredientListOverlay;
import mezz.jei.api.runtime.IJeiRuntime;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.Level;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.zeith.hammerlib.HammerLib;
import org.zeith.hammerlib.abstractions.recipes.IRecipeVisualizer;
import org.zeith.hammerlib.abstractions.recipes.IVisualizedRecipe;
import org.zeith.hammerlib.abstractions.recipes.RecipeVisualizationRegistry;
import org.zeith.hammerlib.client.screen.IAdvancedGui;
import org.zeith.hammerlib.compat.jei.AdvancedGuiToJeiWrapper;
import org.zeith.hammerlib.compat.jei.IJeiPluginHL;
import org.zeith.hammerlib.compat.jei.JeiVisRecipeType;
import org.zeith.hammerlib.compat.jei.VisualizedRecipeCategory;
import org.zeith.hammerlib.core.RecipeHelper;
import org.zeith.hammerlib.util.java.Cast;
import org.zeith.hammerlib.util.java.tuples.Tuple2;
import org.zeith.hammerlib.util.mcf.ScanDataHelper;

@JeiPlugin
public class JeiHammerLib
implements IModPlugin,
IJeiPluginHL {
    public static final Logger LOG = LogManager.getLogger(JeiHammerLib.class);
    public static final ResourceLocation HL_PLUGIN = new ResourceLocation("hammerlib", "jei");
    public static final Map<Class<?>, IIngredientType<?>> INGREDIENT_TYPES = new HashMap();
    IJeiRuntime runtime;
    static final RecipeVisualizationRegistry visRegistry = new RecipeVisualizationRegistry();
    static final Map<net.minecraft.world.item.crafting.RecipeType<?>, RecipeType<?>> MC2JEI = new HashMap();

    public JeiHammerLib() {
        IJeiPluginHL.Container.active = this;
        JeiHammerLib.registerType(ItemStack.class, VanillaTypes.ITEM_STACK);
        JeiHammerLib.registerType(FluidStack.class, ForgeTypes.FLUID_STACK);
    }

    public static <T> Optional<IIngredientType<T>> findType(Class<T> type) {
        Class<T> cl = type;
        do {
            if (!INGREDIENT_TYPES.containsKey(cl = cl.getSuperclass())) continue;
            return (Optional)Cast.cast(Optional.of(INGREDIENT_TYPES.get(cl)));
        } while (cl != null);
        return Optional.empty();
    }

    public static <T> void registerType(Class<T> type, IIngredientType<T> iType) {
        Preconditions.checkNotNull(type, (Object)"type");
        Preconditions.checkNotNull(iType, (Object)"iType");
        INGREDIENT_TYPES.put(type, iType);
    }

    public ResourceLocation getPluginUid() {
        return HL_PLUGIN;
    }

    public void onRuntimeAvailable(IJeiRuntime jeiRuntime) {
        this.runtime = jeiRuntime;
    }

    RecipeType jeiFromMc(Tuple2<net.minecraft.world.item.crafting.RecipeType<?>, IRecipeVisualizer<?, ?>> tup) {
        net.minecraft.world.item.crafting.RecipeType<?> type = tup.a();
        ResourceLocation typeID = ForgeRegistries.RECIPE_TYPES.getKey(type);
        if (typeID == null) {
            return null;
        }
        IRecipeVisualizer<?, ?> vis = tup.b();
        return (RecipeType)Cast.cast(MC2JEI.computeIfAbsent(type, vanilla -> new RecipeType(typeID, vis.getVisualizedType())));
    }

    public Stream<Tuple2<net.minecraft.world.item.crafting.RecipeType<?>, IRecipeVisualizer<?, ?>>> getVisualizedEntries() {
        return visRegistry.getVisualizedEntries();
    }

    public void registerCategories(IRecipeCategoryRegistration registration) {
        visRegistry.reload();
        this.getVisualizedEntries().forEach(tup -> {
            RecipeType jeiRT = this.jeiFromMc((Tuple2<net.minecraft.world.item.crafting.RecipeType<?>, IRecipeVisualizer<?, ?>>)tup);
            if (jeiRT == null) {
                return;
            }
            VisualizedRecipeCategory cat = new VisualizedRecipeCategory(jeiRT, ((IRecipeVisualizer)tup.b()).getGroup());
            registration.addRecipeCategories(new IRecipeCategory[]{cat});
        });
    }

    public void registerRecipes(IRecipeRegistration registration) {
        this.getVisualizedEntries().forEach(tup -> {
            RecipeType jeiRT = this.jeiFromMc((Tuple2<net.minecraft.world.item.crafting.RecipeType<?>, IRecipeVisualizer<?, ?>>)tup);
            if (jeiRT == null) {
                return;
            }
            net.minecraft.world.item.crafting.RecipeType type = (net.minecraft.world.item.crafting.RecipeType)tup.a();
            ResourceLocation typeID = ForgeRegistries.RECIPE_TYPES.getKey((Object)type);
            if (typeID == null) {
                return;
            }
            this.registerRecipesFor(registration, type, jeiRT, (IRecipeVisualizer)tup.b());
        });
        HammerLib.EVENT_BUS.post((Event)new RecipeVisualizationRegistry.RegisterIngredientInfoEvent((arg_0, arg_1) -> ((IRecipeRegistration)registration).addItemStackInfo(arg_0, arg_1), (fluidStacks, components) -> registration.addIngredientInfo(fluidStacks, (IIngredientType)ForgeTypes.FLUID_STACK, components)));
    }

    private <R extends Recipe<C>, C extends Container, T extends IVisualizedRecipe<R>> void registerRecipesFor(IRecipeRegistration reg, net.minecraft.world.item.crafting.RecipeType<R> recipeType, RecipeType<T> type, IRecipeVisualizer<R, T> visualizer) {
        List<IVisualizedRecipe> lst = JeiHammerLib.getRecipes(recipeType).map(visualizer::visualize).toList();
        reg.addRecipes(type, lst);
    }

    public void registerGuiHandlers(IGuiHandlerRegistration registration) {
        this.getVisualizedEntries().forEach(tup -> {
            RecipeType jeiRT = this.jeiFromMc((Tuple2<net.minecraft.world.item.crafting.RecipeType<?>, IRecipeVisualizer<?, ?>>)tup);
            if (jeiRT == null) {
                return;
            }
            IRecipeVisualizer vis = (IRecipeVisualizer)tup.b();
            IRecipeVisualizer.VisualizedRecipeGroup g = vis.getGroup();
            for (IRecipeVisualizer.ClickArea area : g.clickAreas()) {
                registration.addRecipeClickArea(area.menu(), area.x(), area.y(), area.width(), area.height(), new RecipeType[]{jeiRT});
            }
        });
        for (ScanDataHelper.ModAwareAnnotationData data : ScanDataHelper.lookupAnnotatedObjects(IRecipeVisualizer.JEIClickArea.class).stream().toList()) {
            try {
                Field f2 = data.getOwnerClass().getDeclaredField(data.getMemberName());
                f2.setAccessible(true);
                Object obj = f2.get(null);
                IRecipeVisualizer.ClickArea unas = null;
                RecipeType jeiType = null;
                if (obj instanceof IRecipeVisualizer.AssignedClickArea) {
                    IRecipeVisualizer.AssignedClickArea assigned = (IRecipeVisualizer.AssignedClickArea)obj;
                    unas = assigned.area();
                    jeiType = JeiVisRecipeType.getJEIType(assigned.type());
                } else if (obj instanceof IRecipeVisualizer.JeiBasedClickArea) {
                    IRecipeVisualizer.JeiBasedClickArea jb = (IRecipeVisualizer.JeiBasedClickArea)obj;
                    unas = jb.area();
                    try {
                        jeiType = (RecipeType)jb.type().staticGet();
                    }
                    catch (Throwable e) {
                        LOG.error("Failed to staticGet JEI RecipeType from " + jb.type());
                    }
                }
                if (jeiType == null || unas == null) {
                    LOG.warn("Tried to assign a click area to non-visualized recipe type. This is not supposed to happen!");
                    continue;
                }
                registration.addRecipeClickArea(unas.menu(), unas.x(), unas.y(), unas.width(), unas.height(), new RecipeType[]{jeiType});
            }
            catch (ReflectiveOperationException e) {
                LOG.error("Failed to read click area " + data.clazz() + "." + data.getMemberName());
            }
        }
        ScanDataHelper.lookupAnnotatedObjects(IAdvancedGui.ApplyToJEI.class).stream().map(ScanDataHelper.ModAwareAnnotationData::getOwnerClass).filter(raw -> AbstractContainerScreen.class.isAssignableFrom((Class<?>)raw) && IAdvancedGui.class.isAssignableFrom((Class<?>)raw)).forEach(f -> registration.addGuiContainerHandler(f.asSubclass(AbstractContainerScreen.class), (IGuiContainerHandler)Cast.cast(AdvancedGuiToJeiWrapper.get())));
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        this.getVisualizedEntries().forEach(tup -> {
            RecipeType jeiRT = this.jeiFromMc((Tuple2<net.minecraft.world.item.crafting.RecipeType<?>, IRecipeVisualizer<?, ?>>)tup);
            if (jeiRT == null) {
                return;
            }
            IRecipeVisualizer vis = (IRecipeVisualizer)tup.b();
            IRecipeVisualizer.VisualizedRecipeGroup g = vis.getGroup();
            for (ItemStack stack : g.catalyst()) {
                registration.addRecipeCatalyst(stack, new RecipeType[]{jeiRT});
            }
        });
    }

    @Override
    public <T> Optional<T> getIngredientUnderMouseJEI(Class<T> type) {
        return Optional.ofNullable(this.runtime).map(IJeiRuntime::getIngredientListOverlay).flatMap(IIngredientListOverlay::getIngredientUnderMouse).filter(ing -> ing.getType().getIngredientClass().equals(ing.getType().getIngredientClass())).filter(ing -> type.isInstance(ing.getIngredient())).map(ing -> Cast.cast(ing.getIngredient()));
    }

    public static <T extends Recipe<C>, C extends Container> Stream<T> getRecipes(net.minecraft.world.item.crafting.RecipeType<T> type) {
        ClientLevel lvl = Minecraft.m_91087_().f_91073_;
        return lvl != null ? RecipeHelper.getRecipes((Level)lvl, type) : Stream.of(new Recipe[0]);
    }
}

