/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammerlib.api.fluid;

import com.google.common.base.Suppliers;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.PushReaction;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidType;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.ForgeFlowingFluid;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegisterEvent;
import org.jetbrains.annotations.Nullable;
import org.zeith.hammerlib.api.fluid.FluidTypeHL;
import org.zeith.hammerlib.api.fml.ICustomRegistrar;
import org.zeith.hammerlib.api.fml.IRegisterListener;
import org.zeith.hammerlib.api.items.CreativeTab;
import org.zeith.hammerlib.core.adapter.TagAdapter;
import org.zeith.hammerlib.util.java.Cast;
import org.zeith.hammerlib.util.mcf.fluid.FluidIngredient;
import org.zeith.hammerlib.util.mcf.fluid.FluidIngredientStack;

public class FluidFactory
implements ICustomRegistrar,
ItemLike {
    public final FluidType type;
    public final Supplier<Item> bucket;
    public final ForgeFlowingFluid.Properties fluidProps;
    public final Supplier<ForgeFlowingFluid.Source> source;
    public final Supplier<ForgeFlowingFluid.Flowing> flowing;
    public final Supplier<LiquidBlock> block;
    protected Supplier<Supplier<RenderType>> renderType = () -> RenderType::m_110451_;
    protected final List<TagKey<Fluid>> fluidTags = Lists.newArrayList();
    protected final List<CreativeTab> tabs = Lists.newArrayList();

    public FluidFactory(Supplier<FluidType> typeGenerator, Function<Supplier<FlowingFluid>, Item> bucket, UnaryOperator<ForgeFlowingFluid.Properties> propertyModifier, Function<Supplier<? extends FlowingFluid>, LiquidBlock> block, Function<ForgeFlowingFluid.Properties, ForgeFlowingFluid.Source> sourceGen, Function<ForgeFlowingFluid.Properties, ForgeFlowingFluid.Flowing> flowingGen) {
        this.type = typeGenerator.get();
        this.block = block != null ? Suppliers.memoize(() -> (LiquidBlock)block.apply(this::getFlowing)) : null;
        this.bucket = bucket != null ? Suppliers.memoize(() -> {
            Item item = (Item)bucket.apply(this::getSource);
            for (CreativeTab tab : this.tabs) {
                tab.add(item);
            }
            return item;
        }) : null;
        ForgeFlowingFluid.Properties fp = new ForgeFlowingFluid.Properties(this::getType, this::getSource, this::getFlowing);
        if (this.block != null) {
            fp = fp.block(this::getBlock);
        }
        if (this.bucket != null) {
            fp = fp.bucket(this::getBucket);
        }
        this.fluidProps = propertyModifier != null ? (ForgeFlowingFluid.Properties)propertyModifier.apply(fp) : fp;
        this.source = Suppliers.memoize(() -> (ForgeFlowingFluid.Source)sourceGen.apply(this.fluidProps));
        this.flowing = Suppliers.memoize(() -> (ForgeFlowingFluid.Flowing)flowingGen.apply(this.fluidProps));
    }

    protected FluidFactory addFluidTags(Collection<TagKey<Fluid>> fluidTags) {
        this.fluidTags.addAll(fluidTags);
        return this;
    }

    protected FluidFactory withRenderType(Supplier<Supplier<RenderType>> renderType) {
        this.renderType = renderType;
        return this;
    }

    protected FluidFactory addToTabs(Collection<CreativeTab> tab) {
        this.tabs.addAll(tab);
        return this;
    }

    public FluidStack stack(int amount) {
        return new FluidStack((Fluid)this.source.get(), amount);
    }

    public FluidIngredient ingredient() {
        return FluidIngredient.ofFluids(List.of(new FluidStack((Fluid)this.source.get(), 1)));
    }

    public FluidIngredientStack ingredient(int amount) {
        return new FluidIngredientStack(this.ingredient(), amount);
    }

    public FluidType getType() {
        return this.type;
    }

    public ForgeFlowingFluid.Source getSource() {
        return this.source.get();
    }

    public BlockState getSourceBlockState() {
        return this.source.get().m_76068_(false).m_76188_();
    }

    public ForgeFlowingFluid.Flowing getFlowing() {
        return this.flowing.get();
    }

    @Nullable
    public Item getBucket() {
        return this.bucket != null ? this.bucket.get() : null;
    }

    @Nullable
    public LiquidBlock getBlock() {
        return this.block != null ? this.block.get() : null;
    }

    public ResourceLocation subId(ResourceLocation fluidId, String thing) {
        return new ResourceLocation(fluidId.m_135827_(), fluidId.m_135815_() + "_" + thing);
    }

    public boolean is(Fluid fluid) {
        return fluid == this.source || fluid == this.flowing;
    }

    public boolean is(FluidType fluid) {
        return fluid == this.type;
    }

    public boolean is(FluidStack fluid) {
        return fluid != null && !fluid.isEmpty() && this.is(fluid.getFluid());
    }

    public boolean is(Block fluid) {
        return fluid == this.getBlock();
    }

    public boolean is(Item bucket) {
        return bucket == this.getBucket();
    }

    public boolean has(ItemStack stack) {
        return !stack.m_41619_() && FluidUtil.getFluidHandler((ItemStack)stack).resolve().map(h -> {
            int t = h.getTanks();
            for (int i = 0; i < t; ++i) {
                FluidStack ft = h.getFluidInTank(i);
                if (!this.is(ft)) continue;
                return true;
            }
            return false;
        }).orElse(false) != false;
    }

    public boolean has(ItemStack stack, int minAmount) {
        return !stack.m_41619_() && FluidUtil.getFluidHandler((ItemStack)stack).resolve().map(h -> {
            int amt = 0;
            int t = h.getTanks();
            for (int i = 0; i < t; ++i) {
                FluidStack ft = h.getFluidInTank(i);
                if (!this.is(ft) || (amt += ft.getAmount()) < minAmount) continue;
                return true;
            }
            return amt >= minAmount;
        }).orElse(false) != false;
    }

    @Override
    public void performRegister(RegisterEvent e, ResourceLocation fluidId) {
        IRegisterListener rl;
        FluidType fluidType;
        ResourceKey key = e.getRegistryKey();
        if (ForgeRegistries.Keys.FLUID_TYPES.equals((Object)key)) {
            fluidType = this.type;
            if (fluidType instanceof IRegisterListener) {
                rl = (IRegisterListener)fluidType;
                rl.onPreRegistered(fluidId);
            }
            e.register(ForgeRegistries.Keys.FLUID_TYPES, fluidId, Cast.constant(this.type));
            fluidType = this.type;
            if (fluidType instanceof IRegisterListener) {
                rl = (IRegisterListener)fluidType;
                rl.onPostRegistered(fluidId);
            }
        }
        if (ForgeRegistries.Keys.FLUIDS.equals((Object)key)) {
            fluidType = this.getSource();
            if (fluidType instanceof IRegisterListener) {
                rl = (IRegisterListener)fluidType;
                rl.onPreRegistered(fluidId);
            }
            if ((fluidType = this.getFlowing()) instanceof IRegisterListener) {
                rl = (IRegisterListener)fluidType;
                rl.onPreRegistered(this.subId(fluidId, "flow"));
            }
            e.register(ForgeRegistries.Keys.FLUIDS, fluidId, this.source::get);
            e.register(ForgeRegistries.Keys.FLUIDS, this.subId(fluidId, "flow"), this.flowing::get);
            fluidType = this.getSource();
            if (fluidType instanceof IRegisterListener) {
                rl = (IRegisterListener)fluidType;
                rl.onPostRegistered(fluidId);
            }
            if ((fluidType = this.getFlowing()) instanceof IRegisterListener) {
                rl = (IRegisterListener)fluidType;
                rl.onPostRegistered(this.subId(fluidId, "flow"));
            }
            DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> ItemBlockRenderTypes.setRenderLayer((Fluid)this.getSource(), (RenderType)((RenderType)Cast.get2(this.renderType))));
            DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> ItemBlockRenderTypes.setRenderLayer((Fluid)this.getFlowing(), (RenderType)((RenderType)Cast.get2(this.renderType))));
        }
        if (this.block != null && ForgeRegistries.Keys.BLOCKS.equals((Object)key)) {
            fluidType = this.getBlock();
            if (fluidType instanceof IRegisterListener) {
                rl = (IRegisterListener)fluidType;
                rl.onPreRegistered(this.subId(fluidId, "bucket"));
            }
            e.register(ForgeRegistries.Keys.BLOCKS, fluidId, this.block::get);
            fluidType = this.getBlock();
            if (fluidType instanceof IRegisterListener) {
                rl = (IRegisterListener)fluidType;
                rl.onPostRegistered(this.subId(fluidId, "bucket"));
            }
        }
        if (this.bucket != null && ForgeRegistries.Keys.ITEMS.equals((Object)key)) {
            fluidType = this.getBucket();
            if (fluidType instanceof IRegisterListener) {
                rl = (IRegisterListener)fluidType;
                rl.onPreRegistered(this.subId(fluidId, "bucket"));
            }
            e.register(ForgeRegistries.Keys.ITEMS, this.subId(fluidId, "bucket"), this.bucket);
            fluidType = this.getBucket();
            if (fluidType instanceof IRegisterListener) {
                rl = (IRegisterListener)fluidType;
                rl.onPostRegistered(this.subId(fluidId, "bucket"));
            }
        }
        for (TagKey<Fluid> tag : this.fluidTags) {
            TagAdapter.bind(tag, (Fluid)this.source.get(), (Fluid)this.flowing.get());
        }
    }

    public Item m_5456_() {
        return this.bucket.get();
    }

    public static Builder builder(Supplier<FluidType> typeGenerator) {
        return new Builder(typeGenerator);
    }

    public static Builder builder(FluidType.Properties typeProps) {
        return new Builder(() -> new FluidTypeHL(typeProps));
    }

    public static class Builder {
        protected final Supplier<FluidType> typeGenerator;
        protected final List<TagKey<Fluid>> fluidTags = Lists.newArrayList();
        protected final List<CreativeTab> tabs = Lists.newArrayList();
        protected UnaryOperator<ForgeFlowingFluid.Properties> propertyModifier = UnaryOperator.identity();
        protected Function<Supplier<FlowingFluid>, Item> bucket;
        protected Function<Supplier<? extends FlowingFluid>, LiquidBlock> block;
        protected Function<ForgeFlowingFluid.Properties, ForgeFlowingFluid.Source> sourceGen = ForgeFlowingFluid.Source::new;
        protected Function<ForgeFlowingFluid.Properties, ForgeFlowingFluid.Flowing> flowingGen = ForgeFlowingFluid.Flowing::new;
        protected Supplier<Supplier<RenderType>> renderType = () -> RenderType::m_110451_;

        public Builder(Supplier<FluidType> typeGenerator) {
            this.typeGenerator = typeGenerator;
        }

        public Builder withBucket() {
            return this.withBucket(fluid -> new BucketItem(fluid, new Item.Properties().m_41495_(Items.f_42446_).m_41487_(1)));
        }

        public Builder withBlock() {
            return this.withBlock(flowing -> new LiquidBlock(flowing, BlockBehaviour.Properties.m_284310_().m_280170_().m_60910_().m_60978_(100.0f).m_278166_(PushReaction.DESTROY).m_222994_().m_278788_().m_60918_(SoundType.f_279557_)));
        }

        public Builder propertyModifier(UnaryOperator<ForgeFlowingFluid.Properties> propertyModifier) {
            UnaryOperator<ForgeFlowingFluid.Properties> pm = this.propertyModifier;
            this.propertyModifier = v -> (ForgeFlowingFluid.Properties)propertyModifier.apply((ForgeFlowingFluid.Properties)pm.apply((ForgeFlowingFluid.Properties)v));
            return this;
        }

        public Builder withBucket(Function<Supplier<FlowingFluid>, Item> bucket) {
            this.bucket = bucket;
            return this;
        }

        public Builder withBlock(Function<Supplier<? extends FlowingFluid>, LiquidBlock> block) {
            this.block = block;
            return this;
        }

        public Builder withSource(Function<ForgeFlowingFluid.Properties, ForgeFlowingFluid.Source> sourceGen) {
            this.sourceGen = sourceGen;
            return this;
        }

        public Builder withFlowing(Function<ForgeFlowingFluid.Properties, ForgeFlowingFluid.Flowing> flowingGen) {
            this.flowingGen = flowingGen;
            return this;
        }

        public Builder withRenderType(Supplier<Supplier<RenderType>> renderType) {
            this.renderType = renderType;
            return this;
        }

        public Builder addFluidTag(TagKey<Fluid> tag) {
            this.fluidTags.add(tag);
            return this;
        }

        public Builder addFluidTags(List<TagKey<Fluid>> fluidTags) {
            this.fluidTags.addAll(fluidTags);
            return this;
        }

        public Builder addToTab(CreativeTab tab) {
            this.tabs.add(tab);
            return this;
        }

        public Builder addToTabs(Collection<CreativeTab> tab) {
            this.tabs.addAll(tab);
            return this;
        }

        public FluidFactory build() {
            return new FluidFactory(this.typeGenerator, this.bucket, this.propertyModifier, this.block, this.sourceGen, this.flowingGen).withRenderType(this.renderType).addFluidTags(this.fluidTags).addToTabs(this.tabs);
        }
    }
}

